/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.validation;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.url.template.UrlTemplate;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.dataSource.validation.NamedProgressive;
import com.intellij.database.util.DbImplUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseDriverValidator
extends DatabaseConfigValidator.Typed<DatabaseDriverImpl> {
    public DatabaseDriverValidator() {
        super(DatabaseDriverImpl.class);
    }

    @Override
    public void findProblemsTyped(@NotNull DatabaseDriverImpl driver, @NotNull Consumer<DataSourceProblem> problems) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "findProblemsTyped"));
        }
        if (problems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problems", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "findProblemsTyped"));
        }
        if (!driver.getTemplatesErrors().isEmpty()) {
            StringBuilder msg = new StringBuilder();
            for (Pair<UrlTemplate, String> pair : driver.getTemplatesErrors()) {
                msg.append("<br>&nbsp;&nbsp;&nbsp;&nbsp;");
                msg.append(StringUtil.escapeXml((String)((UrlTemplate)pair.getFirst()).getName())).append(" &mdash; ").append(StringUtil.escapeXml((String)((String)pair.getSecond())));
            }
            String shortDesc = msg.toString();
            String longDesc = "Driver <a href=\"$ACTION0\">" + StringUtil.escapeXml((String)driver.getFullName()) + "</a> has invalid templates:" + shortDesc;
            problems.consume((Object)new DataSourceProblem((Object)driver, null, "Invalid template", shortDesc, longDesc, null, new DataSourceProblem.Navigate(driver)));
        }
    }

    public static void findDriverFilesProblems(@Nullable DatabaseDriver driver, boolean domainAuth, @NotNull Consumer<DataSourceProblem> problems) {
        if (problems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problems", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "findDriverFilesProblems"));
        }
        if (driver == null) {
            return;
        }
        if (StringUtil.isNotEmpty((String)driver.getArtifactName())) {
            String title = IdeBundle.message((String)"progress.download.0.title", (Object[])new Object[]{StringUtil.capitalize((String)driver.getArtifactName()) + " files"});
            NamedProgressive download = NamedProgressive.named(title, driver.downloadDriverTask());
            String driverName = StringUtil.escapeXml((String)driver.getFullName());
            if (!driver.isDownloaded()) {
                problems.consume((Object)new DataSourceProblem((Object)driver, null, "", "<a href=\"$ACTION0\">Download</a> missing driver files", "Download missing <a href=\"$ACTION1\">" + driverName + "</a> driver files", download, download, new DataSourceProblem.Navigate(driver)));
            } else if (DbImplUtil.needUpdateDriverFiles(domainAuth, driver)) {
                problems.consume((Object)new DataSourceProblem((Object)driver, null, "", "<a href=\"$ACTION0\">Update</a> driver files", "Update <a href=\"$ACTION1\">" + driverName + "</a> driver files", download, download, new DataSourceProblem.Navigate(driver)));
            }
        }
    }
}

