/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatter;
import com.intellij.database.datagrid.CsvFormatParser;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DocumentDataHookUp;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.NamedRow;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvDocumentDataHookUp
extends DocumentDataHookUp {
    protected CsvFormatParser myParser;

    public CsvDocumentDataHookUp(@NotNull Project project, @NotNull CsvFormat format, @NotNull Document document, @Nullable TextRange range) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/datagrid/CsvDocumentDataHookUp", "<init>"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/CsvDocumentDataHookUp", "<init>"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/database/datagrid/CsvDocumentDataHookUp", "<init>"));
        }
        super(project, document, range);
        this.myParser = new CsvFormatParser(format);
    }

    public void setFormat(@NotNull CsvFormat format) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/CsvDocumentDataHookUp", "setFormat"));
        }
        this.myParser = new CsvFormatParser(format);
        this.getLoader().reloadCurrentPage(new GridRequestSource(null, this));
    }

    @NotNull
    public CsvFormat getFormat() {
        CsvFormat csvFormat = this.myParser.getDataFormat();
        if (csvFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvDocumentDataHookUp", "getFormat"));
        }
        return csvFormat;
    }

    @Override
    @Nullable
    protected CsvMarkup buildMarkup(@NotNull CharSequence sequence, @NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/CsvDocumentDataHookUp", "buildMarkup"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/CsvDocumentDataHookUp", "buildMarkup"));
        }
        return this.myParser.parse(sequence.toString());
    }

    @NotNull
    static List<String> values(@NotNull CharSequence sequence, @NotNull List<ValueRange> ranges) {
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/CsvDocumentDataHookUp", "values"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/database/datagrid/CsvDocumentDataHookUp", "values"));
        }
        List list = ContainerUtil.map(ranges, range -> {
            if (sequence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/CsvDocumentDataHookUp", "lambda$values$0"));
            }
            return range.value(sequence).toString();
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvDocumentDataHookUp", "values"));
        }
        return list;
    }

    static class ValueRange
    extends TextRange {
        ValueRange(int startOffset, int endOffset) {
            super(startOffset, endOffset);
        }

        CharSequence value(CharSequence s) {
            return this.subSequence(s);
        }
    }

    public static class CsvRecord {
        public final TextRange range;
        public final List<ValueRange> values;
        public final boolean hasRecordSeparator;

        CsvRecord(@NotNull TextRange range, @NotNull List<ValueRange> values, boolean hasRecordSeparator) {
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvRecord", "<init>"));
            }
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvRecord", "<init>"));
            }
            this.range = range;
            this.values = values;
            this.hasRecordSeparator = hasRecordSeparator;
        }
    }

    public static class CsvMarkup
    extends DocumentDataHookUp.DataMarkup {
        private final List<CsvRecord> myRecords;
        private final CsvRecord myHeader;
        private final CsvFormatter myFormatter;

        protected CsvMarkup(@NotNull CsvFormatter formatter, @NotNull CharSequence sequence, @NotNull List<CsvRecord> records, @Nullable CsvRecord header, boolean rowNumbers) {
            if (formatter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatter", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "<init>"));
            }
            if (sequence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "<init>"));
            }
            if (records == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "<init>"));
            }
            super(CsvMarkup.columnsFrom(sequence, records, header, rowNumbers), CsvMarkup.rowsFrom(sequence, records, rowNumbers));
            this.myFormatter = formatter;
            this.myHeader = header;
            this.myRecords = records;
        }

        public CsvMarkup(@NotNull CsvFormatter formatter, @NotNull List<DataConsumer.Column> columns, @NotNull List<DataConsumer.Row> rows, @NotNull List<CsvRecord> records, @Nullable CsvRecord header) {
            if (formatter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatter", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "<init>"));
            }
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "<init>"));
            }
            if (rows == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "<init>"));
            }
            if (records == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "<init>"));
            }
            super(columns, rows);
            this.myFormatter = formatter;
            this.myHeader = header;
            this.myRecords = records;
        }

        public List<CsvRecord> getRecords() {
            return this.myRecords;
        }

        public CsvRecord getHeader() {
            return this.myHeader;
        }

        public CsvFormatter getFormatter() {
            return this.myFormatter;
        }

        @Override
        protected boolean deleteRows(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull List<DataConsumer.Row> sortedRows) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "deleteRows"));
            }
            if (sortedRows == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortedRows", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "deleteRows"));
            }
            for (DataConsumer.Row row : sortedRows) {
                session.delete(this.myRecords.get((int)(row.rowNum - 1)).range);
            }
            return true;
        }

        @Override
        protected boolean insertRow(@NotNull DocumentDataHookUp.UpdateSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "insertRow"));
            }
            return this.insertRow(session, JBIterable.of((Object[])new Object[]{null}).repeat(this.columns.size()).toList());
        }

        @Override
        protected boolean cloneRow(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull DataConsumer.Row row) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "cloneRow"));
            }
            if (row == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "cloneRow"));
            }
            return this.insertRow(session, (List<?>)ContainerUtil.immutableList((Object[])row.values));
        }

        @Override
        protected boolean deleteColumns(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull List<DataConsumer.Column> sortedColumns) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "deleteColumns"));
            }
            if (sortedColumns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortedColumns", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "deleteColumns"));
            }
            List<DataConsumer.Column> columnsToLeave = this.getColumnsToLeave(sortedColumns);
            if (this.myHeader != null) {
                this.leaveColumns(session, columnsToLeave, this.myHeader);
            }
            for (int i = 0; i < this.rows.size(); ++i) {
                this.leaveColumns(session, columnsToLeave, this.myRecords.get(i), (DataConsumer.Row)this.rows.get(i));
            }
            return true;
        }

        @Override
        protected boolean insertColumn(@NotNull DocumentDataHookUp.UpdateSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "insertColumn"));
            }
            return this.insertColumn(session, null);
        }

        @Override
        protected boolean cloneColumn(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull DataConsumer.Column column) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "cloneColumn"));
            }
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "cloneColumn"));
            }
            return this.insertColumn(session, column);
        }

        @Override
        protected boolean update(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull List<DataConsumer.Row> sortedRows, @NotNull List<DataConsumer.Column> sortedColumns, @Nullable Object newValue) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "update"));
            }
            if (sortedRows == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortedRows", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "update"));
            }
            if (sortedColumns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortedColumns", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "update"));
            }
            String newValueText = this.myFormatter.formatValue(newValue);
            for (DataConsumer.Row row : sortedRows) {
                List<ValueRange> valueRanges = this.myRecords.get((int)(row.rowNum - 1)).values;
                for (DataConsumer.Column column : sortedColumns) {
                    int rangeIdx = column.columnNum + (row instanceof NamedRow ? 1 : 0);
                    session.replace(valueRanges.get(rangeIdx), newValueText);
                }
            }
            return true;
        }

        private boolean insertColumn(@NotNull DocumentDataHookUp.UpdateSession session, @Nullable DataConsumer.Column column) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "insertColumn"));
            }
            if (this.myHeader != null) {
                ValueRange lastColumnRange = (ValueRange)((Object)ObjectUtils.assertNotNull((Object)ContainerUtil.getLastItem(this.myHeader.values)));
                String columnName = this.myFormatter.formatHeaderValue(column != null ? column.name : "column" + (this.columns.size() + 1));
                session.insert(this.myFormatter.headerValueSeparator() + columnName, lastColumnRange.getEndOffset());
            }
            for (int i = 0; i < this.rows.size(); ++i) {
                ValueRange lastValueRange = (ValueRange)((Object)ObjectUtils.assertNotNull((Object)ContainerUtil.getLastItem(this.myRecords.get((int)i).values)));
                String valueText = this.myFormatter.formatValue(column != null ? column.getValue((DataConsumer.Row)this.rows.get(i)) : null);
                session.insert(this.myFormatter.valueSeparator() + valueText, lastValueRange.getEndOffset());
            }
            return true;
        }

        private boolean insertRow(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull List<?> values) {
            int offset;
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "insertRow"));
            }
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "insertRow"));
            }
            CsvRecord lastRecord = (CsvRecord)ObjectUtils.chooseNotNull((Object)ContainerUtil.getLastItem(this.myRecords), (Object)this.myHeader);
            int n = offset = lastRecord != null ? lastRecord.range.getEndOffset() : 0;
            if (lastRecord != null && !lastRecord.hasRecordSeparator) {
                session.insert(this.myFormatter.recordSeparator(), offset);
            }
            if (this.myFormatter.requiresRowNumbers()) {
                String newRecordName = null;
                DataConsumer.Row lastRow = (DataConsumer.Row)ContainerUtil.getLastItem((List)this.rows);
                if (lastRow instanceof NamedRow) {
                    try {
                        newRecordName = String.valueOf(Long.parseLong(((NamedRow)lastRow).name) + 1L);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (newRecordName == null) {
                    newRecordName = String.valueOf(lastRow != null ? lastRow.rowNum + 1 : 1);
                }
                values = ContainerUtil.prepend(values, (Object[])new Object[]{newRecordName});
            }
            session.insert(this.myFormatter.formatRecord(values), offset);
            return true;
        }

        private void leaveColumns(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull List<DataConsumer.Column> columns, @NotNull CsvRecord record, @NotNull DataConsumer.Row row) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "leaveColumns"));
            }
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "leaveColumns"));
            }
            if (record == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "leaveColumns"));
            }
            if (row == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "leaveColumns"));
            }
            if (columns.isEmpty()) {
                session.delete(record.range);
                return;
            }
            List values = ContainerUtil.map(columns, column -> {
                if (row == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "lambda$leaveColumns$0"));
                }
                return column.getValue(row);
            });
            if (row instanceof NamedRow) {
                values = ContainerUtil.prepend((List)values, (Object[])new Object[]{((NamedRow)row).name});
            }
            String recordText = this.myFormatter.formatRecord(values);
            session.replace(record.range, recordText);
            if (record.hasRecordSeparator) {
                session.insert(this.myFormatter.recordSeparator(), record.range.getEndOffset());
            }
        }

        private void leaveColumns(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull List<DataConsumer.Column> columns, @NotNull CsvRecord headerRecord) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "leaveColumns"));
            }
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "leaveColumns"));
            }
            if (headerRecord == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerRecord", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "leaveColumns"));
            }
            List<ValueRange> values = headerRecord.values;
            int valuesStart = values.get(this.myFormatter.requiresRowNumbers() ? 1 : 0).getStartOffset();
            int valuesEnd = values.get(values.size() - 1).getEndOffset();
            StringBuilder sb = new StringBuilder();
            for (DataConsumer.Column column : columns) {
                sb.append(this.myFormatter.formatHeaderValue(column.name)).append(this.myFormatter.headerValueSeparator());
            }
            sb.setLength(sb.length() != 0 ? sb.length() - this.myFormatter.headerValueSeparator().length() : sb.length());
            session.replace(TextRange.create((int)valuesStart, (int)valuesEnd), sb.toString());
        }

        @NotNull
        private List<DataConsumer.Column> getColumnsToLeave(@NotNull List<DataConsumer.Column> orderedColumnsToDelete) {
            if (orderedColumnsToDelete == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderedColumnsToDelete", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "getColumnsToLeave"));
            }
            ArrayList columnsToLeave = ContainerUtil.newArrayListWithCapacity((int)(this.columns.size() - orderedColumnsToDelete.size()));
            Iterator<DataConsumer.Column> toDeleteIterator = orderedColumnsToDelete.iterator();
            Iterator allColumnsIterator = this.columns.iterator();
            block0: while (allColumnsIterator.hasNext()) {
                DataConsumer.Column column;
                DataConsumer.Column toDelete;
                DataConsumer.Column column2 = toDelete = toDeleteIterator.hasNext() ? toDeleteIterator.next() : null;
                while (!(column = (DataConsumer.Column)allColumnsIterator.next()).equals(toDelete)) {
                    columnsToLeave.add(column);
                    if (allColumnsIterator.hasNext()) continue;
                    continue block0;
                }
            }
            ArrayList arrayList = columnsToLeave;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "getColumnsToLeave"));
            }
            return arrayList;
        }

        @NotNull
        private static List<DataConsumer.Column> columnsFrom(@NotNull CharSequence sequence, @NotNull List<CsvRecord> records, @Nullable CsvRecord header, boolean rowNameColumn) {
            int columnCount;
            if (sequence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "columnsFrom"));
            }
            if (records == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "columnsFrom"));
            }
            int n = header != null ? header.values.size() : (columnCount = records.isEmpty() ? 0 : records.get((int)0).values.size());
            if (columnCount > 0 && rowNameColumn) {
                --columnCount;
            }
            List<String> columnNames = header != null && rowNameColumn ? CsvFormatParser.values(sequence, header.values.subList(1, header.values.size())) : (header != null ? CsvFormatParser.values(sequence, header.values) : null);
            ArrayList columns = ContainerUtil.newArrayListWithCapacity((int)columnCount);
            for (int i = 0; i < columnCount; ++i) {
                String name = columnNames == null ? "C" + (i + 1) : columnNames.get(i);
                columns.add(new DataConsumer.Column(i, name, 239, "TEXT", "java.lang.String"));
            }
            ArrayList arrayList = columns;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "columnsFrom"));
            }
            return arrayList;
        }

        @NotNull
        private static List<DataConsumer.Row> rowsFrom(@NotNull CharSequence sequence, @NotNull List<CsvRecord> records, boolean named) {
            if (sequence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "rowsFrom"));
            }
            if (records == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "rowsFrom"));
            }
            ArrayList rows = ContainerUtil.newArrayListWithCapacity((int)records.size());
            for (int i = 0; i < records.size(); ++i) {
                DataConsumer.Row row;
                List<ValueRange> valuesList = records.get((int)i).values;
                int rowNum = i + 1;
                if (named) {
                    Object[] values = CsvFormatParser.values(sequence, valuesList.subList(1, valuesList.size())).toArray();
                    String name = valuesList.get(0).value(sequence).toString();
                    row = new NamedRow(rowNum, name, values);
                } else {
                    row = new DataConsumer.Row(rowNum, CsvFormatParser.values(sequence, valuesList).toArray());
                }
                rows.add(row);
            }
            ArrayList arrayList = rows;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup", "rowsFrom"));
            }
            return arrayList;
        }
    }
}

