/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.csv.ui.CsvFormatForm;
import com.intellij.database.csv.ui.CsvFormatsSelectionUI;
import com.intellij.database.dbimport.AbstractTableFormatMapper;
import com.intellij.database.dbimport.ImportDatabaseTableEditorWrapper;
import com.intellij.database.dbimport.ImportTablePreview;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.openapi.Disposable;
import org.jetbrains.annotations.NotNull;

public class ExistingTableFormatMapper
extends AbstractTableFormatMapper {
    @NotNull
    private final DasTable myTable;

    ExistingTableFormatMapper(@NotNull ImportTablePreview preview, @NotNull ImportDatabaseTableEditorWrapper editor, @NotNull CsvFormatsSelectionUI formats, @NotNull DasTable table, @NotNull DeModel model, @NotNull Disposable parent) {
        if (preview == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preview", "com/intellij/database/dbimport/ExistingTableFormatMapper", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/dbimport/ExistingTableFormatMapper", "<init>"));
        }
        if (formats == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formats", "com/intellij/database/dbimport/ExistingTableFormatMapper", "<init>"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ExistingTableFormatMapper", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dbimport/ExistingTableFormatMapper", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/dbimport/ExistingTableFormatMapper", "<init>"));
        }
        super(preview, editor, formats, model, parent);
        this.myTable = table;
        this.init();
    }

    @Override
    @NotNull
    DeTable createInitialTable() {
        DeTable deTable = (DeTable)this.myModel.getExportHelper().export((DasObject)this.myTable, true);
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ExistingTableFormatMapper", "createInitialTable"));
        }
        return deTable;
    }

    @Override
    int getColumnNumber(@NotNull DeColumn column, int index) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/ExistingTableFormatMapper", "getColumnNumber"));
        }
        return index;
    }

    @Override
    void onFormatChanged(@NotNull CsvFormatForm source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dbimport/ExistingTableFormatMapper", "onFormatChanged"));
        }
        this.myPreview.setFormat(source.getFormat());
        this.myPreview.setColumns(this.createColumnsFromEditor(), this.getDatabaseEditor().getTable().columns);
    }
}

