/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.dbimport.ImportColumnEditorModel;
import com.intellij.database.dbimport.ImportDeTable;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.editors.DatabaseTableEditor;
import com.intellij.database.view.models.ColumnEditorModel;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.database.view.ui.TableEditorToolbarsDecorator;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ToggleActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

public class ImportDatabaseTableEditor
extends DatabaseTableEditor {
    public ImportDatabaseTableEditor(@NotNull DatabaseEditorState state, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps, @NotNull TableEditorModel tableModel) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dbimport/ImportDatabaseTableEditor", "<init>"));
        }
        if (caps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caps", "com/intellij/database/dbimport/ImportDatabaseTableEditor", "<init>"));
        }
        if (tableModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableModel", "com/intellij/database/dbimport/ImportDatabaseTableEditor", "<init>"));
        }
        super(state, caps, tableModel, new ImportToolbarDecorator());
    }

    public void setColumnsState(boolean state) {
        ImportDatabaseTableEditor.consume(this.getColumnsEditor().getSelectedRows(), (Consumer<ImportColumnEditorModel>)((Consumer)model -> {
            model.setEnabled(state);
            model.commit();
        }));
    }

    public boolean getSelectedColumnsState() {
        ArrayList values = ContainerUtil.newArrayList();
        ImportDatabaseTableEditor.consume(this.getColumnsEditor().getSelectedRows(), (Consumer<ImportColumnEditorModel>)((Consumer)model -> values.add(model.isEnabled())));
        for (Boolean value : values) {
            if (!value.booleanValue()) continue;
            return false;
        }
        return true;
    }

    private static void consume(@NotNull List<ColumnEditorModel> models, @NotNull Consumer<ImportColumnEditorModel> consumer) {
        if (models == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/intellij/database/dbimport/ImportDatabaseTableEditor", "consume"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/dbimport/ImportDatabaseTableEditor", "consume"));
        }
        models.stream().filter(model -> model instanceof ImportColumnEditorModel).forEach(model -> {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/dbimport/ImportDatabaseTableEditor", "lambda$consume$3"));
            }
            consumer.consume((Object)((ImportColumnEditorModel)model));
        });
    }

    public static class ExcludeColumnAction
    extends ToggleActionButton {
        private final DatabaseTableEditor myEditor;

        public ExcludeColumnAction(@NotNull DatabaseTableEditor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/dbimport/ImportDatabaseTableEditor$ExcludeColumnAction", "<init>"));
            }
            super("Exclude selected columns", AllIcons.Actions.GC);
            this.myEditor = editor;
            this.setShortcut(ActionManager.getInstance().getAction("$Delete").getShortcutSet());
        }

        public boolean isEnabled() {
            return this.getDatabaseTableEditor() != null;
        }

        public boolean isSelected(AnActionEvent e) {
            ImportDatabaseTableEditor tableEditor = this.getDatabaseTableEditor();
            return tableEditor != null && tableEditor.getSelectedColumnsState();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            ImportDatabaseTableEditor tableEditor = this.getDatabaseTableEditor();
            if (tableEditor != null) {
                tableEditor.setColumnsState(!state);
            }
        }

        private ImportDatabaseTableEditor getDatabaseTableEditor() {
            ImportDatabaseTableEditor editor = (ImportDatabaseTableEditor)ObjectUtils.tryCast((Object)this.myEditor, ImportDatabaseTableEditor.class);
            return editor == null || editor.getColumnsEditor().getActiveEditor() != null || !(editor.getTable() instanceof ImportDeTable) ? null : editor;
        }
    }

    private static class ImportToolbarDecorator
    extends TableEditorToolbarsDecorator.DefaultToolbarsDecorator {
        private ImportToolbarDecorator() {
        }

        @Override
        @NotNull
        public ToolbarDecorator decorateColumns(@NotNull DatabaseEditorCapabilities.TableEditorCaps caps, @NotNull DatabaseTableEditor editor, @NotNull JTable table) {
            if (caps == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caps", "com/intellij/database/dbimport/ImportDatabaseTableEditor$ImportToolbarDecorator", "decorateColumns"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/dbimport/ImportDatabaseTableEditor$ImportToolbarDecorator", "decorateColumns"));
            }
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportDatabaseTableEditor$ImportToolbarDecorator", "decorateColumns"));
            }
            ToolbarDecorator toolbarDecorator = super.decorateColumns(caps, editor, table).addExtraAction((AnActionButton)new ExcludeColumnAction(editor));
            if (toolbarDecorator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseTableEditor$ImportToolbarDecorator", "decorateColumns"));
            }
            return toolbarDecorator;
        }
    }
}

