/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.dbimport.HandleErrorTask;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImportErrorHandler {
    private static final int CAPACITY = 10000;
    @NotNull
    private final LinkedBlockingQueue<List<String>> myBlockingQueue;
    @NotNull
    private final Thread myThread;
    @Nullable
    private final HandleErrorTask myErrorTask;
    private final boolean myHasErrorPath;
    private boolean errorOccurs;

    ImportErrorHandler(@NotNull Project project, @NotNull ImportInfo info) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportErrorHandler", "<init>"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportErrorHandler", "<init>"));
        }
        this.myBlockingQueue = new LinkedBlockingQueue(10000);
        this.myHasErrorPath = info.hasErrorPath();
        this.myErrorTask = this.createErrorTask(project, info);
        this.myThread = new Thread((Runnable)this.myErrorTask, "Import error handler");
    }

    void start() {
        if (this.myHasErrorPath) {
            this.myThread.start();
        }
    }

    void stop() {
        if (this.myHasErrorPath) {
            this.onStop();
        }
    }

    void handle(@NotNull List<String> errorLine) {
        if (errorLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorLine", "com/intellij/database/dbimport/ImportErrorHandler", "handle"));
        }
        this.errorOccurs = true;
        if (!this.myHasErrorPath || ((HandleErrorTask)ObjectUtils.assertNotNull((Object)this.myErrorTask)).isStopped()) {
            return;
        }
        try {
            this.myBlockingQueue.put(errorLine);
        }
        catch (InterruptedException e) {
            this.onStop();
        }
    }

    boolean isErrorOccurs() {
        return this.errorOccurs;
    }

    private void onStop() {
        this.myBlockingQueue.clear();
        this.myBlockingQueue.offer(HandleErrorTask.POISON);
    }

    @Nullable
    private HandleErrorTask createErrorTask(@NotNull Project project, @NotNull ImportInfo info) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportErrorHandler", "createErrorTask"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportErrorHandler", "createErrorTask"));
        }
        return this.myHasErrorPath ? new HandleErrorTask(project, this.myBlockingQueue, (Writer)ObjectUtils.assertNotNull((Object)info.getErrorWriter()), info.getFormat()) : null;
    }
}

