/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.state;

import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.state.AbstractTransactionStateHolder;
import com.intellij.util.ThrowableRunnable;
import java.sql.Connection;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public class CommitOnBatchStateHolder
extends AbstractTransactionStateHolder {
    public CommitOnBatchStateHolder(@NotNull ImportManager manager, @NotNull ImportInfo info, boolean transactionsSupported) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/dbimport/state/CommitOnBatchStateHolder", "<init>"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/state/CommitOnBatchStateHolder", "<init>"));
        }
        super(info, manager, transactionsSupported, false);
    }

    @Override
    public void executed(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/CommitOnBatchStateHolder", "executed"));
        }
    }

    @Override
    public void onExecuteError(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/CommitOnBatchStateHolder", "onExecuteError"));
        }
    }

    @Override
    public void batchExecuted(final @NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/CommitOnBatchStateHolder", "batchExecuted"));
        }
        super.batchExecuted(connection);
        CommitOnBatchStateHolder.run(new ThrowableRunnable<SQLException>(){

            public void run() throws SQLException {
                connection.commit();
                CommitOnBatchStateHolder.this.lock(connection);
            }
        }, SAVE_ERROR);
    }

    @Override
    public void onExecuteBatchError(final @NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/CommitOnBatchStateHolder", "onExecuteBatchError"));
        }
        super.onExecuteBatchError(connection);
        CommitOnBatchStateHolder.run(new ThrowableRunnable<SQLException>(){

            public void run() throws SQLException {
                connection.rollback();
                CommitOnBatchStateHolder.this.lock(connection);
            }
        }, ROLLBACK_ERROR);
    }

    @Override
    public void batchStarted(final @NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/CommitOnBatchStateHolder", "batchStarted"));
        }
        super.batchStarted(connection);
        CommitOnBatchStateHolder.run(new ThrowableRunnable<SQLException>(){

            public void run() throws SQLException {
                connection.commit();
                CommitOnBatchStateHolder.this.lock(connection);
            }
        }, SAVE_ERROR);
    }

    @Override
    public void onAddBatchRecordError(final @NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/CommitOnBatchStateHolder", "onAddBatchRecordError"));
        }
        super.onAddBatchRecordError(connection);
        CommitOnBatchStateHolder.run(new ThrowableRunnable<SQLException>(){

            public void run() throws SQLException {
                connection.rollback();
                CommitOnBatchStateHolder.this.lock(connection);
            }
        }, ROLLBACK_ERROR);
    }

    @Override
    public boolean isTransactionSupported() {
        return this.mySupportTransactions;
    }
}

