/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.dialects.TypeNames;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypeHelper {
    private final TypeNames typeNames = new TypeNames();

    @Nullable
    public String getTypeName(int code, int length, int precision, int scale) {
        return this.typeNames.get(code, length, precision, scale);
    }

    protected void registerColumnType(int code, int capacity, String name) {
        this.typeNames.put(code, capacity, name);
    }

    protected void registerColumnType(int code, String name) {
        this.typeNames.put(code, name);
    }

    @NotNull
    public String getTypeWithSubstitution(@NotNull String name, int length, int precision, int scale) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dialects/TypeHelper", "getTypeWithSubstitution"));
        }
        String string = this.typeNames.getType(name, length, precision, scale);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/TypeHelper", "getTypeWithSubstitution"));
        }
        return string;
    }

    public int findJdbcType(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dialects/TypeHelper", "findJdbcType"));
        }
        return this.typeNames.findTypeCode(name);
    }

    public static class SQLiteTypeHelper
    extends TypeHelper {
        public SQLiteTypeHelper() {
            this.registerColumnType(4, "INTEGER");
            this.registerColumnType(-6, "INTEGER");
            this.registerColumnType(5, "INTEGER");
            this.registerColumnType(-5, "INTEGER");
            this.registerColumnType(1, "TEXT");
            this.registerColumnType(12, "TEXT");
            this.registerColumnType(-15, "TEXT");
            this.registerColumnType(-9, "TEXT");
            this.registerColumnType(2005, "TEXT");
            this.registerColumnType(2004, "BLOB");
            this.registerColumnType(7, "REAL");
            this.registerColumnType(8, "REAL");
            this.registerColumnType(6, "REAL");
            this.registerColumnType(2, "NUMERIC");
            this.registerColumnType(3, "NUMERIC");
            this.registerColumnType(16, "NUMERIC");
            this.registerColumnType(91, "NUMERIC");
        }
    }

    static class SybaseTypeHelper
    extends TypeHelper {
        public SybaseTypeHelper() {
            this.registerColumnType(-7, "tinyint");
            this.registerColumnType(-5, "numeric(19,0)");
            this.registerColumnType(5, "smallint");
            this.registerColumnType(-6, "tinyint");
            this.registerColumnType(4, "int");
            this.registerColumnType(1, "char(1)");
            this.registerColumnType(12, "varchar($l)");
            this.registerColumnType(6, "float");
            this.registerColumnType(8, "double precision");
            this.registerColumnType(91, "datetime");
            this.registerColumnType(92, "datetime");
            this.registerColumnType(93, "datetime");
            this.registerColumnType(-3, "varbinary($l)");
            this.registerColumnType(2, "numeric($p,$s)");
            this.registerColumnType(2004, "image");
            this.registerColumnType(2005, "text");
            this.registerColumnType(-5, "numeric($p)");
            this.registerColumnType(-2, "image");
            this.registerColumnType(-7, "tinyint");
            this.registerColumnType(2004, "image");
            this.registerColumnType(16, "tinyint");
            this.registerColumnType(1, 255, "char($l)");
            this.registerColumnType(1, "text");
            this.registerColumnType(2005, "text");
            this.registerColumnType(91, "date");
            this.registerColumnType(3, "decimal($p[,$s])");
            this.registerColumnType(8, "float($p)");
            this.registerColumnType(6, "float($p)");
            this.registerColumnType(4, "int");
            this.registerColumnType(-4, "image");
            this.registerColumnType(-1, "text");
            this.registerColumnType(2, "numeric($p,$s)");
            this.registerColumnType(7, "real");
            this.registerColumnType(5, "smallint");
            this.registerColumnType(92, "time");
            this.registerColumnType(93, "datetime");
            this.registerColumnType(-6, "tinyint");
            this.registerColumnType(-3, "image");
            this.registerColumnType(12, 255, "varchar($l)");
            this.registerColumnType(12, "text");
        }
    }

    static class MssqlTypeHelper
    extends TypeHelper {
        public MssqlTypeHelper() {
            this.registerColumnType(-7, "bit");
            this.registerColumnType(-5, "numeric(19,0)");
            this.registerColumnType(5, "smallint");
            this.registerColumnType(-6, "tinyint");
            this.registerColumnType(4, "int");
            this.registerColumnType(1, "char(1)");
            this.registerColumnType(12, "varchar($l)");
            this.registerColumnType(6, "float");
            this.registerColumnType(8, "double precision");
            this.registerColumnType(91, "datetime");
            this.registerColumnType(91, "datetime2");
            this.registerColumnType(91, "date");
            this.registerColumnType(91, "smalldatetime");
            this.registerColumnType(92, "datetime");
            this.registerColumnType(93, "datetime");
            this.registerColumnType(-3, "varbinary($l)");
            this.registerColumnType(2, "numeric($p[,$s])");
            this.registerColumnType(2004, "image");
            this.registerColumnType(2005, "text");
            this.registerColumnType(-5, "bigint");
            this.registerColumnType(-2, "image");
            this.registerColumnType(2004, "image");
            this.registerColumnType(16, "tinyint");
            this.registerColumnType(1, 8000, "char($l)");
            this.registerColumnType(1, "text");
            this.registerColumnType(2005, "text");
            this.registerColumnType(91, "datetime");
            this.registerColumnType(3, "decimal($p[,$s])");
            this.registerColumnType(8, "float($p)");
            this.registerColumnType(6, "float($p)");
            this.registerColumnType(4, "int");
            this.registerColumnType(-4, "image");
            this.registerColumnType(-1, "text");
            this.registerColumnType(-15, "nchar($l)");
            this.registerColumnType(-9, "nvarchar($l)");
            this.registerColumnType(7, "real");
            this.registerColumnType(5, "smallint");
            this.registerColumnType(92, "datetime");
            this.registerColumnType(93, "datetime");
            this.registerColumnType(-6, "tinyint");
            this.registerColumnType(-3, 8000, "varbinary($l)");
            this.registerColumnType(-3, Integer.MAX_VALUE, "varbinary(max)");
            this.registerColumnType(-4, "image");
            this.registerColumnType(12, 8000, "varchar($l)");
            this.registerColumnType(12, "text");
        }
    }

    static class OracleTypeHelper
    extends TypeHelper {
        public OracleTypeHelper() {
            this.registerColumnType(-7, "number(1,0)");
            this.registerColumnType(-5, "number(19,0)");
            this.registerColumnType(5, "number(5,0)");
            this.registerColumnType(-6, "number(3,0)");
            this.registerColumnType(4, "number(10,0)");
            this.registerColumnType(1, "char(1 char)");
            this.registerColumnType(12, 4000, "varchar2($l char)");
            this.registerColumnType(12, "long");
            this.registerColumnType(6, "float");
            this.registerColumnType(8, "double precision");
            this.registerColumnType(91, "date");
            this.registerColumnType(92, "date");
            this.registerColumnType(93, "timestamp");
            this.registerColumnType(-3, 2000, "raw($l)");
            this.registerColumnType(-3, "long raw");
            this.registerColumnType(2, "number($p[,$s])");
            this.registerColumnType(3, "number($p[,$s])");
            this.registerColumnType(2004, "blob");
            this.registerColumnType(2005, "clob");
            this.registerColumnType(-5, "number($p)");
            this.registerColumnType(-2, 2000, "raw($l)");
            this.registerColumnType(-2, "blob");
            this.registerColumnType(-7, "number(1)");
            this.registerColumnType(2004, "blob");
            this.registerColumnType(16, "smallint");
            this.registerColumnType(1, 2000, "char($l)");
            this.registerColumnType(1, 4000, "varchar2($l)");
            this.registerColumnType(1, "clob");
            this.registerColumnType(2005, "clob");
            this.registerColumnType(2011, "nclob");
            this.registerColumnType(91, "date");
            this.registerColumnType(8, "float($p)");
            this.registerColumnType(6, "float($p)");
            this.registerColumnType(4, "number(10)");
            this.registerColumnType(-16, 2000, "nvarchar2($l)");
            this.registerColumnType(-16, "nclob");
            this.registerColumnType(-4, "long raw");
            this.registerColumnType(-1, 4000, "varchar2($l)");
            this.registerColumnType(-1, "clob");
            this.registerColumnType(-15, 2000, "nchar($l)");
            this.registerColumnType(-9, 2000, "nvarchar2($l)");
            this.registerColumnType(-9, "nclob");
            this.registerColumnType(7, "real");
            this.registerColumnType(5, "number(5)");
            this.registerColumnType(92, "date");
            this.registerColumnType(93, "timestamp");
            this.registerColumnType(-6, "number(3)");
            this.registerColumnType(-3, "blob");
            this.registerColumnType(12, 4000, "varchar2($l)");
            this.registerColumnType(12, "clob");
        }
    }

    static class MySQLTypeHelper
    extends TypeHelper {
        public MySQLTypeHelper() {
            this.registerColumnType(-7, "bit");
            this.registerColumnType(-5, "bigint");
            this.registerColumnType(5, "smallint");
            this.registerColumnType(-6, "tinyint");
            this.registerColumnType(4, "integer");
            this.registerColumnType(1, "char(1)");
            this.registerColumnType(6, "float");
            this.registerColumnType(8, "double precision");
            this.registerColumnType(91, "date");
            this.registerColumnType(92, "time");
            this.registerColumnType(93, "datetime");
            this.registerColumnType(-3, "longblob");
            this.registerColumnType(-3, 0xFFFFFF, "mediumblob");
            this.registerColumnType(-3, 65535, "blob");
            this.registerColumnType(-3, 255, "tinyblob");
            this.registerColumnType(2, "numeric($p[,$s])");
            this.registerColumnType(2004, "longblob");
            this.registerColumnType(2004, 0xFFFFFF, "mediumblob");
            this.registerColumnType(2004, 65535, "blob");
            this.registerColumnType(2005, "longtext");
            this.registerColumnType(2005, 0xFFFFFF, "mediumtext");
            this.registerColumnType(2005, 65535, "text");
            this.registerColumnType(12, "longtext");
            this.registerColumnType(12, 0xFFFFFF, "mediumtext");
            this.registerColumnType(12, 65535, "varchar($l)");
            this.registerColumnType(-5, "bigint");
            this.registerColumnType(-2, 255, "binary($l)");
            this.registerColumnType(-2, 65532, "blob");
            this.registerColumnType(-2, "longblob");
            this.registerColumnType(-7, "bit");
            this.registerColumnType(2004, 65532, "blob");
            this.registerColumnType(2004, "longblob");
            this.registerColumnType(16, "bool");
            this.registerColumnType(1, 255, "char($l)");
            this.registerColumnType(1, 65532, "text");
            this.registerColumnType(1, "longtext");
            this.registerColumnType(2005, "longtext");
            this.registerColumnType(91, "date");
            this.registerColumnType(3, "decimal($p[,$s])");
            this.registerColumnType(8, "double");
            this.registerColumnType(8, "double($p,$s)");
            this.registerColumnType(6, "float($p)");
            this.registerColumnType(4, "int");
            this.registerColumnType(-4, "longblob");
            this.registerColumnType(-1, "longtext");
            this.registerColumnType(7, "real");
            this.registerColumnType(5, "smallint");
            this.registerColumnType(92, "time");
            this.registerColumnType(93, "timestamp");
            this.registerColumnType(-6, "tinyint");
            this.registerColumnType(-3, 255, "varbinary($l)");
            this.registerColumnType(-3, "blob");
            this.registerColumnType(12, "text");
        }
    }

    static class HSQLTypeHelper
    extends TypeHelper {
        public HSQLTypeHelper() {
            this.registerColumnType(-5, "bigint");
            this.registerColumnType(-2, "binary");
            this.registerColumnType(-7, "bit");
            this.registerColumnType(2004, "longvarbinary");
            this.registerColumnType(16, "boolean");
            this.registerColumnType(1, "char($l)");
            this.registerColumnType(2005, "longvarchar");
            this.registerColumnType(91, "date");
            this.registerColumnType(3, "decimal");
            this.registerColumnType(8, "double");
            this.registerColumnType(6, "float");
            this.registerColumnType(4, "integer");
            this.registerColumnType(-4, "longvarbinary");
            this.registerColumnType(-1, "longvarchar");
            this.registerColumnType(2, "numeric");
            this.registerColumnType(7, "real");
            this.registerColumnType(5, "smallint");
            this.registerColumnType(92, "time");
            this.registerColumnType(93, "timestamp");
            this.registerColumnType(-6, "tinyint");
            this.registerColumnType(-3, "varbinary");
            this.registerColumnType(12, "varchar($l)");
        }
    }

    static class H2TypeHelper
    extends TypeHelper {
        public H2TypeHelper() {
            this.registerColumnType(2003, "array");
            this.registerColumnType(-5, "bigint");
            this.registerColumnType(-2, "binary");
            this.registerColumnType(-7, "boolean");
            this.registerColumnType(16, "boolean");
            this.registerColumnType(2004, "blob");
            this.registerColumnType(1, "varchar($l)");
            this.registerColumnType(2005, "clob");
            this.registerColumnType(91, "date");
            this.registerColumnType(3, "decimal($p[,$s])");
            this.registerColumnType(8, "double");
            this.registerColumnType(6, "float");
            this.registerColumnType(4, "integer");
            this.registerColumnType(-4, "longvarbinary");
            this.registerColumnType(-1, "longvarchar");
            this.registerColumnType(2, "numeric");
            this.registerColumnType(7, "real");
            this.registerColumnType(5, "smallint");
            this.registerColumnType(92, "time");
            this.registerColumnType(93, "timestamp");
            this.registerColumnType(-6, "tinyint");
            this.registerColumnType(-3, "binary($l)");
            this.registerColumnType(12, "varchar($l)");
        }
    }

    static class DB2TypeHelper
    extends TypeHelper {
        public DB2TypeHelper() {
            this.registerColumnType(-7, "smallint");
            this.registerColumnType(-5, "bigint");
            this.registerColumnType(5, "smallint");
            this.registerColumnType(-6, "smallint");
            this.registerColumnType(4, "integer");
            this.registerColumnType(1, "char(1)");
            this.registerColumnType(12, "varchar($l)");
            this.registerColumnType(6, "float");
            this.registerColumnType(8, "double");
            this.registerColumnType(91, "date");
            this.registerColumnType(92, "time");
            this.registerColumnType(93, "timestamp");
            this.registerColumnType(-3, "varchar($l) for bit data");
            this.registerColumnType(2, "numeric($p[,$s])");
            this.registerColumnType(2004, "blob($l)");
            this.registerColumnType(2005, "clob($l)");
            this.registerColumnType(-5, "bigint");
            this.registerColumnType(-2, 254, "char($l) for bit data");
            this.registerColumnType(-2, "blob");
            this.registerColumnType(-7, "smallint");
            this.registerColumnType(2004, 0x3FFFFFFF, "blob($l)");
            this.registerColumnType(2004, "blob(1073741823)");
            this.registerColumnType(16, "smallint");
            this.registerColumnType(1, 254, "char($l)");
            this.registerColumnType(1, 4000, "varchar($l)");
            this.registerColumnType(1, 32700, "long varchar");
            this.registerColumnType(1, 0x3FFFFFFF, "clob($l)");
            this.registerColumnType(1, "clob(1073741823)");
            this.registerColumnType(2005, 0x3FFFFFFF, "clob($l)");
            this.registerColumnType(2005, "clob(1073741823)");
            this.registerColumnType(91, "date");
            this.registerColumnType(3, "decimal($p[,$s])");
            this.registerColumnType(8, "float($p)");
            this.registerColumnType(6, "float($p)");
            this.registerColumnType(4, "int");
            this.registerColumnType(-4, 32700, "long varchar for bit data");
            this.registerColumnType(-4, 0x3FFFFFFF, "blob($l)");
            this.registerColumnType(-4, "blob(1073741823)");
            this.registerColumnType(-1, 32700, "long varchar");
            this.registerColumnType(-1, 0x3FFFFFFF, "clob($l)");
            this.registerColumnType(-1, "clob(1073741823)");
            this.registerColumnType(2, "bigint");
            this.registerColumnType(7, "real");
            this.registerColumnType(5, "smallint");
            this.registerColumnType(92, "time");
            this.registerColumnType(93, "timestamp");
            this.registerColumnType(-6, "smallint");
            this.registerColumnType(-3, 254, "varchar($l) for bit data");
            this.registerColumnType(-3, "blob");
            this.registerColumnType(12, 3924, "varchar($l)");
            this.registerColumnType(12, 32700, "long varchar");
            this.registerColumnType(12, 0x3FFFFFFF, "clob($l)");
            this.registerColumnType(12, "clob(1073741823)");
            this.registerColumnType(-8, "int");
            this.registerColumnType(-9, 0x3FFFFFFF, "clob($l)");
            this.registerColumnType(-9, "clob(1073741823)");
            this.registerColumnType(-15, "char($l)");
            this.registerColumnType(-16, "longvarchar");
            this.registerColumnType(2009, "clob");
            this.registerColumnType(2011, "clob");
        }
    }

    public static class DerbyTypeHelper
    extends TypeHelper {
        public DerbyTypeHelper() {
            this.registerColumnType(-7, "smallint");
            this.registerColumnType(-5, "bigint");
            this.registerColumnType(5, "smallint");
            this.registerColumnType(-6, "smallint");
            this.registerColumnType(4, "integer");
            this.registerColumnType(1, "char(1)");
            this.registerColumnType(12, "varchar($l)");
            this.registerColumnType(6, "float");
            this.registerColumnType(8, "double");
            this.registerColumnType(91, "date");
            this.registerColumnType(92, "time");
            this.registerColumnType(93, "timestamp");
            this.registerColumnType(-3, "varchar($l) for bit data");
            this.registerColumnType(2, "numeric($p[,$s])");
            this.registerColumnType(2004, "blob($l)");
            this.registerColumnType(2005, "clob($l)");
            this.registerColumnType(-5, "bigint");
            this.registerColumnType(-2, 254, "char($l) for bit data");
            this.registerColumnType(-2, "blob");
            this.registerColumnType(-7, "smallint");
            this.registerColumnType(2004, 0x3FFFFFFF, "blob($l)");
            this.registerColumnType(2004, "blob(1073741823)");
            this.registerColumnType(16, "smallint");
            this.registerColumnType(1, 254, "char($l)");
            this.registerColumnType(1, 4000, "varchar($l)");
            this.registerColumnType(1, 32700, "long varchar");
            this.registerColumnType(1, 0x3FFFFFFF, "clob($l)");
            this.registerColumnType(1, "clob(1073741823)");
            this.registerColumnType(2005, 0x3FFFFFFF, "clob($l)");
            this.registerColumnType(2005, "clob(1073741823)");
            this.registerColumnType(91, "date");
            this.registerColumnType(3, "decimal($p)");
            this.registerColumnType(8, "float($p)");
            this.registerColumnType(6, "float($p)");
            this.registerColumnType(4, "int");
            this.registerColumnType(-4, 32700, "long varchar for bit data");
            this.registerColumnType(-4, 0x3FFFFFFF, "blob($l)");
            this.registerColumnType(-4, "blob(1073741823)");
            this.registerColumnType(-1, 32700, "long varchar");
            this.registerColumnType(-1, 0x3FFFFFFF, "clob($l)");
            this.registerColumnType(-1, "clob(1073741823)");
            this.registerColumnType(2, "bigint");
            this.registerColumnType(-9, 4000, "varchar($l)");
            this.registerColumnType(-9, 32700, "long varchar");
            this.registerColumnType(-9, 0x3FFFFFFF, "clob($l)");
            this.registerColumnType(-9, "clob(1073741823)");
            this.registerColumnType(7, "real");
            this.registerColumnType(5, "smallint");
            this.registerColumnType(92, "time");
            this.registerColumnType(93, "timestamp");
            this.registerColumnType(-6, "smallint");
            this.registerColumnType(-3, 254, "long varchar for bit data");
            this.registerColumnType(-3, "blob");
            this.registerColumnType(12, 4000, "varchar($l)");
            this.registerColumnType(12, 32700, "long varchar");
            this.registerColumnType(12, 0x3FFFFFFF, "clob($l)");
            this.registerColumnType(12, "clob(1073741823)");
        }
    }

    public static class PostgresTypeHelper
    extends TypeHelper {
        public PostgresTypeHelper() {
            this.registerColumnType(-7, "bool");
            this.registerColumnType(-5, "int8");
            this.registerColumnType(5, "int2");
            this.registerColumnType(-6, "int2");
            this.registerColumnType(4, "int4");
            this.registerColumnType(4, "integer");
            this.registerColumnType(4, "serial");
            this.registerColumnType(1, "char(1)");
            this.registerColumnType(12, "varchar($l)");
            this.registerColumnType(6, "float4");
            this.registerColumnType(8, "float8");
            this.registerColumnType(91, "date");
            this.registerColumnType(92, "time");
            this.registerColumnType(93, "timestamp");
            this.registerColumnType(-3, "bytea");
            this.registerColumnType(2005, "text");
            this.registerColumnType(2004, "oid");
            this.registerColumnType(2, "numeric($p[, $s])");
            this.registerColumnType(-5, "bigint");
            this.registerColumnType(-2, "bytea");
            this.registerColumnType(-7, 1, "bit");
            this.registerColumnType(-7, 8000, "bit($l)");
            this.registerColumnType(2004, "bytea");
            this.registerColumnType(16, "bool");
            this.registerColumnType(16, "boolean");
            this.registerColumnType(1, 8000, "char($l)");
            this.registerColumnType(1, "text");
            this.registerColumnType(2005, "text");
            this.registerColumnType(91, "date");
            this.registerColumnType(3, "decimal($p,2)");
            this.registerColumnType(8, "double precision");
            this.registerColumnType(6, "float($p)");
            this.registerColumnType(4, "int");
            this.registerColumnType(-4, "bytea");
            this.registerColumnType(-1, "text");
            this.registerColumnType(7, "real");
            this.registerColumnType(5, "smallint");
            this.registerColumnType(92, "time");
            this.registerColumnType(93, "timestamp");
            this.registerColumnType(-6, "int");
            this.registerColumnType(-3, "bytea");
            this.registerColumnType(12, 8000, "varchar($l)");
            this.registerColumnType(12, "varchar");
        }
    }
}

