/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.fragments.DiffFragmentImpl;
import com.intellij.diff.util.Range;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DiffAlgo {
    private static final int BT_HOR = 1;
    private static final int BT_VER = 2;
    private static final int BT_DIA = 3;

    @NotNull
    public static <E> DiffIterable diff(@NotNull List<E> a, @NotNull List<E> b, @NotNull Comparator<E> comparator) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/intellij/database/diff/DiffAlgo", "diff"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/database/diff/DiffAlgo", "diff"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/database/diff/DiffAlgo", "diff"));
        }
        if (a.isEmpty() || b.isEmpty()) {
            DiffIterable diffIterable = DiffIterableUtil.create(Collections.singletonList(new Range(0, a.size(), 0, b.size())), (int)a.size(), (int)b.size());
            if (diffIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/DiffAlgo", "diff"));
            }
            return diffIterable;
        }
        TwoDimensionalIntArray lengths = new TwoDimensionalIntArray(a.size(), b.size());
        TwoDimensionalIntArray backtrack = new TwoDimensionalIntArray(a.size(), b.size());
        for (int i = 0; i < a.size(); ++i) {
            for (int j = 0; j < b.size(); ++j) {
                int vLength;
                E y;
                E x = a.get(i);
                if (comparator.compare(x, y = b.get(j)) == 0) {
                    lengths.set(i, j, DiffAlgo.getLCSLengths(i - 1, j - 1, lengths) + 1);
                    backtrack.set(i, j, 3);
                    continue;
                }
                int hLength = DiffAlgo.getLCSLengths(i, j - 1, lengths);
                if (hLength < (vLength = DiffAlgo.getLCSLengths(i - 1, j, lengths))) {
                    lengths.set(i, j, vLength);
                    backtrack.set(i, j, 2);
                    continue;
                }
                lengths.set(i, j, hLength);
                backtrack.set(i, j, 1);
            }
        }
        ArrayList fragments = ContainerUtil.newArrayList();
        int i = a.size() - 1;
        int j = b.size() - 1;
        while (i >= 0 || j >= 0) {
            while ((i >= 0 || j >= 0) && DiffAlgo.getLCSBacktrack(i, j, backtrack) == 3) {
                --i;
                --j;
            }
            int pi = i;
            int pj = j;
            while ((i >= 0 || j >= 0) && DiffAlgo.getLCSBacktrack(i, j, backtrack) != 3) {
                if (DiffAlgo.getLCSBacktrack(i, j, backtrack) == 1) {
                    --j;
                    continue;
                }
                --i;
            }
            if (pi == i && pj == j) continue;
            fragments.add(new DiffFragmentImpl(i + 1, pi + 1, j + 1, pj + 1));
        }
        Collections.reverse(fragments);
        DiffIterable diffIterable = DiffIterableUtil.createFragments((List)fragments, (int)a.size(), (int)b.size());
        if (diffIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/DiffAlgo", "diff"));
        }
        return diffIterable;
    }

    private static int getLCSLengths(int i, int j, @NotNull TwoDimensionalIntArray lengths) {
        if (lengths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lengths", "com/intellij/database/diff/DiffAlgo", "getLCSLengths"));
        }
        return i < 0 || j < 0 ? 0 : lengths.get(i, j);
    }

    private static int getLCSBacktrack(int i, int j, @NotNull TwoDimensionalIntArray backtracks) {
        if (backtracks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backtracks", "com/intellij/database/diff/DiffAlgo", "getLCSBacktrack"));
        }
        if (i < 0 && j < 0) {
            return 3;
        }
        if (i < 0) {
            return 1;
        }
        if (j < 0) {
            return 2;
        }
        return backtracks.get(i, j);
    }

    private static class TwoDimensionalIntArray {
        private final int[] myData;
        private final int myColumns;

        public TwoDimensionalIntArray(int n, int m) {
            this.myData = new int[n * m];
            this.myColumns = m;
        }

        public void set(int i, int j, int item) {
            this.myData[i * this.myColumns + j] = item;
        }

        public int get(int i, int j) {
            return this.myData[i * this.myColumns + j];
        }

        public int getColumns() {
            return this.myColumns;
        }

        public int getRows() {
            return this.myData.length / this.myColumns;
        }
    }
}

