/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.CharOut;
import gnu.trove.TIntObjectHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DefaultValuesExtractor<T extends DatabaseSettings.BaseState>
implements DataExtractor {
    private final ObjectFormatter myConverter;
    protected final T myState;

    public DefaultValuesExtractor(@NotNull T state, @NotNull ObjectFormatter converter) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/extractors/DefaultValuesExtractor", "<init>"));
        }
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "com/intellij/database/extractors/DefaultValuesExtractor", "<init>"));
        }
        this.myConverter = converter;
        this.myState = state;
    }

    @NotNull
    protected ObjectFormatter getFormatter() {
        ObjectFormatter objectFormatter = this.myConverter;
        if (objectFormatter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DefaultValuesExtractor", "getFormatter"));
        }
        return objectFormatter;
    }

    public T getState() {
        return this.myState;
    }

    public boolean isIncludeColumnNames() {
        T state = this.getState();
        return state instanceof DatabaseSettings.StdState && ((DatabaseSettings.StdState)state).columnNames;
    }

    public void setIncludeColumnNames(boolean columnNames) {
        T state = this.getState();
        if (state instanceof DatabaseSettings.StdState) {
            ((DatabaseSettings.StdState)state).columnNames = columnNames;
        }
    }

    public void setIncludeRowNumbers(boolean rowNumbers) {
        T state = this.getState();
        if (state instanceof DatabaseSettings.StdState) {
            ((DatabaseSettings.StdState)state).rowNumber = rowNumbers;
        }
    }

    public boolean isIncludeRowNumbers() {
        T state = this.getState();
        return state instanceof DatabaseSettings.StdState && ((DatabaseSettings.StdState)state).rowNumber;
    }

    public String getValueSeparator() {
        return " ";
    }

    public String getLineSeparator() {
        return "\n";
    }

    @NotNull
    public String getLinePrefix() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DefaultValuesExtractor", "getLinePrefix"));
        }
        return "";
    }

    @NotNull
    public String getLineSuffix() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DefaultValuesExtractor", "getLineSuffix"));
        }
        return "";
    }

    @NotNull
    public String getValuePrefix() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DefaultValuesExtractor", "getValuePrefix"));
        }
        return "";
    }

    @NotNull
    public String getValueSuffix() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DefaultValuesExtractor", "getValueSuffix"));
        }
        return "";
    }

    @NotNull
    public String getValueLiteral(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column, @NotNull DatabaseDialect dialect) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/extractors/DefaultValuesExtractor", "getValueLiteral"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/extractors/DefaultValuesExtractor", "getValueLiteral"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/extractors/DefaultValuesExtractor", "getValueLiteral"));
        }
        String value = this.getValueAsString(row, column, dialect, false);
        if (value == null) {
            String string = this.getNullLiteral(row, column);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DefaultValuesExtractor", "getValueLiteral"));
            }
            return string;
        }
        String string = this.getValueLiteral(dialect, value, row, column);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DefaultValuesExtractor", "getValueLiteral"));
        }
        return string;
    }

    @Nullable
    protected String getValueAsString(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column, @NotNull DatabaseDialect dialect, boolean forDisplay) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/extractors/DefaultValuesExtractor", "getValueAsString"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/extractors/DefaultValuesExtractor", "getValueAsString"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/extractors/DefaultValuesExtractor", "getValueAsString"));
        }
        return this.myConverter.getValueLiteral(row, column, dialect, forDisplay);
    }

    public String getValueLiteral(@NotNull DatabaseDialect dialect, @NotNull String value, @Nullable DataConsumer.Row row, @Nullable DataConsumer.Column column) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/extractors/DefaultValuesExtractor", "getValueLiteral"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/extractors/DefaultValuesExtractor", "getValueLiteral"));
        }
        return this.isStringLiteral(dialect, value, row, column) ? this.getStringValue(dialect, value) : value;
    }

    protected boolean isStringLiteral(@NotNull DatabaseDialect dialect, @NotNull String value, @Nullable DataConsumer.Row row, @Nullable DataConsumer.Column column) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/extractors/DefaultValuesExtractor", "isStringLiteral"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/extractors/DefaultValuesExtractor", "isStringLiteral"));
        }
        if (column == null) {
            return false;
        }
        int jdbcType = ExtractorsUtil.guessJdbcType(column);
        if (jdbcType == 1 || jdbcType == 12 || jdbcType == -1 || jdbcType == -15 || jdbcType == -9 || jdbcType == -16 || jdbcType == 92 || jdbcType == 93 || jdbcType == 91 || jdbcType == 2005 || jdbcType == -8 || jdbcType == 239) {
            return true;
        }
        DatabaseFamilyId id = dialect.getFamilyId();
        if (ObjectFormatter.isJson(column, id)) {
            return true;
        }
        return id.isPostgres() && (ObjectFormatter.isHstore(column) || ObjectFormatter.isPostgresRangeType(column) || ObjectFormatter.isPostgresArray(column));
    }

    @Override
    public DataExtractor.Extraction startExtraction(CharOut out, DatabaseDialectEx dialect, boolean forceSkipHeader, List<DataConsumer.Column> allColumns, int ... selectedColumns) {
        return new DefaultExtraction(out, dialect, forceSkipHeader, allColumns, selectedColumns);
    }

    public String getColumnName(DataConsumer.Column column) {
        return column.name;
    }

    @Override
    @NotNull
    public String getFileExtension() {
        if ("txt" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DefaultValuesExtractor", "getFileExtension"));
        }
        return "txt";
    }

    @NotNull
    public String getNullLiteral(DataConsumer.Row row, DataConsumer.Column column) {
        if ("NULL" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DefaultValuesExtractor", "getNullLiteral"));
        }
        return "NULL";
    }

    @NotNull
    public String getStringValue(@NotNull DatabaseDialect dialect, @NotNull String value) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/extractors/DefaultValuesExtractor", "getStringValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/extractors/DefaultValuesExtractor", "getStringValue"));
        }
        String string = value;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DefaultValuesExtractor", "getStringValue"));
        }
        return string;
    }

    protected class DefaultExtraction
    implements DataExtractor.Extraction {
        protected final CharOut myOutput;
        protected final List<DataConsumer.Column> myAllColumns;
        protected final int[] mySelectedColumnIndices;
        protected final DatabaseDialectEx myDialect;
        protected final boolean myForceSkipHeader;
        protected boolean myHeaderAppended;
        protected boolean myFooterAppended;

        public DefaultExtraction(CharOut output, DatabaseDialectEx dialect, boolean forceSkipHeader, List<DataConsumer.Column> allColumns, int[] selectedColumnIndices) {
            this.myOutput = output;
            this.myDialect = dialect;
            this.myForceSkipHeader = forceSkipHeader;
            this.myAllColumns = allColumns;
            this.mySelectedColumnIndices = selectedColumnIndices;
        }

        @Override
        public void addData(List<DataConsumer.Row> rows) {
            if (!this.myHeaderAppended && !this.myForceSkipHeader) {
                this.appendHeader(!rows.isEmpty());
                this.myHeaderAppended = true;
            }
            this.appendData(rows);
        }

        @Override
        public void complete() {
            if (!this.myHeaderAppended && !this.myForceSkipHeader) {
                this.appendHeader(false);
                this.myHeaderAppended = true;
            }
            if (!this.myFooterAppended) {
                this.appendFooter();
                this.myFooterAppended = true;
            }
        }

        protected void appendHeader(boolean appendNewLine) {
            if (DefaultValuesExtractor.this.isIncludeColumnNames() && !this.myForceSkipHeader) {
                String number = DefaultValuesExtractor.this.isIncludeRowNumbers() ? DefaultValuesExtractor.this.getColumnName(this.getRowNumbersColumn()) + DefaultValuesExtractor.this.getValueSeparator() : "";
                this.myOutput.append(DefaultValuesExtractor.this.getLinePrefix()).append(number);
                TIntObjectHashMap<DataConsumer.Column> columnsMap = ExtractorsUtil.getColumnNumsToColumnsMapping(this.myAllColumns);
                boolean first = true;
                for (int selectedColumn : ExtractorsUtil.getNonEmptySelection(this.myAllColumns, this.mySelectedColumnIndices)) {
                    DataConsumer.Column column = (DataConsumer.Column)columnsMap.get(selectedColumn);
                    if (column == null) continue;
                    if (!first) {
                        this.myOutput.append(DefaultValuesExtractor.this.getValueSeparator());
                    } else {
                        first = false;
                    }
                    this.myOutput.append(DefaultValuesExtractor.this.getColumnName(column));
                }
                this.myOutput.append(DefaultValuesExtractor.this.getLineSuffix());
                if (appendNewLine) {
                    this.myOutput.append(DefaultValuesExtractor.this.getLineSeparator());
                }
            }
        }

        protected void appendData(List<DataConsumer.Row> rows) {
            TIntObjectHashMap<DataConsumer.Column> columnsMap = ExtractorsUtil.getColumnNumsToColumnsMapping(this.myAllColumns);
            boolean first = true;
            for (DataConsumer.Row row : rows) {
                if (!first) {
                    this.myOutput.append(DefaultValuesExtractor.this.getLineSeparator());
                } else {
                    first = false;
                }
                this.myOutput.append(DefaultValuesExtractor.this.getLinePrefix());
                if (DefaultValuesExtractor.this.isIncludeRowNumbers()) {
                    this.myOutput.append(DefaultValuesExtractor.this.getValuePrefix()).append(DefaultValuesExtractor.this.getValueLiteral(this.myDialect, this.getRowNumber(row), null, null)).append(DefaultValuesExtractor.this.getValueSuffix()).append(DefaultValuesExtractor.this.getValueSeparator());
                }
                boolean innerFirst = true;
                for (int selectedColumn : ExtractorsUtil.getNonEmptySelection(this.myAllColumns, this.mySelectedColumnIndices)) {
                    DataConsumer.Column column = (DataConsumer.Column)columnsMap.get(selectedColumn);
                    if (column == null) continue;
                    if (!innerFirst) {
                        this.myOutput.append(DefaultValuesExtractor.this.getValueSeparator());
                    } else {
                        innerFirst = false;
                    }
                    String value = DefaultValuesExtractor.this.getValueLiteral(row, column, this.myDialect);
                    this.myOutput.append(DefaultValuesExtractor.this.getValuePrefix()).append(value).append(DefaultValuesExtractor.this.getValueSuffix());
                }
                this.myOutput.append(DefaultValuesExtractor.this.getLineSuffix());
            }
        }

        protected void appendFooter() {
        }

        @NotNull
        protected String getRowNumber(DataConsumer.Row row) {
            String string = String.valueOf(row.rowNum);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DefaultValuesExtractor$DefaultExtraction", "getRowNumber"));
            }
            return string;
        }

        @NotNull
        protected DataConsumer.Column getRowNumbersColumn() {
            DataConsumer.Column column = new DataConsumer.Column(0, "#", 12, "", "");
            if (column == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DefaultValuesExtractor$DefaultExtraction", "getRowNumbersColumn"));
            }
            return column;
        }
    }
}

