/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan.oracle;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.plan.ExplainPlanProvider;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.oracle.OracleExplainPlanComponent;
import com.intellij.database.plan.oracle.OraclePlanModelBuilder;
import com.intellij.database.script.ScriptModel;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.psi.SqlParameter;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OracleExplainPlanProvider
extends ExplainPlanProvider {
    private static final String PLAN_TABLE_KEY = "PLAN_TABLE_KEY";
    private static final String DEFAULT_PLAN_TABLE = "PLAN_TABLE";

    @Override
    @NotNull
    public String getName() {
        if ("Oracle" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/oracle/OracleExplainPlanProvider", "getName"));
        }
        return "Oracle";
    }

    @Override
    @Nullable
    public ConfigurableUi<LocalDataSource> createOptionsComponent() {
        return new OracleExplainPlanComponent();
    }

    @Override
    public boolean isAvailableFor(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/plan/oracle/OracleExplainPlanProvider", "isAvailableFor"));
        }
        return DatabaseFamilyId.forDataSource((DatabaseSystem)dataSource).isOracle();
    }

    @Override
    @NotNull
    public <V> ScriptModel<V> adjustModel(ScriptModel<V> model) {
        ScriptModel scriptModel = model.rawTransform(st -> {
            SyntaxTraverser.Api api = st.api;
            return (SyntaxTraverser)st.forceIgnore(v -> {
                if (!(v instanceof SqlParameter)) {
                    return false;
                }
                CharSequence text = api.textOf(v);
                return text.equals("?") || StringUtil.startsWith((CharSequence)text, (CharSequence)":");
            });
        });
        if (scriptModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/oracle/OracleExplainPlanProvider", "adjustModel"));
        }
        return scriptModel;
    }

    @NotNull
    public static String getExplainPlanTable(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/plan/oracle/OracleExplainPlanProvider", "getExplainPlanTable"));
        }
        String res = dataSource.getExplainPlanConfiguration().getProviderConfig().get(PLAN_TABLE_KEY);
        String string = (String)ObjectUtils.chooseNotNull((Object)res, (Object)DEFAULT_PLAN_TABLE);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/oracle/OracleExplainPlanProvider", "getExplainPlanTable"));
        }
        return string;
    }

    public static void setExplainPlanTable(@NotNull LocalDataSource dataSource, @Nullable String table) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/plan/oracle/OracleExplainPlanProvider", "setExplainPlanTable"));
        }
        Map<String, String> config = dataSource.getExplainPlanConfiguration().getProviderConfig();
        if (table == null || table.equals(DEFAULT_PLAN_TABLE)) {
            config.remove(PLAN_TABLE_KEY);
        } else {
            config.put(PLAN_TABLE_KEY, table);
        }
    }

    @Override
    @Nullable
    public DataRequest.RawRequest createExplainRequest(@NotNull DataRequest.OwnerEx owner, @NotNull Consumer<PlanModel> consumer, @NotNull LocalDataSource dataSource, @NotNull String statement, boolean run) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/plan/oracle/OracleExplainPlanProvider", "createExplainRequest"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/plan/oracle/OracleExplainPlanProvider", "createExplainRequest"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/plan/oracle/OracleExplainPlanProvider", "createExplainRequest"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/plan/oracle/OracleExplainPlanProvider", "createExplainRequest"));
        }
        return new OraclePlanModelBuilder(owner, consumer, statement, OracleExplainPlanProvider.getExplainPlanTable(dataSource));
    }
}

