/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.dataSource.DataSource;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.actions.AlignedIconWithTextAction;
import com.intellij.database.util.Case;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.dbm.common.DbmModel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.ui.RowsDnDSupport;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.UIUtil;
import icons.DatabaseIcons;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseSchemaAction
extends AlignedIconWithTextAction
implements DumbAware {
    private static final Key<SchemasPopup> ACTIVE_POPUP = Key.create((String)"ACTIVE_SCHEMA_POPUP");
    public static final Comparator<ObjectPath> PATH_COMPARATOR = (o1, o2) -> StringUtil.naturalCompare((String)o1.getDisplayName(), (String)o2.getDisplayName());
    private static final FileAttribute SELECTED_SEARCH_PATH_ATTR = new FileAttribute("datasource_namespace", 1 + (FSRecords.persistentAttributesList ? 1 : 0), FSRecords.persistentAttributesList);

    public void actionPerformed(AnActionEvent e) {
        JdbcConsole console = JdbcConsole.getConsole(e);
        JComponent button = (JComponent)e.getPresentation().getClientProperty("customComponent");
        if (button == null || !button.isShowing() || console == null) {
            return;
        }
        ChooseSchemaAction.showPopup(console, button, e.getDataContext());
    }

    public void update(AnActionEvent e) {
        String tooltipText;
        List<Object> schemas;
        ObjectKind kind;
        JdbcConsole console = JdbcConsole.getConsole(e);
        JComponent button = (JComponent)e.getPresentation().getClientProperty("customComponent");
        DatabaseDialectEx dialect = console == null ? null : DbImplUtil.getDatabaseDialect(console);
        ObjectKind objectKind = kind = dialect == null ? null : ChooseSchemaAction.canSwitchNamespace(dialect);
        if (kind == null || !DbImplUtil.isAuthRequired(console.getDataSource())) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        SchemasPopup schemasPopup = (SchemasPopup)((Object)ACTIVE_POPUP.get((UserDataHolder)console.getLanguageConsole().getFile()));
        if (schemasPopup != null) {
            schemas = schemasPopup.myContainer.getPathItems();
        } else {
            schemas = SearchPath.getElements(console.getSearchPath());
            if (schemas.isEmpty() || ((ObjectPath)schemas.get((int)0)).kind == ObjectKind.NONE) {
                schemas = JBIterable.from((Iterable)((Iterable)DatabaseDataKeys.SEARCH_PATH_KEY.get((UserDataHolder)console.getLanguageConsole().getFile()))).transform(ObjectPath::of).filter(Conditions.notNull()).toList();
            }
        }
        boolean enabled = DbImplUtil.supportsDynamicSchemaSwitching(console.getDataSource());
        String fullText = !schemas.isEmpty() ? ChooseSchemaAction.buildText(schemas) : (enabled ? "<" + Case.LOWER.apply(kind.name()) + ">" : "");
        String text = fullText.length() <= 30 ? fullText : fullText.substring(0, 30) + "\u2026";
        boolean visible = StringUtil.isNotEmpty((String)text);
        String string = tooltipText = enabled ? "Switch current schema or user" : "Current schema";
        Icon icon = !enabled ? null : (UIUtil.isUnderDarcula() ? AllIcons.General.ComboArrow : AllIcons.General.ComboBoxButtonArrow);
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(visible);
        e.getPresentation().setText(text, false);
        e.getPresentation().setDescription(fullText);
        e.getPresentation().setDisabledIcon(icon);
        e.getPresentation().setIcon(icon);
        if (button != null) {
            button.setToolTipText(tooltipText);
            ((ActionButtonWithText)button).setHorizontalTextPosition(2);
        }
    }

    @NotNull
    private static String buildText(List<ObjectPath> schemas) {
        StringBuilder res = new StringBuilder();
        int pos = 0;
        while (pos < schemas.size()) {
            if (res.length() != 0) {
                res.append("; ");
            }
            ObjectPath cur = schemas.get(pos);
            if (++pos < schemas.size() && ChooseSchemaAction.hasSameParent(cur, schemas.get(pos))) {
                res.append(StringUtil.join(ChooseSchemaAction.getParentPath(cur), (String)"."));
                res.append(": ");
                res.append(cur.getName()).append(", ").append(schemas.get(pos).getName());
                ++pos;
                while (pos < schemas.size() && ChooseSchemaAction.hasSameParent(cur, schemas.get(pos))) {
                    res.append(", ").append(schemas.get(pos).getName());
                    ++pos;
                }
                continue;
            }
            res.append(cur.getDisplayName());
        }
        String string = res.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ChooseSchemaAction", "buildText"));
        }
        return string;
    }

    @NotNull
    private static List<String> getParentPath(@NotNull ObjectPath o1) {
        if (o1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/database/run/actions/ChooseSchemaAction", "getParentPath"));
        }
        List<String> list = o1.path.subList(0, o1.path.size() - 1);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ChooseSchemaAction", "getParentPath"));
        }
        return list;
    }

    private static boolean hasSameParent(@NotNull ObjectPath o1, @NotNull ObjectPath o2) {
        if (o1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/database/run/actions/ChooseSchemaAction", "hasSameParent"));
        }
        if (o2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/database/run/actions/ChooseSchemaAction", "hasSameParent"));
        }
        if (o1.path.size() <= 1 || o2.path.size() <= 1) {
            return false;
        }
        return ChooseSchemaAction.getParentPath(o1).equals(ChooseSchemaAction.getParentPath(o2));
    }

    private static void showPopup(JdbcConsole console, JComponent button, DataContext dataContext) {
        boolean canSwitchSchema;
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(console);
        boolean bl = canSwitchSchema = ChooseSchemaAction.canSwitchNamespace(dialect) != null;
        if (canSwitchSchema) {
            HashSet visited = ContainerUtil.newHashSet();
            LocalDataSource dataSource = console.getDataSource();
            JBIterable namespaces = DasUtil.getNamespaces((DataSource)dataSource);
            if (!(dataSource.getModel() instanceof DbmModel)) {
                namespaces = JBIterable.from((Iterable)namespaces.transform(DasUtil.TO_PARENT).filter(Condition.NOT_NULL).toSet()).append((Iterable)namespaces);
            }
            ArrayList paths = ContainerUtil.newArrayList();
            ArrayList others = ContainerUtil.newArrayList();
            paths.addAll(SearchPath.getElements(console.getSearchPath()));
            visited.addAll(paths);
            for (DasObject namespace : namespaces) {
                ObjectPath path = ObjectPath.of(namespace);
                if (path == null || !visited.add(path) || dialect.sqlSetSearchPath(SearchPath.of(path)) == null) continue;
                others.add(path);
            }
            SchemasPopup popup = new SchemasPopup(console, SchemaContainer.autoMultiMode(paths, others, dialect.supportsSearchPath(), PATH_COMPARATOR), dialect.supportsSearchPath(), (UserDataHolder)console.getLanguageConsole().getFile());
            popup.setMinimumSize(button.getSize());
            popup.showUnderneathOf(button);
        }
    }

    private static ObjectKind canSwitchNamespace(@NotNull DatabaseDialectEx dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/run/actions/ChooseSchemaAction", "canSwitchNamespace"));
        }
        List<String> path = Arrays.asList("no", "way");
        for (ObjectKind kind : dialect.getMetaModel().getNamespaces()) {
            if (dialect.sqlSetSearchPath(SearchPath.of(new ObjectPath(kind, path))) == null) continue;
            return kind;
        }
        return null;
    }

    private static void switchTo(JdbcConsole console, @NotNull SearchPath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/run/actions/ChooseSchemaAction", "switchTo"));
        }
        if (!Comparing.equal((Object)console.getSearchPath(), (Object)path)) {
            console.switchSchema(path, true);
        }
    }

    private static boolean canSwitchUser(@NotNull JdbcConsole console, @NotNull DatabaseDialectEx dialect) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/run/actions/ChooseSchemaAction", "canSwitchUser"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/run/actions/ChooseSchemaAction", "canSwitchUser"));
        }
        return false;
    }

    private static void switchUser(@NotNull JdbcConsole console) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/run/actions/ChooseSchemaAction", "switchUser"));
        }
    }

    public static void scheduleSchemaSwitch(@NotNull JdbcConsole console, @Nullable List<DasNamespace> o) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/run/actions/ChooseSchemaAction", "scheduleSchemaSwitch"));
        }
        if ((o = ChooseSchemaAction.getSchemaToSwitchToInner(console, o)) == null) {
            return;
        }
        SearchPath path = SearchPath.of(o);
        if (path == null) {
            return;
        }
        console.switchSchema(path, false);
        DatabaseDataKeys.SEARCH_PATH_KEY.set((UserDataHolder)console.getLanguageConsole().getFile(), o);
    }

    @Nullable
    private static List<DasNamespace> getSchemaToSwitchToInner(final @NotNull JdbcConsole console, @Nullable List<DasNamespace> o) {
        DasNamespace item;
        SearchPath schemaPaths;
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/run/actions/ChooseSchemaAction", "getSchemaToSwitchToInner"));
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(console);
        SearchPath searchPath = schemaPaths = o != null ? null : ChooseSchemaAction.getSelectedSearchPath(console.getLanguageConsole().getVirtualFile(), dialect);
        if (schemaPaths != null && schemaPaths.getCurrent().kind != ObjectKind.NONE) {
            LocalDataSource localDataSource = console.getDataSource();
            if (localDataSource.isLoading()) {
                Project project = console.getProject();
                final Disposable listenerDisposable = Disposer.newDisposable();
                Disposer.register((Disposable)console, (Disposable)listenerDisposable);
                DbPsiFacade.getInstance((Project)project).addModificationTrackerListener((ModificationTrackerListener)new ModificationTrackerListener<DbPsiFacade>(){

                    public void modificationCountChanged(DbPsiFacade source) {
                        Disposer.dispose((Disposable)listenerDisposable);
                        ChooseSchemaAction.scheduleSchemaSwitch(console, null);
                    }
                }, listenerDisposable);
            } else {
                o = JBIterable.from(SearchPath.getElements(schemaPaths)).transform(x -> {
                    if (console == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/run/actions/ChooseSchemaAction", "lambda$getSchemaToSwitchToInner$1"));
                    }
                    return DatabaseEditorHelper.findNamespace(console.getProject(), (DatabaseSystem)localDataSource, x);
                }).filter(Conditions.notNull()).toList();
            }
        }
        return (item = (DasNamespace)ContainerUtil.getFirstItem(o)) != null && (item.getKind() == ObjectKind.SCHEMA || item.getKind() == ObjectKind.DATABASE) ? o : null;
    }

    public static void setSelectedSearchPath(@NotNull VirtualFile file, @Nullable SearchPath schemaPaths) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/run/actions/ChooseSchemaAction", "setSelectedSearchPath"));
        }
        DbImplUtil.writeVFSAttributeSafe(file, SELECTED_SEARCH_PATH_ATTR, SearchPath.serialize(schemaPaths));
    }

    @Nullable
    private static SearchPath getSelectedSearchPath(@NotNull VirtualFile file, @NotNull DatabaseDialectEx dialect) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/run/actions/ChooseSchemaAction", "getSelectedSearchPath"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/run/actions/ChooseSchemaAction", "getSelectedSearchPath"));
        }
        return SearchPath.deserializeList(DbImplUtil.readVFSAttributeSafe(file, SELECTED_SEARCH_PATH_ATTR), dialect.getMetaModel());
    }

    private static class SchemaContainer<T> {
        private int mySepPos;
        private final List<T> myItems;
        private boolean myMultiMode;
        private final Comparator<T> myComp;

        public static <T> SchemaContainer<T> autoMultiMode(@NotNull List<T> path, @NotNull Collection<T> other, boolean supportMulti, Comparator<T> comp) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/run/actions/ChooseSchemaAction$SchemaContainer", "autoMultiMode"));
            }
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/database/run/actions/ChooseSchemaAction$SchemaContainer", "autoMultiMode"));
            }
            ArrayList res = ContainerUtil.newArrayList(path);
            res.addAll(other);
            return new SchemaContainer<T>(res, path.size(), supportMulti && path.size() > 1, comp);
        }

        public SchemaContainer(@NotNull List<T> paths, int sepPos, boolean multiMode, Comparator<T> comp) {
            if (paths == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/intellij/database/run/actions/ChooseSchemaAction$SchemaContainer", "<init>"));
            }
            this.mySepPos = sepPos;
            this.myItems = paths;
            this.myMultiMode = true;
            this.myComp = comp;
            this.setMultiMode(multiMode, -1);
        }

        public int setMultiMode(boolean multi, int preserve) {
            if (this.myMultiMode == multi) {
                return preserve;
            }
            this.myMultiMode = multi;
            T preserved = this.get(preserve);
            if (multi) {
                if (this.mySepPos == -1) {
                    this.mySepPos = 0;
                } else {
                    if (this.mySepPos != 0) {
                        this.myItems.add(0, this.myItems.remove(this.mySepPos));
                    }
                    this.mySepPos = 1;
                }
                this.sort();
            } else {
                Object cur = this.mySepPos == -1 ? null : this.get(0);
                this.sort();
                this.mySepPos = this.myItems.indexOf(cur);
            }
            return this.myItems.indexOf(preserved);
        }

        public T get(int i) {
            return this.isValid(i) ? (T)this.myItems.get(i) : null;
        }

        private boolean isValid(int i) {
            return i >= 0 && i < this.myItems.size();
        }

        public int currentSize() {
            return this.myMultiMode ? this.mySepPos : (this.mySepPos == -1 ? 0 : 1);
        }

        public int setInPath(int index, boolean add) {
            if (!this.isValid(index) || this.isInPath(index)) {
                return index;
            }
            if (add) {
                if (!this.myMultiMode) {
                    index = this.setMultiMode(true, index);
                }
                this.myItems.add(this.mySepPos, this.myItems.remove(index));
                ++this.mySepPos;
                return this.mySepPos - 1;
            }
            if (!this.myMultiMode) {
                this.mySepPos = index;
                return index;
            }
            this.myItems.add(0, this.myItems.remove(index));
            this.mySepPos = 1;
            this.sort();
            return 0;
        }

        public int removeFromPath(int index) {
            if (!this.isValid(index) || !this.isInPath(index)) {
                return index;
            }
            if (!this.myMultiMode) {
                this.mySepPos = -1;
                return index;
            }
            T item = this.myItems.remove(index);
            this.myItems.add(item);
            --this.mySepPos;
            this.sort();
            return this.myItems.indexOf(item);
        }

        public int moveInPath(int from, int to) {
            assert (this.myMultiMode);
            assert (from < this.mySepPos);
            assert (to <= this.mySepPos);
            if (from == to || from + 1 == to) {
                return from;
            }
            if (from > to) {
                this.myItems.add(to, this.myItems.remove(from));
                return to;
            }
            this.myItems.add(to - 1, this.myItems.remove(from));
            return to - 1;
        }

        public boolean isInPath(int index) {
            return this.myMultiMode ? index < this.mySepPos : index == this.mySepPos;
        }

        public boolean isMultiMode() {
            return this.myMultiMode;
        }

        public boolean isSeparator(int index) {
            return this.myMultiMode && index == this.mySepPos;
        }

        private void sort() {
            List<T> list = this.myMultiMode ? this.myItems.subList(this.mySepPos, this.myItems.size()) : this.myItems;
            Collections.sort(list, this.myComp);
        }

        @NotNull
        public List<T> getItems() {
            List<T> list = this.myItems;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ChooseSchemaAction$SchemaContainer", "getItems"));
            }
            return list;
        }

        @NotNull
        public List<T> getPathItems() {
            List list = this.myMultiMode ? this.myItems.subList(0, this.mySepPos) : (this.mySepPos == -1 ? Collections.emptyList() : this.myItems.subList(this.mySepPos, this.mySepPos + 1));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ChooseSchemaAction$SchemaContainer", "getPathItems"));
            }
            return list;
        }
    }

    private static class SchemasPopup
    extends ListPopupImpl {
        private final boolean mySupportsMulti;
        private final UserDataHolder myHolder;
        private final SchemaContainer<ObjectPath> myContainer;

        public SchemasPopup(final @NotNull JdbcConsole console, @NotNull SchemaContainer<ObjectPath> container, boolean supportsMulti, UserDataHolder dataHolder) {
            if (console == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/run/actions/ChooseSchemaAction$SchemasPopup", "<init>"));
            }
            if (container == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/database/run/actions/ChooseSchemaAction$SchemasPopup", "<init>"));
            }
            super((ListPopupStep)new MyStep(container, supportsMulti), 15);
            this.mySupportsMulti = supportsMulti;
            this.myHolder = dataHolder;
            this.myContainer = container;
            MyStep step = (MyStep)((Object)ObjectUtils.tryCast((Object)this.getStep(), MyStep.class));
            assert (step != null);
            this.registerAction("Select schema", 10, 0, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!myContainer.isMultiMode()) {
                        this.update(myContainer.setInPath(this.getSelectedIdx(), false));
                    }
                    this.closeOk(null);
                }
            });
            this.registerAction("Toggle schema", 32, 0, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.toggleItem(this.getSelectedIdx());
                }
            });
            new AnAction("Move up"){

                public void actionPerformed(AnActionEvent e) {
                    this.moveItem(this.getSelectedIdx(), true);
                }
            }.registerCustomShortcutSet(CommonShortcuts.MOVE_UP, (JComponent)this.getList());
            new AnAction("Move down"){

                public void actionPerformed(AnActionEvent e) {
                    this.moveItem(this.getSelectedIdx(), false);
                }
            }.registerCustomShortcutSet(CommonShortcuts.MOVE_DOWN, (JComponent)this.getList());
            this.getList().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    boolean ctrl;
                    int listIdx = this.getList().locationToIndex(e.getPoint());
                    if (listIdx == -1) {
                        return;
                    }
                    int idx = this.toContainerIdx(listIdx);
                    boolean bl = ctrl = (e.getModifiers() & 2) != 0 || this.isInControlZone(listIdx, e.getPoint());
                    if (!mySupportsMulti || !ctrl && !myContainer.isMultiMode()) {
                        this.update(myContainer.setInPath(idx, false));
                        this.closeOk(e);
                    } else if (!myContainer.isInPath(idx) || ctrl) {
                        this.toggleItem(idx);
                    }
                }
            });
            this.getList().addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    this.getList().repaint();
                }
            });
            if (this.mySupportsMulti) {
                RowsDnDSupport.install((JList)this.getList(), (EditableModel)new EditableModel(){

                    public void addRow() {
                        throw new UnsupportedOperationException();
                    }

                    public void exchangeRows(int oldIndex, int newIndex) {
                        if (myContainer.isInPath(oldIndex)) {
                            if (myContainer.isInPath(newIndex)) {
                                this.update(myContainer.moveInPath(oldIndex, newIndex));
                            } else {
                                this.update(myContainer.removeFromPath(oldIndex));
                            }
                        } else if (myContainer.isInPath(newIndex)) {
                            this.update(myContainer.setInPath(oldIndex, true));
                        }
                    }

                    public boolean canExchangeRows(int oldIndex, int newIndex) {
                        return myContainer.isInPath(oldIndex) || myContainer.isInPath(newIndex);
                    }

                    public void removeRow(int idx) {
                        throw new UnsupportedOperationException();
                    }
                });
            }
            this.addListener((JBPopupListener)new JBPopupListener.Adapter(){

                public void onClosed(LightweightWindowEvent event) {
                    if (!event.isOk()) {
                        return;
                    }
                    SearchPath p = SearchPath.of(myContainer.getPathItems());
                    if (p == null) {
                        return;
                    }
                    ChooseSchemaAction.switchTo(console, p);
                }
            });
            this.updateAdvertisement();
            if (!supportsMulti) {
                FontMetrics metrics = this.getList().getFontMetrics(this.getList().getFont());
                int w = SwingUtilities.computeStringWidth(metrics, "Schema") * 2;
                Dimension size = this.getContent().getPreferredSize();
                this.setSize(new Dimension(Math.max(size.width, w), size.height));
            } else if (!this.myContainer.isMultiMode()) {
                Dimension size = this.getContent().getPreferredSize();
                Dimension cellSize = this.getListElementRenderer().getListCellRendererComponent(this.getList(), new ObjectPath(ObjectKind.NONE, Collections.singletonList("A")), 0, false, false).getPreferredSize();
                this.setSize(new Dimension(size.width, size.height + cellSize.height));
            }
            this.getList().getSelectionModel().addListSelectionListener(e -> this.updateAdvertisement());
            ACTIVE_POPUP.set(this.myHolder, (Object)this);
        }

        private int getSelectedIdx() {
            return this.toContainerIdx(this.getSelectedIndex());
        }

        private int toContainerIdx(int idx) {
            return this.myContainer.getItems().indexOf(ObjectUtils.tryCast((Object)this.getListModel().get(idx), ObjectPath.class));
        }

        private int toListIdx(int idx) {
            if (idx < 0 || idx >= this.myContainer.getItems().size()) {
                return -1;
            }
            ObjectPath item = this.myContainer.getItems().get(idx);
            int sz = this.getListModel().getSize();
            for (int i = 0; i < sz; ++i) {
                if (this.getListModel().get(i) != item) continue;
                return i;
            }
            return -1;
        }

        private boolean isInControlZone(int index, Point pt) {
            Rectangle bounds = this.getList().getCellBounds(index, index);
            return bounds.contains(pt) && (double)pt.x > (double)(bounds.x + bounds.width) - (double)bounds.height * 1.2;
        }

        private void toggleItem(int idx) {
            int newIdx;
            if (!this.mySupportsMulti) {
                return;
            }
            boolean inPath = this.myContainer.isInPath(idx);
            if (inPath && this.myContainer.currentSize() < 2) {
                return;
            }
            if (inPath) {
                this.myContainer.removeFromPath(idx);
                newIdx = this.myContainer.isInPath(idx) ? idx : Math.max(idx - 1, 0);
            } else {
                this.myContainer.setInPath(idx, true);
                newIdx = Math.min(idx + 1, this.myContainer.getItems().size() - 1);
            }
            this.update(newIdx);
        }

        private void moveItem(int idx, boolean up) {
            if (!this.myContainer.isMultiMode()) {
                return;
            }
            if (this.myContainer.isInPath(idx)) {
                if (!up && idx + 1 == this.myContainer.currentSize() || up && idx == 0) {
                    if (this.myContainer.currentSize() < 2) {
                        return;
                    }
                    this.update(this.myContainer.removeFromPath(idx));
                } else {
                    this.update(this.myContainer.moveInPath(idx, idx + (up ? -1 : 2)));
                }
            } else {
                idx = this.myContainer.setInPath(idx, true);
                if (!up) {
                    idx = this.myContainer.moveInPath(idx, 0);
                }
                this.update(idx);
            }
        }

        private void updateAdvertisement() {
            if (this.mySupportsMulti) {
                if (!this.myContainer.isMultiMode()) {
                    this.setAdText("<html>Add schemas to search path<br>with Ctrl+Click or Space</html>");
                } else if (this.myContainer.isInPath(this.getSelectedIdx())) {
                    this.setAdText("<html>To reorder, drag or press<br>" + KeymapUtil.getShortcutsText((Shortcut[])CommonShortcuts.MOVE_UP.getShortcuts()) + " or " + KeymapUtil.getShortcutsText((Shortcut[])CommonShortcuts.MOVE_DOWN.getShortcuts()) + "</html>");
                } else {
                    this.setAdText("<html>To add, click or press Space.<br>Apply with Enter</html>");
                }
            }
        }

        public void dispose() {
            super.dispose();
            if (ACTIVE_POPUP.get(this.myHolder) == this) {
                ACTIVE_POPUP.set(this.myHolder, null);
            }
        }

        public void cancel(InputEvent e) {
            if (e instanceof MouseEvent) {
                this.setOk(true);
            }
            super.cancel(e);
        }

        protected boolean isActionClick(MouseEvent e) {
            return false;
        }

        private void update(int toSelect) {
            ObjectPath item = toSelect == -1 ? null : this.myContainer.getItems().get(toSelect);
            this.getListModel().updateOriginalList();
            if (item != null) {
                this.getList().setSelectedValue(item, true);
            }
            this.getList().validate();
            this.getList().repaint();
        }

        protected ListCellRenderer getListElementRenderer() {
            return new PopupListElementRenderer(this){
                {
                    super(x0);
                    Font font = this.mySeparatorComponent.getFont();
                    this.mySeparatorComponent.setFont(font.deriveFont(UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.MINI)));
                }

                protected void customizeComponent(JList list, Object value, boolean isSelected) {
                    super.customizeComponent(list, value, isSelected);
                    this.myNextStepLabel.setVisible(true);
                    Icon icon = null;
                    if (isSelected && mySupportsMulti) {
                        Icon del;
                        Icon add;
                        int pos = myContainer.getItems().indexOf(value);
                        Point pt = MouseInfo.getPointerInfo().getLocation();
                        SwingUtilities.convertPointFromScreen(pt, this.getList());
                        boolean ctrl = this.isInControlZone(this.toListIdx(pos), pt);
                        Icon icon2 = add = ctrl ? DatabaseIcons.Add_hover : DatabaseIcons.Add;
                        if (myContainer.isMultiMode()) {
                            add = null;
                        }
                        Icon icon3 = del = ctrl ? AllIcons.Welcome.Project.Remove_hover : AllIcons.Welcome.Project.Remove;
                        if (!myContainer.isMultiMode() || myContainer.currentSize() < 2) {
                            del = null;
                        }
                        icon = myContainer.isInPath(pos) ? del : add;
                    }
                    this.myNextStepLabel.setIcon(icon);
                }
            };
        }

        private static class MyStep
        extends BaseStep<ObjectPath>
        implements ListPopupStep<ObjectPath> {
            private final ListSeparator myAvailSeparator = new ListSeparator("Add to Search Path");
            private final SchemaContainer<ObjectPath> myContainer;
            private final boolean mySupportsMulti;

            private MyStep(SchemaContainer<ObjectPath> container, boolean supportsMulti) {
                this.myContainer = container;
                this.mySupportsMulti = supportsMulti;
            }

            @NotNull
            public String getTextFor(ObjectPath value) {
                String string = value == null ? "" : value.getDisplayName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ChooseSchemaAction$SchemasPopup$MyStep", "getTextFor"));
                }
                return string;
            }

            @Nullable
            public ListSeparator getSeparatorAbove(ObjectPath value) {
                return this.myContainer.isSeparator(this.myContainer.getItems().indexOf(value)) ? this.myAvailSeparator : null;
            }

            public int getDefaultOptionIndex() {
                return 0;
            }

            @NotNull
            public List<ObjectPath> getValues() {
                List<ObjectPath> list = this.myContainer.getItems();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ChooseSchemaAction$SchemasPopup$MyStep", "getValues"));
                }
                return list;
            }

            public boolean isSelectable(ObjectPath value) {
                return value != null;
            }

            @Nullable
            public Icon getIconFor(ObjectPath aValue) {
                return null;
            }

            @Nullable
            public String getTitle() {
                return this.mySupportsMulti ? "Search Path" : "Schema";
            }

            @Nullable
            public PopupStep onChosen(ObjectPath selectedValue, boolean finalChoice) {
                return null;
            }

            public boolean hasSubstep(ObjectPath selectedValue) {
                return false;
            }

            public void canceled() {
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public boolean isAutoSelectionEnabled() {
                return false;
            }

            public boolean canBeHidden(ObjectPath value) {
                return !this.myContainer.isMultiMode() || !this.myContainer.isInPath(this.myContainer.getItems().indexOf(value));
            }
        }
    }
}

