/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataExtractorFactories;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.DataExtractorProperties;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.ide.CopyProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.TextTransferable;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import org.jetbrains.annotations.NotNull;

public class GridCopyProvider
implements CopyProvider {
    private final DataGrid myGrid;

    public GridCopyProvider(@NotNull DataGrid grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/GridCopyProvider", "<init>"));
        }
        this.myGrid = grid;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/run/ui/grid/GridCopyProvider", "performCopy"));
        }
        DataExtractor extractor = this.createExtractor(dataContext);
        String data = DataGridUtil.extractSelectedValues(this.myGrid, extractor).toString();
        boolean htmlNeeded = extractor.getFileExtension().contains("htm");
        CopyPasteManager.getInstance().setContents((Transferable)(htmlNeeded ? new TextTransferable(data) : new StringSelection(data)));
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/run/ui/grid/GridCopyProvider", "isCopyEnabled"));
        }
        return !this.myGrid.isEditing() && !this.myGrid.isEmpty();
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/run/ui/grid/GridCopyProvider", "isCopyVisible"));
        }
        return true;
    }

    @NotNull
    private DataExtractor createExtractor(@NotNull DataContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/ui/grid/GridCopyProvider", "createExtractor"));
        }
        SelectionModel selectionModel = this.myGrid.getSelectionModel();
        if (selectionModel.getSelectedRowCount() == 1 && selectionModel.getSelectedColumnCount() == 1) {
            DataExtractor dataExtractor = ExtractorsUtil.getSingleValueExtractor(this.myGrid.getObjectFormatter());
            if (dataExtractor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/GridCopyProvider", "createExtractor"));
            }
            return dataExtractor;
        }
        Project project = DataGridUtil.getProject(this.myGrid);
        DataExtractorFactory extractorFactory = DataExtractorProperties.getCurrentExtractorFactory(project);
        DataExtractor extractor = extractorFactory.createExtractor(context);
        extractor = extractor != null ? extractor : DataExtractorFactories.getDefault().createExtractor(context);
        DataExtractor dataExtractor = (DataExtractor)ObjectUtils.assertNotNull((Object)extractor);
        if (dataExtractor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/GridCopyProvider", "createExtractor"));
        }
        return dataExtractor;
    }
}

