/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.lexers.PostgresRangeLexerAdapter;
import com.intellij.database.run.ui.grid.editors.lexers.PostgresRangeTokens;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import java.text.ParseException;
import java.text.ParsePosition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FakeRangeFormatter
implements Formatter {
    @NotNull
    private final Formatter myFormatter;

    public FakeRangeFormatter(@NotNull Formatter formatter) {
        if (formatter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatter", "com/intellij/database/run/ui/grid/editors/FakeRangeFormatter", "<init>"));
        }
        this.myFormatter = formatter;
    }

    @Override
    @Nullable
    public Object parse(@NotNull String value) throws ParseException {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/FakeRangeFormatter", "parse"));
        }
        try {
            return this.rebuild(this.parseInternal(value, new ParsePosition(0)));
        }
        catch (TokenizeException e) {
            throw new ParseException(value, e.getPosition());
        }
    }

    @Override
    @Nullable
    public Object parse(@NotNull String value, @NotNull ParsePosition position) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/FakeRangeFormatter", "parse"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/database/run/ui/grid/editors/FakeRangeFormatter", "parse"));
        }
        try {
            return this.rebuild(this.parseInternal(value, position));
        }
        catch (TokenizeException e) {
            position.setErrorIndex(e.getPosition());
            return null;
        }
    }

    public ParsedRange parseHonestly(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/FakeRangeFormatter", "parseHonestly"));
        }
        return this.parseInternal(value, new ParsePosition(0));
    }

    @NotNull
    private ParsedRange parseInternal(@NotNull String value, @NotNull ParsePosition position) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/FakeRangeFormatter", "parseInternal"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/database/run/ui/grid/editors/FakeRangeFormatter", "parseInternal"));
        }
        PostgresRangeLexerAdapter lexer = new PostgresRangeLexerAdapter();
        lexer.start(value);
        if (lexer.getTokenType() == PostgresRangeTokens.EMPTY) {
            ParsedRange parsedRange = ParsedRange.EMPTY;
            if (parsedRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/FakeRangeFormatter", "parseInternal"));
            }
            return parsedRange;
        }
        String leftBrace = FakeRangeFormatter.getTokenText((Lexer)lexer, PostgresRangeTokens.LEFT_BRACKET, position);
        lexer.advance();
        Pair<Object, String> first = this.getValueAndNext((Lexer)lexer, position, PostgresRangeTokens.COMMA);
        lexer.advance();
        Pair<Object, String> second = this.getValueAndNext((Lexer)lexer, position, PostgresRangeTokens.RIGHT_BRACKET);
        lexer.advance();
        FakeRangeFormatter.checkType((Lexer)lexer, null, position);
        ParsedRange parsedRange = new ParsedRange(first.getFirst(), second.getFirst(), leftBrace, (String)second.getSecond(), value);
        if (parsedRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/FakeRangeFormatter", "parseInternal"));
        }
        return parsedRange;
    }

    private Pair<Object, String> getValueAndNext(@NotNull Lexer lexer, @NotNull ParsePosition position, IElementType next) {
        if (lexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/database/run/ui/grid/editors/FakeRangeFormatter", "getValueAndNext"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/database/run/ui/grid/editors/FakeRangeFormatter", "getValueAndNext"));
        }
        try {
            FakeRangeFormatter.checkType(lexer, PostgresRangeTokens.VALUE, position, false);
            Object result = this.myFormatter.parse(StringUtil.replace((String)lexer.getTokenText(), (String)"\"", (String)""));
            lexer.advance();
            return Pair.create((Object)result, (Object)FakeRangeFormatter.getTokenText(lexer, next, position));
        }
        catch (TokenizeException | ParseException ignore) {
            return Pair.create(null, (Object)FakeRangeFormatter.getTokenText(lexer, next, position));
        }
    }

    private static String getTokenText(@NotNull Lexer lexer, IElementType type, @NotNull ParsePosition position) {
        if (lexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/database/run/ui/grid/editors/FakeRangeFormatter", "getTokenText"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/database/run/ui/grid/editors/FakeRangeFormatter", "getTokenText"));
        }
        FakeRangeFormatter.checkType(lexer, type, position);
        return lexer.getTokenText();
    }

    private static void checkType(@NotNull Lexer lexer, IElementType type, @NotNull ParsePosition position) {
        if (lexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/database/run/ui/grid/editors/FakeRangeFormatter", "checkType"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/database/run/ui/grid/editors/FakeRangeFormatter", "checkType"));
        }
        FakeRangeFormatter.checkType(lexer, type, position, true);
    }

    private static void checkType(@NotNull Lexer lexer, IElementType type, @NotNull ParsePosition position, boolean updatePosition) {
        if (lexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/database/run/ui/grid/editors/FakeRangeFormatter", "checkType"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/database/run/ui/grid/editors/FakeRangeFormatter", "checkType"));
        }
        if (lexer.getTokenType() != type) {
            throw new TokenizeException(lexer.getCurrentPosition().getOffset());
        }
        if (updatePosition) {
            position.setIndex(lexer.getCurrentPosition().getOffset());
        }
    }

    @Override
    @NotNull
    public String format(@NotNull Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/FakeRangeFormatter", "format"));
        }
        String string = (String)value;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/FakeRangeFormatter", "format"));
        }
        return string;
    }

    public String rebuild(@NotNull ParsedRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/database/run/ui/grid/editors/FakeRangeFormatter", "rebuild"));
        }
        String stringValue = range.getString();
        if (range == ParsedRange.EMPTY) {
            return stringValue;
        }
        return range.getLeftBrace() + (range.getStart() != null ? this.myFormatter.format(range.getStart()) : "") + "," + (range.getEnd() != null ? this.myFormatter.format(range.getEnd()) : "") + range.getRightBrace();
    }

    @NotNull
    public String toString() {
        String string = this.myFormatter.toString() + ", " + this.myFormatter.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/FakeRangeFormatter", "toString"));
        }
        return string;
    }

    private static class TokenizeException
    extends RuntimeException {
        private final int myPosition;

        TokenizeException(int position) {
            this.myPosition = position;
        }

        public int getPosition() {
            return this.myPosition;
        }
    }

    public static class ParsedRange {
        public static final ParsedRange EMPTY = new ParsedRange(null, null, null, null, "empty");
        private final Object myStart;
        private final Object myEnd;
        private final String myString;
        private final String myLeftBrace;
        private final String myRightBrace;

        ParsedRange(Object start, Object end, String leftBrace, String rightBrace, String string) {
            this.myStart = start;
            this.myEnd = end;
            this.myLeftBrace = leftBrace;
            this.myRightBrace = rightBrace;
            this.myString = string;
        }

        public Object getStart() {
            return this.myStart;
        }

        public Object getEnd() {
            return this.myEnd;
        }

        public String getString() {
            return this.myString;
        }

        public String getLeftBrace() {
            return this.myLeftBrace;
        }

        public String getRightBrace() {
            return this.myRightBrace;
        }
    }
}

