/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.renderers;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.run.ui.grid.renderers.GridCellRenderer;
import com.intellij.database.run.ui.grid.renderers.GridCellRendererFactory;
import com.intellij.database.run.ui.grid.renderers.GridColumnTypeInfo;
import com.intellij.util.ui.ThreeStateCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultBooleanRendererFactory
implements GridCellRendererFactory {
    @Override
    public boolean supportsDialect(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/run/ui/grid/renderers/DefaultBooleanRendererFactory", "supportsDialect"));
        }
        return true;
    }

    @Override
    public boolean supportsColumn(@NotNull GridColumnTypeInfo columnTypeInfo) {
        if (columnTypeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnTypeInfo", "com/intellij/database/run/ui/grid/renderers/DefaultBooleanRendererFactory", "supportsColumn"));
        }
        return DefaultBooleanRendererFactory.supportsColumn(columnTypeInfo.sqlType, columnTypeInfo.clazz, columnTypeInfo.precision);
    }

    @Override
    @NotNull
    public GridCellRenderer createRenderer(@NotNull DataGrid grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/renderers/DefaultBooleanRendererFactory", "createRenderer"));
        }
        BooleanRenderer booleanRenderer = new BooleanRenderer(grid);
        if (booleanRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/renderers/DefaultBooleanRendererFactory", "createRenderer"));
        }
        return booleanRenderer;
    }

    private static boolean supportsColumn(int sqlType, String clazz, int precision) {
        return sqlType == 16 || sqlType == -7 || "java.lang.Boolean".equals(clazz) && precision <= 1;
    }

    private static class BooleanRenderer
    extends GridCellRenderer {
        private final ThreeStateCheckBox myComponent;

        public BooleanRenderer(@NotNull DataGrid grid) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/renderers/DefaultBooleanRendererFactory$BooleanRenderer", "<init>"));
            }
            super(grid);
            this.myComponent = new ThreeStateCheckBox();
            this.myComponent.setHorizontalAlignment(0);
        }

        @Override
        public int getSuitability(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
            if (row == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/renderers/DefaultBooleanRendererFactory$BooleanRenderer", "getSuitability"));
            }
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/renderers/DefaultBooleanRendererFactory$BooleanRenderer", "getSuitability"));
            }
            DataConsumer.Column c = this.grid.getDataModel().getColumn(column);
            if (c == null || !DefaultBooleanRendererFactory.supportsColumn(c.type, c.clazz, c.precision)) {
                return 0;
            }
            Object value = this.grid.getDataModel().getValueAt(row, column);
            boolean ofSupportedType = value == null || BooleanRenderer.getBooleanValue(value) != null;
            return ofSupportedType ? 1 : 0;
        }

        @Override
        @NotNull
        public JComponent getComponent(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
            if (row == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/renderers/DefaultBooleanRendererFactory$BooleanRenderer", "getComponent"));
            }
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/renderers/DefaultBooleanRendererFactory$BooleanRenderer", "getComponent"));
            }
            Object value = this.grid.getDataModel().getValueAt(row, column);
            this.myComponent.setState(BooleanRenderer.getCheckboxState(value));
            ThreeStateCheckBox threeStateCheckBox = this.myComponent;
            if (threeStateCheckBox == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/renderers/DefaultBooleanRendererFactory$BooleanRenderer", "getComponent"));
            }
            return threeStateCheckBox;
        }

        @NotNull
        private static ThreeStateCheckBox.State getCheckboxState(Object value) {
            Boolean b = BooleanRenderer.getBooleanValue(value);
            ThreeStateCheckBox.State state = Boolean.TRUE.equals(b) ? ThreeStateCheckBox.State.SELECTED : (Boolean.FALSE.equals(b) ? ThreeStateCheckBox.State.NOT_SELECTED : ThreeStateCheckBox.State.DONT_CARE);
            if (state == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/renderers/DefaultBooleanRendererFactory$BooleanRenderer", "getCheckboxState"));
            }
            return state;
        }

        @Nullable
        private static Boolean getBooleanValue(@Nullable Object value) {
            return value instanceof Boolean ? (Boolean)value : (value instanceof Number ? Boolean.valueOf(((Number)value).intValue() == 1) : (value instanceof String ? BooleanRenderer.parseBoolean((String)value) : null));
        }

        @Nullable
        private static Boolean parseBoolean(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/renderers/DefaultBooleanRendererFactory$BooleanRenderer", "parseBoolean"));
            }
            return "1".equals(value) ? Boolean.TRUE : ("0".equals(value) ? Boolean.FALSE : null);
        }
    }
}

