/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.fix;

import com.intellij.database.schemaEditor.fix.DdlGraphFixing;
import com.intellij.database.schemaEditor.generation.DdlGenerator;
import com.intellij.database.schemaEditor.generation.DdlGraph;
import com.intellij.database.schemaEditor.generation.DdlGraphBuilder;
import com.intellij.database.schemaEditor.generation.DdlOperation;
import com.intellij.database.schemaEditor.generation.DdlOperationKey;
import com.intellij.database.schemaEditor.generation.ImplicitRenameOrder;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.operations.DasDdlOperations;
import com.intellij.openapi.util.UserDataHolder;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FixCyclicRename
implements DdlGraphFixing.CycleFixer {
    @Override
    public boolean fixCycle(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DdlGraph graph, @NotNull List<DdlOperationKey> cycle) {
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/schemaEditor/fix/FixCyclicRename", "fixCycle"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/fix/FixCyclicRename", "fixCycle"));
        }
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/database/schemaEditor/fix/FixCyclicRename", "fixCycle"));
        }
        if (cycle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cycle", "com/intellij/database/schemaEditor/fix/FixCyclicRename", "fixCycle"));
        }
        boolean prevConf = FixCyclicRename.isImplicitRenameDep(builder, cycle, cycle.size() - 1);
        for (int i = 0; i < cycle.size(); ++i) {
            boolean curConf = FixCyclicRename.isImplicitRenameDep(builder, cycle, i);
            if (curConf && prevConf && FixCyclicRename.processItem(generator, builder, cycle, i)) {
                return true;
            }
            prevConf = curConf;
        }
        return false;
    }

    private static boolean isImplicitRenameDep(@NotNull DdlGraphBuilder builder, @NotNull List<DdlOperationKey> cycle, int idx) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/fix/FixCyclicRename", "isImplicitRenameDep"));
        }
        if (cycle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cycle", "com/intellij/database/schemaEditor/fix/FixCyclicRename", "isImplicitRenameDep"));
        }
        DdlOperationKey current = cycle.get(idx);
        DdlOperationKey next = cycle.get((idx + 1) % cycle.size());
        return ImplicitRenameOrder.isRename(current) && ImplicitRenameOrder.isRename(next) && ImplicitRenameOrder.conflicts(current, next, builder);
    }

    private static boolean processItem(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull List<DdlOperationKey> cycle, int idx) {
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/schemaEditor/fix/FixCyclicRename", "processItem"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/fix/FixCyclicRename", "processItem"));
        }
        if (cycle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cycle", "com/intellij/database/schemaEditor/fix/FixCyclicRename", "processItem"));
        }
        DdlOperationKey current = cycle.get(idx);
        UserDataHolder data = builder.getData(current);
        DeObject from = DasDdlOperations.getAlterFrom(current.target, data);
        DeObject to = DasDdlOperations.getAlterTo(current.target, data);
        generator.removeOperation(builder, current.operation, current.target, data);
        if (data == null) {
            data = builder.newData(null);
        }
        DdlGraph.ALTER_TO.set(data, (Object)to);
        generator.addOperation(builder, DdlOperation.TEMPORARY_RENAME, from, data);
        return true;
    }
}

