/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.generation;

import com.intellij.database.schemaEditor.generation.DdlOperationKey;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.BidirectionalMultiMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.Stack;
import com.intellij.util.graph.Graph;
import gnu.trove.TObjectIntHashMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DdlGraph
implements Graph<DdlOperationKey> {
    private final Collection<DdlOperationKey> myNodes;
    private final Map<DdlOperationKey, UserDataHolder> myData;
    private final BidirectionalMultiMap<DdlOperationKey, DdlOperationKey> myEdges;
    private ThreeState myHasCycles;
    public static final Key<DeObject> ALTER_FROM = Key.create((String)"ALTER_FROM");
    public static final Key<DeObject> ALTER_TO = Key.create((String)"ALTER_TO");

    @NotNull
    public static JBIterable<DdlOperationKey> notNullize(@Nullable DdlOperationKey op) {
        JBIterable jBIterable = op == null ? JBIterable.empty() : JBIterable.of((Object[])new DdlOperationKey[]{op});
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGraph", "notNullize"));
        }
        return jBIterable;
    }

    public static <T> boolean visitDfs(@NotNull Graph<T> graph, @NotNull T start, @NotNull DfsVisitor<T> visitor) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/database/schemaEditor/generation/DdlGraph", "visitDfs"));
        }
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/database/schemaEditor/generation/DdlGraph", "visitDfs"));
        }
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/database/schemaEditor/generation/DdlGraph", "visitDfs"));
        }
        TObjectIntHashMap colors = new TObjectIntHashMap();
        Stack stack = ContainerUtil.newStack();
        stack.add(start);
        while (!stack.isEmpty()) {
            Object cur = stack.peek();
            if (colors.containsKey(cur)) {
                boolean black;
                boolean bl = black = colors.get(cur) == 1;
                if (!black) {
                    colors.put(cur, 1);
                }
                stack.pop();
                if (black || visitor.visit(cur, DfsVisitor.Reason.LEAVE)) continue;
                return false;
            }
            colors.put(cur, 0);
            if (!visitor.visit(cur, DfsVisitor.Reason.ENTER)) {
                return false;
            }
            Iterator it = graph.getOut(cur);
            while (it.hasNext()) {
                Object next = it.next();
                if (colors.containsKey(next)) {
                    if (colors.get(next) != 0 || visitor.visit(next, DfsVisitor.Reason.CYCLE)) continue;
                    return false;
                }
                stack.push(next);
            }
        }
        return true;
    }

    @NotNull
    public static <T> T selectDfsRoot(@NotNull Graph<T> graph) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/database/schemaEditor/generation/DdlGraph", "selectDfsRoot"));
        }
        for (Object n : graph.getNodes()) {
            if (graph.getIn(n).hasNext()) continue;
            Object e = n;
            if (e == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGraph", "selectDfsRoot"));
            }
            return (T)e;
        }
        Object object = ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem((Collection)graph.getNodes()));
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGraph", "selectDfsRoot"));
        }
        return (T)object;
    }

    public static <T> boolean hasCycles(@NotNull Graph<T> graph) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/database/schemaEditor/generation/DdlGraph", "hasCycles"));
        }
        return !DdlGraph.visitDfs(graph, DdlGraph.selectDfsRoot(graph), new DfsVisitor<T>(){

            @Override
            public boolean visit(@NotNull T node, @NotNull DfsVisitor.Reason reason) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/schemaEditor/generation/DdlGraph$1", "visit"));
                }
                if (reason == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/database/schemaEditor/generation/DdlGraph$1", "visit"));
                }
                return reason != DfsVisitor.Reason.CYCLE;
            }
        });
    }

    DdlGraph(@NotNull Collection<DdlOperationKey> nodes2, Map<DdlOperationKey, UserDataHolder> data, @NotNull BidirectionalMultiMap<DdlOperationKey, DdlOperationKey> edges, @NotNull ThreeState hasCycles) {
        if (nodes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/database/schemaEditor/generation/DdlGraph", "<init>"));
        }
        if (edges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edges", "com/intellij/database/schemaEditor/generation/DdlGraph", "<init>"));
        }
        if (hasCycles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hasCycles", "com/intellij/database/schemaEditor/generation/DdlGraph", "<init>"));
        }
        this.myNodes = nodes2;
        this.myData = data;
        this.myEdges = edges;
        this.myHasCycles = hasCycles;
    }

    @NotNull
    public ThreeState hasCycles() {
        ThreeState threeState = this.myHasCycles;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGraph", "hasCycles"));
        }
        return threeState;
    }

    public void setHasCycles(@NotNull ThreeState hasCycles) {
        if (hasCycles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hasCycles", "com/intellij/database/schemaEditor/generation/DdlGraph", "setHasCycles"));
        }
        this.myHasCycles = hasCycles;
    }

    @NotNull
    public JBIterable<DdlOperationKey> getSources() {
        JBIterable jBIterable = JBIterable.from(this.getNodes()).filter(key -> !this.getIn((DdlOperationKey)key).hasNext());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGraph", "getSources"));
        }
        return jBIterable;
    }

    @Nullable
    public <T> T getData(@NotNull DdlOperationKey op, @NotNull Key<T> key) {
        if (op == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "com/intellij/database/schemaEditor/generation/DdlGraph", "getData"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/schemaEditor/generation/DdlGraph", "getData"));
        }
        return (T)key.get(this.myData.get(op));
    }

    @Nullable
    public UserDataHolder getData(@NotNull DdlOperationKey op) {
        if (op == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "com/intellij/database/schemaEditor/generation/DdlGraph", "getData"));
        }
        return this.myData.get(op);
    }

    public Collection<DdlOperationKey> getNodes() {
        return this.myNodes;
    }

    public Iterator<DdlOperationKey> getOut(DdlOperationKey n) {
        return this.myEdges.getValues((Object)n).iterator();
    }

    public Iterator<DdlOperationKey> getIn(DdlOperationKey n) {
        return this.myEdges.getKeys((Object)n).iterator();
    }

    public static interface DfsVisitor<T> {
        public boolean visit(@NotNull T var1, @NotNull Reason var2);

        public static enum Reason {
            ENTER,
            LEAVE,
            CYCLE;

        }
    }
}

