/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.ide.DataManager;
import com.intellij.ide.navigationToolbar.AbstractNavBarModelExtension;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import icons.DatabaseIcons;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseNavBarExtension
extends AbstractNavBarModelExtension {
    private static final Key<PsiElement> NAV_BAR_WRAPPER = Key.create((String)"NAV_BAR_WRAPPER");

    @Nullable
    public String getPresentableText(Object object) {
        if (object instanceof ProjectWrapper) {
            return ((ProjectWrapper)((Object)object)).getName();
        }
        if (!DatabaseStructure.isDatabaseObject(object)) {
            return null;
        }
        if (object instanceof DbElement) {
            return DbPresentation.getPresentableName((DasObject)((DasObject)object));
        }
        return object instanceof PsiNamedElement ? ((PsiNamedElement)object).getName() : null;
    }

    @Nullable
    public PsiElement getParent(PsiElement psiElement) {
        if (!DatabaseStructure.isDatabaseObject(psiElement)) {
            return null;
        }
        if (psiElement instanceof DbDataSource) {
            return (PsiElement)((UserDataHolderEx)psiElement.getProject()).putUserDataIfAbsent(NAV_BAR_WRAPPER, (Object)new ProjectWrapper(psiElement.getProject()));
        }
        DatabaseViewOptions options = DatabaseView.getDatabaseView(psiElement.getProject()).getViewOptions();
        return DatabaseStructure.getParentImpl(psiElement, options);
    }

    @Nullable
    public PsiElement adjustElement(PsiElement psiElement) {
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)psiElement);
        if (file instanceof DatabaseElementVirtualFileImpl) {
            DbElement element = ((DatabaseElementVirtualFileImpl)file).findElement();
            if (element != null) {
                return element;
            }
        } else {
            DataGrid dataGrid = DataGridPomTarget.unwrapDataGrid(psiElement);
            if (dataGrid != null) {
                return (PsiElement)CommonDataKeys.PSI_FILE.getData(DataManager.getInstance().getDataContext((Component)dataGrid.getComponent()));
            }
        }
        return psiElement;
    }

    public boolean processChildren(Object object, Object rootElement, Processor<Object> processor) {
        if (object instanceof ProjectWrapper) {
            return ContainerUtil.process((List)DbPsiFacade.getInstance((Project)((ProjectWrapper)((Object)object)).getProject()).getDataSources(), processor);
        }
        if (!(object instanceof PsiElement) || !DatabaseStructure.isDatabaseObject(object) || DatabaseStructure.isAlwaysLeafImpl(object)) {
            return true;
        }
        DatabaseViewOptions options = DatabaseView.getDatabaseView(((PsiElement)object).getProject()).getViewOptions();
        return ContainerUtil.process(DatabaseStructure.getChildrenImpl(object, options), processor);
    }

    private static class ProjectWrapper
    extends FakePsiElement {
        private final Project myProject;

        public ProjectWrapper(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/view/DatabaseNavBarExtension$ProjectWrapper", "<init>"));
            }
            this.myProject = project;
        }

        @NotNull
        public Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseNavBarExtension$ProjectWrapper", "getProject"));
            }
            return project;
        }

        public PsiFile getContainingFile() {
            return null;
        }

        public String getName() {
            return ToolWindowId.DATABASE_VIEW;
        }

        @Nullable
        public Icon getIcon(boolean open) {
            return DatabaseIcons.DatabaseGroup;
        }

        public PsiElement getParent() {
            return null;
        }

        public boolean isValid() {
            return !this.myProject.isDisposed();
        }
    }
}

