/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.ItemRemovable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;

public class StringRowTableModel
extends AbstractTableModel
implements ItemRemovable,
EditableModel {
    private final List<String[]> myRows;
    private final String[] myColumnHeaders;
    private final boolean myMutable;

    public StringRowTableModel(@NotNull String[] columnHeaders, boolean mutable) {
        if (columnHeaders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnHeaders", "com/intellij/database/view/ui/StringRowTableModel", "<init>"));
        }
        this.myRows = new ArrayList<String[]>();
        this.myColumnHeaders = columnHeaders;
        this.myMutable = mutable;
    }

    @Override
    public int getRowCount() {
        return this.myRows.size();
    }

    @Override
    public int getColumnCount() {
        return this.myColumnHeaders.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.myRows.get(rowIndex)[columnIndex];
    }

    @Override
    public String getColumnName(int column) {
        return this.myColumnHeaders[column];
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        String value = StringUtil.notNullize((String)String.valueOf(aValue));
        if (rowIndex >= this.myRows.size()) {
            if (value.trim().length() == 0) {
                return;
            }
            this.addNewRow(null);
        } else if (value.trim().length() == 0 && this.getRowCount() != 0 && rowIndex != this.getRowCount() - 1 && this.isRowEmpty(rowIndex, columnIndex)) {
            this.myRows.remove(rowIndex);
            this.fireTableDataChanged();
            return;
        }
        this.myRows.get((int)rowIndex)[columnIndex] = value;
        this.fireTableDataChanged();
    }

    private boolean isRowEmpty(int rowIndex, int exceptColumn) {
        boolean rowEmpty = true;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            rowEmpty &= i == exceptColumn || this.myRows.get(rowIndex)[i].trim().length() == 0;
        }
        return rowEmpty;
    }

    public void addNewRow(String[] row) {
        if (this.getRowCount() > 0 && this.isRowEmpty(this.getRowCount() - 1, -1)) {
            return;
        }
        if (row == null || row.length < this.getColumnCount()) {
            int start = row == null ? 0 : row.length;
            row = row == null ? new String[this.getColumnCount()] : Arrays.copyOf(row, this.getColumnCount());
            for (int i = start; i < this.getColumnCount(); ++i) {
                row[i] = "";
            }
        }
        this.myRows.add(row);
        this.fireTableRowsInserted(this.myRows.size() - 1, this.myRows.size() - 1);
    }

    public void clear() {
        this.myRows.clear();
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.myMutable && column < this.getColumnCount() && row < this.getRowCount();
    }

    public void addRow() {
        this.addNewRow(null);
    }

    public void exchangeRows(int oldIndex, int newIndex) {
        Collections.swap(this.myRows, oldIndex, newIndex);
        this.fireTableDataChanged();
    }

    public boolean canExchangeRows(int oldIndex, int newIndex) {
        return this.myMutable;
    }

    public void removeRow(int idx) {
        if (idx >= this.myRows.size()) {
            return;
        }
        this.myRows.remove(idx);
        this.fireTableRowsDeleted(idx, idx);
    }

    @NotNull
    public List<String[]> getRows() {
        List<String[]> list = Collections.unmodifiableList(this.myRows);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/StringRowTableModel", "getRows"));
        }
        return list;
    }
}

