/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmOverloadable;
import com.intellij.dbm.common.DbmUtil;
import com.intellij.dbm.common.ReferenceHolder;
import com.intellij.dbm.common.RelativeReference;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbmRef<T extends DbmObject> {
    private static final EmptyRef EMPTY_REF = new EmptyRef();

    public static <R extends DbmObject, T extends DbmObject> DbmRef<T> ref(@NotNull ReferenceHolder<R> referenceHolder, @NotNull T target) {
        if (referenceHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceHolder", "com/intellij/dbm/common/DbmRef", "ref"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/dbm/common/DbmRef", "ref"));
        }
        return new ResolvedRef(referenceHolder, (DbmObject)referenceHolder.getOwner(), target, null);
    }

    public static <R extends DbmObject, T extends DbmObject> DbmRef<T> ref(@NotNull R refer, @NotNull T target) {
        if (refer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refer", "com/intellij/dbm/common/DbmRef", "ref"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/dbm/common/DbmRef", "ref"));
        }
        return new ResolvedRef(null, refer, target, null);
    }

    public static <R extends DbmObject, T extends DbmObject> DbmRef<T> unresolved(@NotNull R source, @NotNull String[] path, @Nullable String[] arguments) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/dbm/common/DbmRef", "unresolved"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/dbm/common/DbmRef", "unresolved"));
        }
        return DbmRef.unresolved(source, RelativeReference.of(path, arguments));
    }

    public static <R extends DbmObject, T extends DbmObject> DbmRef<T> unresolved(@NotNull R source, @NotNull RelativeReference p) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/dbm/common/DbmRef", "unresolved"));
        }
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/dbm/common/DbmRef", "unresolved"));
        }
        return new UnresolvedRef(p);
    }

    public static <R extends DbmObject, T extends DbmObject> DbmRef<T> empty() {
        return EMPTY_REF;
    }

    @Nullable
    public abstract T getResolvedObject();

    @Nullable
    public abstract RelativeReference getRelativeReference();

    public abstract boolean needsResolving();

    public abstract boolean isEmpty();

    public abstract void drop();

    public static final class EmptyRef
    extends DbmRef {
        @Nullable
        public DbmObject getResolvedObject() {
            return null;
        }

        @Override
        @Nullable
        public RelativeReference getRelativeReference() {
            return null;
        }

        @Override
        public boolean needsResolving() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void drop() {
        }
    }

    public static final class UnresolvedRef<T extends DbmObject>
    extends DbmRef<T> {
        @NotNull
        public final RelativeReference myRelativeReference;

        private UnresolvedRef(@NotNull RelativeReference relativeReference) {
            if (relativeReference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeReference", "com/intellij/dbm/common/DbmRef$UnresolvedRef", "<init>"));
            }
            this.myRelativeReference = relativeReference;
        }

        @Override
        @Nullable
        public T getResolvedObject() {
            return null;
        }

        @Override
        @NotNull
        public RelativeReference getRelativeReference() {
            RelativeReference relativeReference = this.myRelativeReference;
            if (relativeReference == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmRef$UnresolvedRef", "getRelativeReference"));
            }
            return relativeReference;
        }

        @Override
        public boolean needsResolving() {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public void drop() {
        }
    }

    public static final class ResolvedRef<R extends DbmObject, T extends DbmObject>
    extends DbmRef<T> {
        @Nullable
        public final ReferenceHolder referenceHolder;
        @NotNull
        public final R source;
        @NotNull
        public final T target;

        private ResolvedRef(@Nullable ReferenceHolder referenceHolder, @NotNull R source, @NotNull T target) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/dbm/common/DbmRef$ResolvedRef", "<init>"));
            }
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/dbm/common/DbmRef$ResolvedRef", "<init>"));
            }
            assert (((DbmObject)source).model == ((DbmObject)target).model) : "An object of a model must not reference an object of another model";
            this.referenceHolder = referenceHolder;
            this.source = source;
            this.target = target;
            ((DbmObject)source).attachForwardReference(this);
            ((DbmObject)target).attachBackwardReference(this);
        }

        @Override
        @Nullable
        public T getResolvedObject() {
            return this.target;
        }

        @Override
        @NotNull
        public RelativeReference getRelativeReference() {
            String[] path;
            RelativeReference.ExplicitOrigin explicitOrigin;
            if (((DbmObject)this.source).parent() == ((DbmObject)this.target).parent()) {
                explicitOrigin = RelativeReference.ExplicitOrigin.NONE;
                path = new String[]{((DbmObject)this.target).identity(true)};
            } else if (((DbmObject)this.source).schema() == ((DbmObject)this.target).schema()) {
                explicitOrigin = RelativeReference.ExplicitOrigin.SCHEMA;
                String[] branch = DbmUtil.branch(((DbmObject)this.target).schema(), this.target, true);
                int branchLen = branch.length;
                path = branchLen == 1 ? branch : Arrays.copyOfRange(branch, 1, branchLen);
            } else if (((DbmObject)this.source).schema().parent() == ((DbmObject)this.target).schema().parent()) {
                explicitOrigin = RelativeReference.ExplicitOrigin.DATABASE;
                path = DbmUtil.branch(((DbmObject)this.target).schema(), this.target, true);
            } else {
                explicitOrigin = RelativeReference.ExplicitOrigin.NONE;
                path = DbmUtil.fullPath(this.target, true);
            }
            String[] arguments = this.target instanceof DbmOverloadable ? ((DbmOverloadable)this.target).getSpecItems() : null;
            RelativeReference relativeReference = RelativeReference.of(explicitOrigin, path, arguments);
            if (relativeReference == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmRef$ResolvedRef", "getRelativeReference"));
            }
            return relativeReference;
        }

        @Override
        public boolean needsResolving() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public void drop() {
            ((DbmObject)this.target).detachBackwardReference(this);
            ((DbmObject)this.source).detachForwardReference(this);
            if (this.referenceHolder != null) {
                this.referenceHolder.referenceDropped(this);
            }
        }

        /* synthetic */ ResolvedRef(ReferenceHolder x0, DbmObject x1, DbmObject x2, 1 x3) {
            this(x0, x1, x2);
        }
    }
}

