/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableList;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.DbmArgument;
import com.intellij.dbm.common.DbmError;
import com.intellij.dbm.common.DbmMajor;
import com.intellij.dbm.common.DbmOverloadable;
import com.intellij.dbm.common.DbmRoutine;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.DbmSourceAware;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.StateProperty;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbmSingleRoutine
extends DbmMajor
implements DbmRoutine,
DbmSourceAware {
    final Family<DbmArgument> myArguments;
    @NotNull
    private List<DbmError> myErrors;
    @StateProperty
    public boolean myDeterministic;
    @StateProperty
    @NotNull
    public DasRoutine.Kind myRoutineKind;
    @Nullable
    private String mySourceText;
    @StateProperty
    public boolean myInvalid;

    public DbmSingleRoutine(@NotNull DbmSchema schema, @Nullable String name) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/common/DbmSingleRoutine", "<init>"));
        }
        super(schema, name);
        this.myErrors = NO_ERRORS;
        this.myRoutineKind = DasRoutine.Kind.NONE;
        this.myArguments = Family.of(this, ObjectKind.ARGUMENT);
        this.assignFamilies(this.myArguments);
    }

    @NotNull
    public Family<DbmArgument> arguments() {
        Family<DbmArgument> family = this.myArguments;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSingleRoutine", "arguments"));
        }
        return family;
    }

    @Override
    @NotNull
    public ObjectKind kind() {
        ObjectKind objectKind = ObjectKind.ROUTINE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSingleRoutine", "kind"));
        }
        return objectKind;
    }

    @Override
    @NotNull
    public DasRoutine.Kind getRoutineKind() {
        DasRoutine.Kind kind = this.myRoutineKind;
        if (kind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSingleRoutine", "getRoutineKind"));
        }
        return kind;
    }

    @Override
    public void setRoutineKind(@NotNull DasRoutine.Kind routineKind) {
        if (routineKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routineKind", "com/intellij/dbm/common/DbmSingleRoutine", "setRoutineKind"));
        }
        this.myRoutineKind = routineKind;
    }

    @Override
    @NotNull
    public String description(boolean includeSurrogates) {
        StringBuilder b = new StringBuilder(60);
        b.append(this.myRoutineKind.toString());
        if (this instanceof DbmOverloadable) {
            DbmOverloadable ov = (DbmOverloadable)((Object)this);
            String[] specItems = ov.getSpecItems();
            b.append('(');
            int m = specItems.length;
            for (int j = 0; j < m; ++j) {
                if (j > 0) {
                    b.append(',');
                }
                b.append(specItems[j]);
            }
            b.append(')');
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSingleRoutine", "description"));
        }
        return string;
    }

    @Override
    @Nullable
    public String getSourceText() {
        return this.mySourceText;
    }

    @Override
    public void setSourceText(@Nullable String sourceText) {
        this.modifying();
        this.mySourceText = sourceText;
    }

    @Override
    public boolean isInvalid() {
        return this.myInvalid;
    }

    @Override
    public void setInvalid(boolean invalid) {
        this.myInvalid = invalid;
    }

    @Override
    @Nullable
    public DbmArgument getReturnArgument() {
        for (DbmArgument argument : this.myArguments) {
            DasArgument.Direction direction = argument.getDirection();
            if (direction != DasArgument.Direction.RETURN && direction != DasArgument.Direction.RESULT) continue;
            return argument;
        }
        return null;
    }

    @Override
    @NotNull
    public DbmArgument getOrCreateReturnArgument() {
        DbmArgument r = this.getReturnArgument();
        if (r == null) {
            r = this.myArguments.create(null);
            r.setDirection(DasArgument.Direction.RETURN);
            this.myArguments.move(r, 0);
        } else {
            r.resetSyncPending();
        }
        this.setRoutineKind(DasRoutine.Kind.FUNCTION);
        DbmArgument dbmArgument = r;
        if (dbmArgument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSingleRoutine", "getOrCreateReturnArgument"));
        }
        return dbmArgument;
    }

    @Override
    public boolean isDeterministic() {
        return this.myDeterministic;
    }

    @Override
    public void setDeterministic(boolean deterministic) {
        if (this.myDeterministic == deterministic) {
            return;
        }
        this.modifying();
        this.myDeterministic = deterministic;
    }

    @Nullable
    public String getPackage() {
        return null;
    }

    @Override
    @NotNull
    public List<DbmError> getErrors() {
        List<DbmError> list = this.myErrors;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSingleRoutine", "getErrors"));
        }
        return list;
    }

    @Override
    public void setErrors(@NotNull List<DbmError> errors) {
        boolean bad;
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/dbm/common/DbmSingleRoutine", "setErrors"));
        }
        boolean bl = bad = !errors.isEmpty();
        if (this.myErrors.isEmpty() && !bad) {
            return;
        }
        this.modifying();
        this.myErrors = bad ? ImmutableList.copyOf(errors) : NO_ERRORS;
    }

    @NotNull
    public Iterable<? extends DasArgument> getArguments() {
        Family<DbmArgument> family = this.arguments();
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSingleRoutine", "getArguments"));
        }
        return family;
    }
}

