/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.DbmError;
import com.intellij.dbm.common.DbmLikeTable;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.DbmSourceAware;
import com.intellij.dbm.common.StateProperty;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbmView
extends DbmLikeTable
implements DbmSourceAware {
    @Nullable
    private String mySourceText;
    boolean myInvalid;
    @StateProperty
    public boolean myWithCheckOption;
    @StateProperty
    public Boolean myModifiable;
    @NotNull
    private List<DbmError> myErrors;

    public DbmView(@NotNull DbmSchema schema, @Nullable String name) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/common/DbmView", "<init>"));
        }
        super(schema, name);
        this.myErrors = NO_ERRORS;
    }

    @Override
    @NotNull
    public final ObjectKind kind() {
        ObjectKind objectKind = ObjectKind.VIEW;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmView", "kind"));
        }
        return objectKind;
    }

    @Override
    @Nullable
    public String getSourceText() {
        return this.mySourceText;
    }

    @Override
    public void setSourceText(@Nullable String sourceText) {
        this.modifying();
        this.mySourceText = sourceText;
    }

    @Override
    public boolean isInvalid() {
        return this.myInvalid;
    }

    @Override
    public void setInvalid(boolean invalid) {
        if (this.myInvalid == invalid) {
            return;
        }
        this.modifying();
        this.myInvalid = invalid;
    }

    public boolean isModifiable() {
        return this.myModifiable;
    }

    public void setModifiable(Boolean modifiable) {
        if (this.myModifiable == modifiable) {
            return;
        }
        this.modifying();
        this.myModifiable = modifiable;
    }

    public boolean isWithCheckOption() {
        return this.myWithCheckOption;
    }

    public void setWithCheckOption(boolean withCheckOption) {
        if (this.myWithCheckOption == withCheckOption) {
            return;
        }
        this.modifying();
        this.myWithCheckOption = withCheckOption;
    }

    @Override
    protected void collectState(@NotNull ImmutableMap.Builder<String, Object> stateBuilder, boolean surrogates) {
        if (stateBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateBuilder", "com/intellij/dbm/common/DbmView", "collectState"));
        }
        super.collectState(stateBuilder, surrogates);
        this.putState(stateBuilder, "source_text", this.mySourceText);
        if (this.myModifiable != null) {
            this.putState(stateBuilder, "modifiable", this.myModifiable);
        }
        this.putState(stateBuilder, "with_check_option", this.myWithCheckOption);
    }

    @Override
    @NotNull
    public List<DbmError> getErrors() {
        List<DbmError> list = this.myErrors;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmView", "getErrors"));
        }
        return list;
    }

    @Override
    public void setErrors(@NotNull List<DbmError> errors) {
        boolean bad;
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/dbm/common/DbmView", "setErrors"));
        }
        boolean bl = bad = !errors.isEmpty();
        if (this.myErrors.isEmpty() && !bad) {
            return;
        }
        this.modifying();
        this.myErrors = bad ? ImmutableList.copyOf(errors) : NO_ERRORS;
    }
}

