/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableList;
import com.intellij.database.model.MultiRef;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.dbm.common.DbmNamedObject;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmObjectListener;
import com.intellij.dbm.common.PropertyHolder;
import com.intellij.dbm.common.Resolver;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.util.Strings;

public abstract class DomObjectsRef<T extends DbmNamedObject>
implements PropertyHolder,
MultiRef<T> {
    private final CopyOnWriteArrayList<Ref<T>> myRefs;
    @NotNull
    protected final DbmObject myOwner;
    @NotNull
    protected final Resolver<? extends T> myResolver;

    DomObjectsRef(@NotNull DbmObject owner, @NotNull Resolver<? extends T> resolver) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/dbm/common/DomObjectsRef", "<init>"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/intellij/dbm/common/DomObjectsRef", "<init>"));
        }
        this.myRefs = new CopyOnWriteArrayList();
        this.myOwner = owner;
        this.myResolver = resolver;
    }

    private void addObject(@NotNull T object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/dbm/common/DomObjectsRef", "addObject"));
        }
        Ref<T> newRef = new Ref<T>(object);
        this.myRefs.add(newRef);
    }

    protected void addName(@NotNull String deduplicatedName) {
        if (deduplicatedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deduplicatedName", "com/intellij/dbm/common/DomObjectsRef", "addName"));
        }
        Ref newRef = new Ref(deduplicatedName);
        this.myRefs.add(newRef);
    }

    public void add(@NotNull T object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/dbm/common/DomObjectsRef", "add"));
        }
        this.myOwner.modifying();
        this.addObject(object);
    }

    public void add(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/common/DomObjectsRef", "add"));
        }
        this.myOwner.modifying();
        T resolvedObject = this.myResolver.resolve(name);
        if (resolvedObject != null) {
            this.addObject(resolvedObject);
        } else {
            String deduplicatedName = DbUtil.intern((String)name);
            this.addName(deduplicatedName);
        }
    }

    public void setObjects(T ... objects) {
        this.clearState();
        for (T object : objects) {
            this.addObject(object);
        }
    }

    public void setObjects(@NotNull Collection<T> objects) {
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/dbm/common/DomObjectsRef", "setObjects"));
        }
        this.clearState();
        for (DbmNamedObject object : objects) {
            this.addObject(object);
        }
    }

    public void setNames(String ... names) {
        this.clearState();
        for (String name : names) {
            this.add(StringUtil.notNullize((String)name, (String)"?"));
        }
    }

    public void setNames(@NotNull Collection<String> names) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/dbm/common/DomObjectsRef", "setNames"));
        }
        this.clearState();
        for (String name : names) {
            this.add(name);
        }
    }

    public void resolveAll() {
        for (Ref<T> ref : this.myRefs) {
            T resolvedObject;
            String name;
            if (ref.isResolved() || (name = ref.getName()) == null || (resolvedObject = this.myResolver.resolve(name)) == null) continue;
            ref.resolved(resolvedObject);
        }
    }

    public void remove(@NotNull T object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/dbm/common/DomObjectsRef", "remove"));
        }
        if (this.myRefs.isEmpty()) {
            return;
        }
        this.myOwner.modifying();
        for (int i = this.myRefs.size() - 1; i >= 0; --i) {
            Ref<T> ref = this.myRefs.get(i);
            if (ref.getObject() != object) continue;
            this.myRefs.remove(i);
        }
    }

    public void remove(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/common/DomObjectsRef", "remove"));
        }
        if (this.myRefs.isEmpty()) {
            return;
        }
        this.myOwner.modifying();
        for (int i = this.myRefs.size() - 1; i >= 0; --i) {
            Ref<T> ref = this.myRefs.get(i);
            if (ref.getName() != name) continue;
            this.myRefs.remove(i);
        }
    }

    @Override
    public void clearState() {
        if (this.myRefs.isEmpty()) {
            return;
        }
        this.myOwner.modifying();
        Ref[] refs = this.myRefs.toArray(new Ref[0]);
        this.myRefs.clear();
        for (Ref ref : refs) {
            ref.drop();
        }
    }

    protected void retrieveNamesAsIs(@NotNull Collection<String> names) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/dbm/common/DomObjectsRef", "retrieveNamesAsIs"));
        }
        for (Ref<T> ref : this.myRefs) {
            String name = ref.getName();
            if (name == null) continue;
            names.add(name);
        }
    }

    protected void retrieveResolvedObjectsAsIs(@NotNull Collection<T> objects) {
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/dbm/common/DomObjectsRef", "retrieveResolvedObjectsAsIs"));
        }
        for (Ref<T> ref : this.myRefs) {
            T object = ref.getObject();
            if (object == null) continue;
            objects.add(object);
        }
    }

    public abstract Collection<String> names();

    public abstract List<String> namesOrdered();

    public abstract List<T> resolveObjects();

    public boolean contains(String name) {
        for (Ref<T> ref : this.myRefs) {
            if (!Strings.eq((String)ref.getName(), (String)name)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public String getName(int index) {
        List<String> namesOrdered = this.namesOrdered();
        return index < namesOrdered.size() ? namesOrdered.get(index) : null;
    }

    @Nullable
    public String firstName() {
        Iterator<Ref<T>> it = this.myRefs.iterator();
        if (it.hasNext()) {
            return it.next().getName();
        }
        return null;
    }

    public boolean isNotEmpty() {
        return !this.myRefs.isEmpty();
    }

    public boolean isEmpty() {
        return this.myRefs.isEmpty();
    }

    public int size() {
        return this.myRefs.size();
    }

    public MultiRef.It<T> iterate() {
        Iterable names = this.names();
        if (names == null || names.isEmpty()) {
            return DasUtil.emptyMultiRefIterator();
        }
        final Iterator it = names.iterator();
        return new MultiRef.It<T>(){
            String cur;

            @Nullable
            public T resolve() {
                return DomObjectsRef.this.myResolver.resolve(this.cur);
            }

            public boolean hasNext() {
                return it.hasNext();
            }

            public String next() {
                this.cur = (String)it.next();
                return this.cur;
            }

            public void remove() {
                it.remove();
            }
        };
    }

    public String toString() {
        List<String> names = this.namesOrdered();
        int n = names.size();
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return names.get(0);
            }
        }
        StringBuilder b = new StringBuilder();
        b.append(names.get(0));
        for (int i = 1; i < n; ++i) {
            b.append(',').append(names.get(i));
        }
        return b.toString();
    }

    @Override
    public String exportState() {
        return StringUtil.join(this.namesOrdered(), (String)"\n");
    }

    @Override
    public void importState(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/dbm/common/DomObjectsRef", "importState"));
        }
        this.setNames(StringUtil.splitByLines((String)text));
    }

    int countResolvedRefs() {
        int counter = 0;
        for (Ref<T> ref : this.myRefs) {
            if (!ref.isResolved()) continue;
            ++counter;
        }
        return counter;
    }

    int countUnresolvedRefs() {
        int counter = 0;
        for (Ref<T> ref : this.myRefs) {
            if (ref.isResolved()) continue;
            ++counter;
        }
        return counter;
    }

    static interface Modifier<T extends DbmNamedObject> {
        @Nullable
        public ImmutableList<Ref<T>> modify(@NotNull ImmutableList<Ref<T>> var1);
    }

    static final class Ref<T extends DbmNamedObject>
    implements DbmObjectListener {
        @Nullable
        private volatile T myObject;
        @Nullable
        private volatile String myName;

        Ref(@NotNull T object) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/dbm/common/DomObjectsRef$Ref", "<init>"));
            }
            this.myObject = object;
            ((DbmObject)this.myObject).registerListener(this);
        }

        Ref(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/common/DomObjectsRef$Ref", "<init>"));
            }
            this.myName = name;
        }

        private void attachObject(@NotNull T object) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/dbm/common/DomObjectsRef$Ref", "attachObject"));
            }
            if (this.myObject == object) {
                return;
            }
            if (this.myObject != null) {
                this.detachObject();
            }
            this.myObject = object;
            ((DbmObject)object).registerListener(this);
            this.myName = null;
        }

        private void detachObject() {
            T object = this.myObject;
            if (object != null) {
                this.myName = object.getNameOrNull();
                ((DbmObject)object).deregisterListener(this);
                this.myObject = null;
            }
        }

        void resolved(@NotNull T object) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/dbm/common/DomObjectsRef$Ref", "resolved"));
            }
            this.attachObject(object);
        }

        @Override
        public void objectIsDropped(DbmObject object) {
            if (this.myObject == object) {
                this.detachObject();
            } else {
                object.deregisterListener(this);
            }
        }

        public void drop() {
            if (this.myObject != null) {
                this.detachObject();
            }
        }

        @Nullable
        public T getObject() {
            return this.myObject;
        }

        @Nullable
        public String getName() {
            T object = this.myObject;
            return object != null ? object.getNameOrNull() : this.myName;
        }

        boolean isResolved() {
            return this.myObject != null;
        }

        public String toString() {
            T object = this.myObject;
            return object != null ? "+ " + object.getNameOrNull() : "- " + this.myName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Ref that = (Ref)o;
            return this.myObject == that.myObject && Strings.eq((String)this.myName, (String)that.myName);
        }

        public int hashCode() {
            String name = this.getName();
            return name != null ? name.hashCode() : 0;
        }
    }
}

