/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.generic;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.JdbcUtil;
import com.intellij.dbm.common.CascadeRule;
import com.intellij.dbm.common.DbmColumn;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.common.SequenceIdentity;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseLegacyModelUtils {
    public static final SequenceIdentity SEQUENCE_IDENTITY = SequenceIdentity.of(1L, null, 1L, null);

    @Nullable
    public static String fixProcedureName(boolean groupIdAllowed, @Nullable String name) {
        int idx;
        if (groupIdAllowed && name != null && (idx = name.indexOf(59)) > -1 && StringUtil.parseInt((String)name.substring(idx + 1), (int)-1) >= 0) {
            name = name.substring(0, idx);
        }
        return name;
    }

    @Nullable
    public static String fixDefaultValue(@NotNull DatabaseFamilyId familyId, @NotNull DbmColumn column, @Nullable String defaultValue) {
        int jdbc;
        if (familyId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "familyId", "com/intellij/dbm/generic/DatabaseLegacyModelUtils", "fixDefaultValue"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/dbm/generic/DatabaseLegacyModelUtils", "fixDefaultValue"));
        }
        if (defaultValue == null) {
            return null;
        }
        int reportedJdbc = column.getDataType().jdbcType;
        int n = jdbc = reportedJdbc == 1111 || reportedJdbc == 0 ? JdbcUtil.guessJdbcTypeByName((String)column.getDataType().typeName) : reportedJdbc;
        if (jdbc == 1 || jdbc == 2005 || jdbc == 12 || jdbc == -15 || jdbc == 2011 || jdbc == -9 || jdbc == 91 || jdbc == 92 || jdbc == 93) {
            if (familyId.isOracle()) {
                return defaultValue;
            }
            if (familyId.isPostgres()) {
                int dotIndex = defaultValue.indexOf("::");
                if (dotIndex == -1) {
                    return defaultValue;
                }
                if (defaultValue.startsWith("('") && dotIndex > 4) {
                    return defaultValue;
                }
                if (defaultValue.startsWith("''") && defaultValue.endsWith("'")) {
                    return defaultValue.substring(1, dotIndex);
                }
                return defaultValue.substring(0, dotIndex);
            }
            if ((jdbc == 91 || jdbc == 92 || jdbc == 93) && defaultValue.length() > 0 && Character.isLetter(defaultValue.charAt(0))) {
                return defaultValue;
            }
            if (!StringUtil.startsWithChar((CharSequence)defaultValue, (char)'\'')) {
                return '\'' + defaultValue + '\'';
            }
        } else if (jdbc == -7) {
            if (defaultValue.contains("\u0000")) {
                return "0";
            }
            if (defaultValue.contains("\u0001")) {
                return "1";
            }
        }
        return defaultValue;
    }

    public static CascadeRule asCascadeRule(DasForeignKey.RuleAction ac, boolean update) {
        if (ac == DasForeignKey.RuleAction.CASCADE) {
            return update ? CascadeRule.update : CascadeRule.delete;
        }
        if (ac == DasForeignKey.RuleAction.NO_ACTION) {
            return CascadeRule.no_action;
        }
        if (ac == DasForeignKey.RuleAction.RESTRICT) {
            return CascadeRule.restrict;
        }
        if (ac == DasForeignKey.RuleAction.SET_DEFAULT) {
            return CascadeRule.set_default;
        }
        if (ac == DasForeignKey.RuleAction.SET_NULL) {
            return CascadeRule.set_null;
        }
        return CascadeRule.restrict;
    }

    public static boolean isSchemaDbMode(DbmModel<?> model, DatabaseFamilyId family) {
        return model.getRootNamespaces().getChildKind() != ObjectKind.DATABASE && family.isMysql();
    }
}

