/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.generic;

import com.intellij.dbm.common.DbmElement;
import com.intellij.dbm.common.DbmOverloadable;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.DbmSingleRoutine;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.RoutineUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbmGenericSingleRoutine
extends DbmSingleRoutine
implements DbmOverloadable {
    private String[] mySpecItems;

    public DbmGenericSingleRoutine(@NotNull DbmSchema schema, @Nullable String name) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/DbmGenericSingleRoutine", "<init>"));
        }
        super(schema, name);
    }

    @Override
    public String[] getSpecItems() {
        if (this.mySpecItems == null) {
            this.mySpecItems = RoutineUtil.makeSpecItemsByInArguments(this.arguments());
        }
        return this.mySpecItems;
    }

    @Override
    protected void modifying() {
        super.modifying();
        this.dropCache();
    }

    @Override
    protected void modifyingFamily(@NotNull Family<?> family) {
        if (family == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "family", "com/intellij/dbm/generic/DbmGenericSingleRoutine", "modifyingFamily"));
        }
        super.modifyingFamily(family);
        this.dropCache();
    }

    @Override
    protected void modifyingChild(@NotNull DbmElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/dbm/generic/DbmGenericSingleRoutine", "modifyingChild"));
        }
        super.modifyingChild(element);
        this.dropCache();
    }

    private void dropCache() {
        this.mySpecItems = null;
    }

    @Override
    public void setSpecItems(String[] specItems) {
        RoutineUtil.assignSpecItems(this.arguments(), specItems);
    }

    @Override
    public boolean isApplicableTo(String[] specItems) {
        return RoutineUtil.checkSpecItemsAreEqual(this.arguments(), specItems);
    }
}

