/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.generic.meta;

import com.intellij.database.model.DasRoutine;
import com.intellij.dbm.generic.meta.ClosableIt;
import com.intellij.dbm.generic.meta.DatabaseMetaDataWrapper;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class SybaseRoutineIt
extends ClosableIt.DelegateMutableIt<DatabaseMetaDataWrapper.Table, DatabaseMetaDataWrapper.Routine> {
    private final DatabaseMetaDataWrapper.Schema mySchema;

    SybaseRoutineIt(@NotNull DatabaseMetaDataWrapper.Schema schema, Iterator<? extends DatabaseMetaDataWrapper.Table> it) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/meta/SybaseRoutineIt", "<init>"));
        }
        super(it);
        this.mySchema = schema;
    }

    @Override
    @NotNull
    protected DatabaseMetaDataWrapper.Routine createStorage() {
        DatabaseMetaDataWrapper.Routine routine = new DatabaseMetaDataWrapper.Routine(this.mySchema, null, "");
        if (routine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/SybaseRoutineIt", "createStorage"));
        }
        return routine;
    }

    public static boolean isSybTableName(String name, String type) {
        return !"SYSTEM TABLE".equals(type) || name.startsWith("sys");
    }

    @Override
    protected DatabaseMetaDataWrapper.Routine calcValue(DatabaseMetaDataWrapper.Table cur) {
        if (cur == null) {
            return (DatabaseMetaDataWrapper.Routine)this.skip();
        }
        DatabaseMetaDataWrapper.Routine res = (DatabaseMetaDataWrapper.Routine)this.getStorageToFill();
        res.name = cur.name;
        res.specificName = cur.name;
        res.kind = DasRoutine.Kind.FUNCTION;
        res.comment = cur.comment;
        return res;
    }
}

