/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.mssql;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.DataTypeFactory;
import com.intellij.database.model.LengthUnit;
import com.intellij.dbm.common.BaseIntrospector;
import com.intellij.dbm.common.DBIntrospectionError;
import com.intellij.dbm.common.DbmArgument;
import com.intellij.dbm.common.DbmCheck;
import com.intellij.dbm.common.DbmColumn;
import com.intellij.dbm.common.DbmDatabase;
import com.intellij.dbm.common.DbmForeignKey;
import com.intellij.dbm.common.DbmIndex;
import com.intellij.dbm.common.DbmKey;
import com.intellij.dbm.common.DbmLikeTable;
import com.intellij.dbm.common.DbmMajor;
import com.intellij.dbm.common.DbmMultiDatabaseModel;
import com.intellij.dbm.common.DbmPositionedIndex;
import com.intellij.dbm.common.DbmRoutine;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.DbmSourceAware;
import com.intellij.dbm.common.DbmSynonym;
import com.intellij.dbm.common.DbmTable;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.LongIdName;
import com.intellij.dbm.common.MinorIdentity;
import com.intellij.dbm.common.MultiDatabaseIntrospector;
import com.intellij.dbm.common.QueryRewriters;
import com.intellij.dbm.common.SequenceIdentity;
import com.intellij.dbm.mssql.MsAliasType;
import com.intellij.dbm.mssql.MsDatabase;
import com.intellij.dbm.mssql.MsIntroQueries;
import com.intellij.dbm.mssql.MsIntrospectorUtils;
import com.intellij.dbm.mssql.MsModel;
import com.intellij.dbm.mssql.MsRegularRoutine;
import com.intellij.dbm.mssql.MsRoutineType;
import com.intellij.dbm.mssql.MsSchema;
import com.intellij.dbm.mssql.MsTableType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.Predicate;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.core.Layouts;
import org.jetbrains.dekaf.util.Objects;
import org.jetbrains.dekaf.util.StringOperator;

public class MsIntrospector
extends MultiDatabaseIntrospector<MsDatabase, MsSchema, MsModel> {
    private final MsIntroQueries myQueries;
    private static final Byte ALIAS_TYPE_KIND = 1;
    private static final Byte TABLE_TYPE_KIND = 2;
    private static final Byte ASSEMBLY_TYPE_KIND = 3;
    private final boolean myVer10;
    private static final Pattern SURROGATE_NAME_PATTERN = Pattern.compile("^\\s*\\w{2}\\S{2,18}__[\\dA-F]{8,16}\\s*$", 2);
    private static final Set<String> VARIABLE_TYPES = ImmutableSet.of((Object)"decimal", (Object)"numeric", (Object)"varbinary", (Object)"varchar", (Object)"binary", (Object)"char", (Object[])new String[]{"nvarchar", "nchar"});

    public MsIntrospector(@NotNull DBFacade facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/dbm/mssql/MsIntrospector", "<init>"));
        }
        super(facade);
        this.myQueries = MsIntroQueries.QUERIES;
        this.myVer10 = this.myFacade.getConnectionInfo().serverVersion.isOrGreater(new int[]{10});
    }

    @Override
    @NotNull
    protected MsModel createNewModel() {
        MsModel msModel = new MsModel();
        if (msModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mssql/MsIntrospector", "createNewModel"));
        }
        return msModel;
    }

    @NotNull
    protected MsDatabaseRetriever createDatabaseRetriever(@NotNull DBTransaction tran, @NotNull MsDatabase database) {
        if (tran == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mssql/MsIntrospector", "createDatabaseRetriever"));
        }
        if (database == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "database", "com/intellij/dbm/mssql/MsIntrospector", "createDatabaseRetriever"));
        }
        MsDatabaseRetriever msDatabaseRetriever = new MsDatabaseRetriever(tran, (MsModel)this.getModel(), database);
        if (msDatabaseRetriever == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mssql/MsIntrospector", "createDatabaseRetriever"));
        }
        return msDatabaseRetriever;
    }

    @NotNull
    protected MsSchemaRetriever createSchemaRetriever(@NotNull DBTransaction tran, @NotNull MsSchema schema) {
        if (tran == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mssql/MsIntrospector", "createSchemaRetriever"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/mssql/MsIntrospector", "createSchemaRetriever"));
        }
        MsSchemaRetriever msSchemaRetriever = new MsSchemaRetriever(tran, schema);
        if (msSchemaRetriever == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mssql/MsIntrospector", "createSchemaRetriever"));
        }
        return msSchemaRetriever;
    }

    @Override
    protected void retrieveSessionBriefInfo(DBTransaction tran) {
        super.retrieveSessionBriefInfo(tran);
        MsIntroQueries.CurrentSessionInfo sessionInfo = (MsIntroQueries.CurrentSessionInfo)tran.query(this.myQueries.queryCurrentSessionInfo).run();
        if (sessionInfo == null) {
            throw new MsIntrospectionException("Failed to obtain session info");
        }
        MsDatabase currentDatabase = (MsDatabase)((MsModel)this.myModel).getRootNamespaces().renew(sessionInfo.db_id, sessionInfo.db_name);
        currentDatabase.setCollation(sessionInfo.collation_name);
        ((MsModel)this.myModel).setCurrentDatabase(currentDatabase);
        if (sessionInfo.schema_name != null) {
            DbmSchema currentSchema = currentDatabase.schemas().renew(sessionInfo.schema_id, sessionInfo.schema_name);
            currentDatabase.setCurrentSchema(currentSchema);
        }
    }

    @Override
    @NotNull
    protected List<LongIdName> listDatabases(@NotNull DBTransaction tran) {
        if (tran == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mssql/MsIntrospector", "listDatabases"));
        }
        List list = (List)tran.query(this.myQueries.listDatabases).run();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mssql/MsIntrospector", "listDatabases"));
        }
        return list;
    }

    @NotNull
    private static String catalogPrefix(DbmDatabase database) {
        String string = database.isCurrent() ? "sys" : '[' + database.getName() + "].sys";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mssql/MsIntrospector", "catalogPrefix"));
        }
        return string;
    }

    private static boolean detectSurrogateName(@Nullable String name) {
        if (name == null) {
            return false;
        }
        return SURROGATE_NAME_PATTERN.matcher(name).matches();
    }

    @Nullable
    private static DataType makeDataType(String type_name, int max_length, int precision, byte scale) {
        DataType dt;
        if (type_name != null) {
            if (VARIABLE_TYPES.contains(type_name)) {
                if (precision > 0) {
                    dt = DataTypeFactory.of(null, type_name, precision, scale, null, null, false, false);
                } else if (type_name.equals("char") || type_name.equals("nchar") || type_name.equals("varchar") || type_name.equals("nvarchar")) {
                    int length;
                    boolean variable;
                    boolean national = type_name.charAt(0) == 'n';
                    boolean bl = variable = type_name.length() >= 7;
                    int n = max_length == -1 ? Integer.MAX_VALUE : (length = national ? max_length >> 1 : max_length);
                    if (length == 1 && !variable) {
                        length = -1;
                    }
                    dt = DataTypeFactory.of(null, type_name, length, 0, LengthUnit.CHAR, null, false, false);
                } else {
                    dt = max_length > 0 ? DataTypeFactory.of(null, type_name, max_length, scale, null, null, false, false) : DataTypeFactory.of(type_name);
                }
            } else {
                dt = DataTypeFactory.of(type_name);
            }
        } else {
            dt = null;
        }
        return dt;
    }

    public static class MsIntrospectionException
    extends DBIntrospectionError {
        public MsIntrospectionException(String message) {
            super(message);
        }
    }

    static final class ForeignKeyInfo {
        @NotNull
        final DbmForeignKey fkey;
        int domTableId;
        int refTableId;
        final SmartList<String> domColumnNames;
        final SmartList<String> refColumnNames;

        public ForeignKeyInfo(@NotNull DbmForeignKey fkey) {
            if (fkey == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fkey", "com/intellij/dbm/mssql/MsIntrospector$ForeignKeyInfo", "<init>"));
            }
            this.domColumnNames = new SmartList();
            this.refColumnNames = new SmartList();
            this.fkey = fkey;
        }

        public int hashCode() {
            return this.fkey.hashCode();
        }
    }

    private final class MsSchemaRetriever
    extends BaseIntrospector.SchemaRetriever {
        private final int schemaId;
        private final Collection<DbmLikeTable> myTouchedTables;
        private final Collection<DbmRoutine> myTouchedRoutines;
        private final StringOperator rewriter;

        MsSchemaRetriever(@NotNull DBTransaction transaction, MsSchema schema) {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/mssql/MsIntrospector$MsSchemaRetriever", "<init>"));
            }
            super((BaseIntrospector)MsIntrospector.this, transaction, (DbmSchema)schema);
            this.myTouchedTables = new ArrayList<DbmLikeTable>();
            this.myTouchedRoutines = new ArrayList<DbmRoutine>();
            this.schemaId = (int)schema.myObjectId;
            String catalogPrefix = MsIntrospector.catalogPrefix(schema.database());
            ImmutableMap substitutionMap = ImmutableMap.of((Object)"#CAT", (Object)catalogPrefix, (Object)"#IS_TABLE_TYPE", (Object)(MsIntrospector.this.myVer10 ? "is_table_type" : "0"));
            this.rewriter = QueryRewriters.substitute((Map<String, String>)substitutionMap);
        }

        @Override
        protected void analyzeBriefInfo(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mssql/MsIntrospector$MsSchemaRetriever", "analyzeBriefInfo"));
            }
            this.introspectionBeginTimestamp = (Timestamp)tran.query("select current_timestamp", Layouts.singleOf(Timestamp.class)).run();
        }

        @Override
        protected void analyzeCurrentContent(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mssql/MsIntrospector$MsSchemaRetriever", "analyzeCurrentContent"));
            }
            this.progress("determining dropped objects");
            int[] existentObjectsArray = (int[])tran.query(((MsIntrospector)MsIntrospector.this).myQueries.listExistentObjects.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            TIntHashSet existentObjectIds = new TIntHashSet(existentObjectsArray);
            MsIntrospector.dropUnexistentObjects(((MsSchema)this.schema).synonyms(), existentObjectIds);
            MsIntrospector.dropUnexistentObjects(((MsSchema)this.schema).routines(), existentObjectIds);
            MsIntrospector.dropUnexistentObjects(((MsSchema)this.schema).views(), existentObjectIds);
            MsIntrospector.dropUnexistentObjects(((MsSchema)this.schema).tables(), existentObjectIds);
            for (DbmTable dbmTable : ((MsSchema)this.schema).tables()) {
                MsIntrospector.dropUnexistentObjects(dbmTable.keys(), existentObjectIds);
                MsIntrospector.dropUnexistentObjects(dbmTable.foreignKeys(), existentObjectIds);
                MsIntrospector.dropUnexistentObjects(dbmTable.checks(), existentObjectIds);
            }
        }

        @Override
        protected void retrieveMajorNames(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mssql/MsIntrospector$MsSchemaRetriever", "retrieveMajorNames"));
            }
        }

        @Override
        protected void retrieveMainContent(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mssql/MsIntrospector$MsSchemaRetriever", "retrieveMainContent"));
            }
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mssql/MsIntrospector$MsSchemaRetriever", "lambda$retrieveMainContent$0"));
                }
                this.retrieveCustomTypes(tran);
            });
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mssql/MsIntrospector$MsSchemaRetriever", "lambda$retrieveMainContent$1"));
                }
                this.retrieveMajorObjects(tran);
            });
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mssql/MsIntrospector$MsSchemaRetriever", "lambda$retrieveMainContent$2"));
                }
                this.retrieveColumns(tran);
            });
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mssql/MsIntrospector$MsSchemaRetriever", "lambda$retrieveMainContent$3"));
                }
                this.retrieveIndices(tran);
                this.retrieveKeys(tran);
            });
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mssql/MsIntrospector$MsSchemaRetriever", "lambda$retrieveMainContent$4"));
                }
                this.retrieveForeignKeys(tran);
                this.retrieveCheckConstraints(tran);
            });
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mssql/MsIntrospector$MsSchemaRetriever", "lambda$retrieveMainContent$5"));
                }
                this.retrieveParameters(tran);
            });
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mssql/MsIntrospector$MsSchemaRetriever", "lambda$retrieveMainContent$6"));
                }
                this.retrieveSynonyms(tran);
            });
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mssql/MsIntrospector$MsSchemaRetriever", "lambda$retrieveMainContent$7"));
                }
                this.retrieveDescription(tran);
            });
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mssql/MsIntrospector$MsSchemaRetriever", "lambda$retrieveMainContent$8"));
                }
                this.retrieveSources(tran);
            });
            this.finishSchema();
        }

        private void retrieveCustomTypes(DBTransaction tran) {
            if (((MsSchema)this.schema).isName("sys") && this.incremental) {
                return;
            }
            this.progress("retrieving user defined types");
            Map checkSums = (Map)tran.query(((MsIntrospector)MsIntrospector.this).myQueries.calculateCustomTypesCheckSums.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            this.processAliasTypes(tran, (Long)Objects.notNull(checkSums.get(ALIAS_TYPE_KIND), (Object)0L));
            if (MsIntrospector.this.myVer10) {
                this.processTableTypes(tran, (Long)Objects.notNull(checkSums.get(TABLE_TYPE_KIND), (Object)0L));
            }
        }

        private void processAliasTypes(DBTransaction tran, long aliasTypesCheckSum) {
            if (aliasTypesCheckSum == 0L) {
                ((MsSchema)this.schema).aliasTypes().clear();
                ((MsSchema)this.schema).setAliasTypesCheckSum(0L);
                return;
            }
            if (((MsSchema)this.schema).getAliasTypesCheckSum() == aliasTypesCheckSum) {
                return;
            }
            ((MsSchema)this.schema).aliasTypes().markChildrenAsSyncPending();
            List cas = (List)tran.query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveAliasTypes.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            for (MsIntroQueries.OneAliasType at : cas) {
                MsAliasType aliasType = (MsAliasType)MsIntrospectorUtils.renewType(((MsSchema)this.schema).database(), ((MsSchema)this.schema).aliasTypes(), at.type_id, at.name);
                aliasType.setNotNull(!at.is_nullable);
                if (at.base_name != null) {
                    DataType dt = MsIntrospector.makeDataType(at.base_name, at.max_length, at.precision, at.scale);
                    aliasType.setDataType(dt);
                    continue;
                }
                aliasType.setDataType(null);
            }
            ((MsSchema)this.schema).aliasTypes().removeSyncPendingChildren();
            ((MsSchema)this.schema).aliasTypes().reorder();
        }

        private void processTableTypes(DBTransaction tran, long tableTypesCheckSum) {
            if (tableTypesCheckSum == 0L) {
                ((MsSchema)this.schema).tableTypes().clear();
                ((MsSchema)this.schema).setTableTypesCheckSum(0L);
                return;
            }
            if (((MsSchema)this.schema).getTableTypesCheckSum() == tableTypesCheckSum) {
                return;
            }
            ((MsSchema)this.schema).tableTypes().markChildrenAsSyncPending();
            List tts = (List)tran.query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveTableTypes.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            for (MsIntroQueries.OneTableType tt : tts) {
                MsTableType tableType = (MsTableType)MsIntrospectorUtils.renewType(((MsSchema)this.schema).database(), ((MsSchema)this.schema).tableTypes(), tt.type_id, tt.name);
                tableType.setObjectId(tt.object_id);
                tableType.setCreatedAndModifiedTimestamps(tt.create_date, tt.modify_date);
            }
            ((MsSchema)this.schema).tableTypes().removeSyncPendingChildren();
            ((MsSchema)this.schema).tableTypes().reorder();
            this.retrieveTypeColumns(tran);
            this.retrieveTypeIndices(tran);
            this.retrieveTypeKeys(tran);
            this.retrieveTypeCheckConstraints(tran);
        }

        private void retrieveMajorObjects(DBTransaction tran) {
            this.progress("retrieving tables, views, procedures and functions");
            List os = (List)tran.query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveObjects.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId, this.fromTimestamp}).run();
            if (os.isEmpty()) {
                return;
            }
            boolean tablesWereTouched = false;
            boolean viewsWereTouched = false;
            boolean tableTypesWereTouched = false;
            for (MsIntroQueries.OneObject o : os) {
                DbmMajor object;
                if (o.type == null) continue;
                if (o.type.equals("U") || o.type.equals("S") || o.type.equals("IT")) {
                    object = ((MsSchema)this.schema).tables().renew(o.object_id, o.name);
                    tablesWereTouched = true;
                } else if (o.type.equals("V")) {
                    object = ((MsSchema)this.schema).views().renew(o.object_id, o.name);
                    viewsWereTouched = true;
                } else if (o.type.equals("TT")) {
                    object = ((MsSchema)this.schema).tableTypes().renew(o.object_id, o.name);
                    tableTypesWereTouched = true;
                } else {
                    if (!MsRoutineType.TYPES.keySet().contains(o.type)) continue;
                    MsRegularRoutine routine = ((MsSchema)this.schema).routines().renew(o.object_id, o.name);
                    MsRoutineType routineType = MsRoutineType.TYPES.get(o.type);
                    routine.setRoutineKind(MsRoutineType.PROCEDURE_TYPES.keySet().contains(o.type) ? DasRoutine.Kind.PROCEDURE : DasRoutine.Kind.FUNCTION);
                    routine.setType(routineType);
                    object = routine;
                    routine.arguments().markChildrenAsSyncPending();
                    this.myTouchedRoutines.add(routine);
                }
                boolean nameIsSurrogate = MsIntrospector.detectSurrogateName(o.name);
                object.setNameSurrogate(nameIsSurrogate);
                object.setCreatedAndModifiedTimestamps(o.create_date, o.modify_date);
                if (!(object instanceof DbmLikeTable)) continue;
                DbmLikeTable t = object;
                this.myTouchedTables.add(t);
                t.columns().markChildrenAsSyncPending();
            }
            if (tablesWereTouched) {
                ((MsSchema)this.schema).tables().reorder();
            }
            if (viewsWereTouched) {
                ((MsSchema)this.schema).views().reorder();
            }
            if (tableTypesWereTouched) {
                ((MsSchema)this.schema).tableTypes().reorder();
            }
            if (!this.myTouchedRoutines.isEmpty()) {
                ((MsSchema)this.schema).routines().reorder();
            }
        }

        private void retrieveColumns(DBTransaction tran) {
            if (this.myTouchedTables.isEmpty()) {
                return;
            }
            this.progress("retrieving columns of tables and views");
            List cols = (List)tran.query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveColumns.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId, this.fromTimestamp}).run();
            this.processColumns(cols);
        }

        private void retrieveTypeColumns(DBTransaction tran) {
            this.progress("retrieving columns of custom table types");
            List cols = (List)tran.query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveTypeColumns.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            this.processColumns(cols);
        }

        private void processColumns(List<MsIntroQueries.OneColumn> cols) {
            HashSet<DbmLikeTable> affectedTables = new HashSet<DbmLikeTable>(cols.size() / 3);
            DbmLikeTable table = null;
            int object_id = 0;
            for (MsIntroQueries.OneColumn col : cols) {
                if (object_id != col.object_id || table == null) {
                    object_id = col.object_id;
                    table = ((MsSchema)this.schema).getObjectById(DbmLikeTable.class, object_id);
                    if (table == null) continue;
                    if (col.column_position == 1) {
                        table.columns().markChildrenAsSyncPending();
                    }
                    affectedTables.add(table);
                }
                DbmColumn column = table.columns().getOrCreate(col.name);
                column.setPosition(col.column_position);
                column.setMandatory(!col.is_nullable);
                column.setComputed(col.is_computed);
                DataType dt = MsIntrospector.makeDataType(col.type_name, col.max_length, col.precision, col.scale);
                column.setDataType(dt);
                column.setDefaultExpression(MsIntrospectorUtils.normalizeExpression(col.default_expression));
                if (col.identity_seed_value == null && col.identity_increment_value == null && col.identity_last_value == null) continue;
                Long next = col.identity_last_value != null ? Long.valueOf(col.identity_last_value + 1L) : null;
                column.setSequenceIdentity(SequenceIdentity.of(col.identity_seed_value, next, col.identity_increment_value, null));
            }
            for (DbmLikeTable t : affectedTables) {
                t.columns().removeSyncPendingChildren();
                t.columns().reorder();
            }
        }

        private void retrieveIndices(DBTransaction tran) {
            this.progress("retrieving indices");
            List inds = (List)tran.query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveIndices.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId, this.fromTimestamp}).run();
            List ics = (List)tran.query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveIndexColumns.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId, this.fromTimestamp}).run();
            this.processIndices(inds, ics);
        }

        private void retrieveTypeIndices(DBTransaction tran) {
            this.progress("retrieving indices of custom table types");
            List inds = (List)tran.query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveTypeIndices.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            List ics = (List)tran.query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveTypeIndexColumns.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            this.processIndices(inds, ics);
        }

        private void processIndices(List<MsIntroQueries.OneIndex> inds, List<MsIntroQueries.OneIndexColumn> ics) {
            HashMap<MinorIdentity, DbmPositionedIndex> indices = new HashMap<MinorIdentity, DbmPositionedIndex>(inds.size());
            for (MsIntroQueries.OneIndex ind : inds) {
                DbmLikeTable t = ((MsSchema)this.schema).getObjectById(DbmLikeTable.class, ind.object_id);
                if (t == null) continue;
                DbmPositionedIndex index = (DbmPositionedIndex)t.indices().getOrCreate(ind.name);
                index.setNameSurrogate(MsIntrospector.detectSurrogateName(ind.name));
                index.setPosition(ind.position);
                index.setUnique(ind.is_unique);
                index.setClustering(ind.type == 1);
                index.myColumns.clearState();
                indices.put(MinorIdentity.of(ind.object_id, ind.position), index);
            }
            for (MsIntroQueries.OneIndexColumn c : ics) {
                DbmPositionedIndex index = (DbmPositionedIndex)indices.get(MinorIdentity.of(c.object_id, c.index_position));
                if (index == null) continue;
                index.addColumn(c.name, c.is_desc ? DasIndex.Sorting.DESCENDING : DasIndex.Sorting.ASCENDING);
            }
        }

        private void retrieveKeys(DBTransaction tran) {
            this.progress("retrieving candidate keys");
            List ks = (List)tran.query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveKeys.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId, this.fromTimestamp}).run();
            this.processKeys(ks);
        }

        private void retrieveTypeKeys(DBTransaction tran) {
            this.progress("retrieving keys of custom table types");
            List ks = (List)tran.query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveTypeKeys.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            this.processKeys(ks);
        }

        private void processKeys(List<MsIntroQueries.OneKey> ks) {
            HashSet<DbmLikeTable> tables = new HashSet<DbmLikeTable>(ks.size());
            for (final MsIntroQueries.OneKey k : ks) {
                DbmLikeTable t = ((MsSchema)this.schema).getObjectById(DbmLikeTable.class, k.table_id);
                if (t == null) continue;
                DbmKey key = t.keys().renew(k.key_id, k.name);
                key.setNameSurrogate(k.is_system_named);
                key.setPrimary(k.is_primary);
                key.setCreatedAndModifiedTimestamps(k.create_date, k.modify_date);
                DbmIndex index = t.indices().get((Predicate<? extends DbmIndex>)new Predicate<DbmIndex>(){

                    public boolean apply(@Nullable DbmIndex ind) {
                        return ind instanceof DbmPositionedIndex && ((DbmPositionedIndex)ind).myPosition == k.index_position;
                    }
                });
                if (index != null) {
                    key.myUnderlyingIndex.set(index);
                    key.myColumns.setNames(index.myColumns.namesOrdered());
                    index.setNameSurrogate(k.is_system_named);
                } else {
                    key.myUnderlyingIndex.clearState();
                    key.myColumns.clearState();
                }
                tables.add(t);
            }
            for (DbmLikeTable table : tables) {
                table.keys().reorder();
            }
        }

        private void retrieveForeignKeys(DBTransaction tran) {
            if (this.myTouchedTables.isEmpty()) {
                return;
            }
            this.progress("retrieving foreign keys");
            List fks = (List)tran.query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveForeignKeys.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId, this.fromTimestamp}).run();
            if (fks.isEmpty()) {
                return;
            }
            HashSet<DbmLikeTable> affectedTables = new HashSet<DbmLikeTable>(fks.size());
            TIntObjectHashMap infos = new TIntObjectHashMap(fks.size());
            for (MsIntroQueries.OneForeignKey fk : fks) {
                DbmLikeTable table = ((MsSchema)this.schema).getObjectById(DbmLikeTable.class, fk.table_id);
                if (table == null) continue;
                DbmForeignKey fkey = table.foreignKeys().renew(fk.constraint_id, fk.name);
                fkey.setNameSurrogate(fk.is_system_named);
                fkey.setCreatedAndModifiedTimestamps(fk.create_date, fk.modify_date);
                ForeignKeyInfo fki = new ForeignKeyInfo(fkey);
                fki.domTableId = fk.table_id;
                fki.refTableId = fk.referenced_object_id;
                infos.put(fk.constraint_id, (Object)fki);
                affectedTables.add(table);
            }
            List fcs = (List)tran.query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveForeignKeyColumns.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId, this.fromTimestamp}).run();
            for (MsIntroQueries.OneForeignKeyColumn fc : fcs) {
                ForeignKeyInfo fki = (ForeignKeyInfo)infos.get(fc.constraint_id);
                if (fki == null) continue;
                fki.domColumnNames.add((Object)fc.domestic_column_name);
                fki.refColumnNames.add((Object)fc.reference_column_name);
            }
            for (Object o : infos.getValues()) {
                ForeignKeyInfo fki = (ForeignKeyInfo)o;
                fki.fkey.myColumns.setNames(ArrayUtil.toStringArray(fki.domColumnNames));
                DbmLikeTable refTable = ((MsSchema)this.schema).database().getObjectById(DbmLikeTable.class, fki.refTableId);
                if (refTable == null) continue;
                DbmKey refKey = refTable.getKeyByColumns((List<String>)fki.refColumnNames);
                fki.fkey.refKey.set(refKey);
            }
            for (DbmLikeTable table : affectedTables) {
                table.foreignKeys().reorder();
            }
        }

        private void retrieveCheckConstraints(DBTransaction tran) {
            if (this.myTouchedTables.isEmpty()) {
                return;
            }
            this.progress("retrieving check constraints");
            List cs = (List)tran.query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveCheckConstraints.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId, this.fromTimestamp}).run();
            this.processCheckConstraints(cs);
        }

        private void retrieveTypeCheckConstraints(DBTransaction tran) {
            this.progress("retrieving check constraints of custom table types");
            List cs = (List)tran.query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveTypeCheckConstraints.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            this.processCheckConstraints(cs);
        }

        private void processCheckConstraints(List<MsIntroQueries.OneCheckConstraints> cs) {
            HashSet<DbmLikeTable> affectedTables = new HashSet<DbmLikeTable>(cs.size());
            for (MsIntroQueries.OneCheckConstraints c : cs) {
                DbmLikeTable table = ((MsSchema)this.schema).getObjectById(DbmLikeTable.class, c.table_id);
                if (table == null) continue;
                DbmCheck check = table.checks().renew(c.constraint_id, c.name);
                check.setNameSurrogate(c.is_system_named);
                check.setCreatedAndModifiedTimestamps(c.create_date, c.modify_date);
                if (c.column_name != null) {
                    check.myColumns.setNames(c.column_name);
                } else {
                    check.myColumns.clearState();
                }
                check.setPredicate(MsIntrospectorUtils.normalizePredicateExpression(c.definition));
                affectedTables.add(table);
            }
            for (DbmLikeTable table : affectedTables) {
                table.checks().reorder();
            }
        }

        private void retrieveSynonyms(DBTransaction tran) {
            this.progress("retrieving synonyms");
            List ss = (List)tran.query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveSynonyms.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId, this.fromTimestamp}).run();
            if (ss.isEmpty()) {
                return;
            }
            Family<? extends DbmSynonym> synonyms = ((MsSchema)this.schema).synonyms();
            for (MsIntroQueries.OneSynonym s : ss) {
                DbmDatabase origDB;
                DbmSynonym synonym = synonyms.renew(s.object_id, s.name);
                synonym.setCreatedAndModifiedTimestamps(s.create_date, s.modify_date);
                boolean resolvedHere = false;
                DbmDatabase dbmDatabase = origDB = s.origin_db_name == null ? ((MsSchema)this.schema).database : (DbmDatabase)((MsModel)MsIntrospector.this.myModel).databases().get(s.origin_db_name);
                if (origDB != null) {
                    DbmLikeTable origin;
                    DbmSchema origSchema;
                    DbmSchema dbmSchema = origSchema = s.origin_schema_name == null ? this.schema : origDB.schemas().get(s.origin_schema_name);
                    if (origSchema != null && s.origin_object_name != null && (origin = origSchema.getTableOrView(s.origin_object_name)) != null) {
                        synonym.origin.set(origin);
                        resolvedHere = true;
                    }
                }
                if (resolvedHere) continue;
            }
        }

        private void retrieveParameters(DBTransaction tran) {
            if (this.myTouchedRoutines.isEmpty()) {
                return;
            }
            this.progress("retrieving procedures' and functions' parameters");
            boolean wasDefaults = false;
            List as = (List)tran.query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveArguments.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId, this.fromTimestamp}).run();
            for (MsIntroQueries.OneArguments a : as) {
                DasArgument.Direction d;
                MsRegularRoutine routine = ((MsSchema)this.schema).getObjectById(MsRegularRoutine.class, a.object_id);
                if (routine == null) continue;
                DbmArgument argument = routine.arguments().getOrCreate(a.name);
                DasArgument.Direction direction = a.is_cursor_ref ? DasArgument.Direction.RESULT : (d = a.is_output ? DasArgument.Direction.OUT : DasArgument.Direction.IN);
                if (d == DasArgument.Direction.OUT && (a.name == null || a.name.isEmpty())) {
                    d = DasArgument.Direction.RETURN;
                }
                argument.setDirection(d);
                DataType dt = MsIntrospector.makeDataType(a.type_name, a.max_length, a.precision, a.scale);
                if (dt == null) {
                    dt = DataType.UNKNOWN;
                }
                argument.setDataType(dt);
                argument.resetSyncPending();
                wasDefaults |= a.has_default_value;
            }
            if (wasDefaults) {
                // empty if block
            }
        }

        private void retrieveDescription(DBTransaction tran) {
            if (this.myTouchedTables.isEmpty()) {
                return;
            }
            this.progress("retrieving tables' descriptions");
            List ds = (List)tran.query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveDescriptions.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId, this.fromTimestamp}).run();
            DbmLikeTable table = null;
            int object_id = 0;
            for (final MsIntroQueries.OneDescription d : ds) {
                if ((object_id != d.object_id || table == null) && (table = ((MsSchema)this.schema).getObjectById(DbmLikeTable.class, object_id = d.object_id)) == null) continue;
                if (d.item_position == 0) {
                    table.setComment(d.description);
                    continue;
                }
                DbmColumn column = table.columns().get((Predicate<? extends DbmColumn>)new Predicate<DbmColumn>(){

                    public boolean apply(DbmColumn column) {
                        return column.getPosition() == d.item_position;
                    }
                });
                if (column == null) continue;
                column.setComment(d.description);
            }
        }

        private void retrieveSources(DBTransaction tran) {
            if (!this.myWithSources) {
                return;
            }
            this.progress("retrieving source texts");
            Map srcs = (Map)tran.query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveSources.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId, this.fromTimestamp}).run();
            if (srcs.isEmpty()) {
                return;
            }
            for (Map.Entry entry : srcs.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                int objectId = (Integer)entry.getKey();
                String srcText = (String)entry.getValue();
                this.assignSourceCode(objectId, srcText);
            }
        }

        private void assignSourceCode(int id, @NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/dbm/mssql/MsIntrospector$MsSchemaRetriever", "assignSourceCode"));
            }
            DbmSourceAware sa = ((MsSchema)this.schema).getObjectById(DbmSourceAware.class, id);
            if (sa != null) {
                sa.setSourceText(text);
            }
        }

        private void finishSchema() {
            ((MsSchema)this.schema).setIntrospectionActualPoint(0L, this.introspectionBeginTimestamp);
        }

        private void progress(@NotNull String what) {
            if (what == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "com/intellij/dbm/mssql/MsIntrospector$MsSchemaRetriever", "progress"));
            }
            String mode = this.incremental ? "incrementally" : "completely";
            MsIntrospector.this.updateStatus(String.format("Introspecting schema %s (%s)", ((MsSchema)this.schema).getName(), mode), what);
        }
    }

    private final class MsDatabaseRetriever
    extends MultiDatabaseIntrospector.DatabaseRetriever {
        MsDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull MsModel model, MsDatabase database) {
            if (transaction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transaction", "com/intellij/dbm/mssql/MsIntrospector$MsDatabaseRetriever", "<init>"));
            }
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dbm/mssql/MsIntrospector$MsDatabaseRetriever", "<init>"));
            }
            if (database == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "database", "com/intellij/dbm/mssql/MsIntrospector$MsDatabaseRetriever", "<init>"));
            }
            super((MultiDatabaseIntrospector)MsIntrospector.this, transaction, (DbmMultiDatabaseModel)model, (DbmDatabase)database);
        }

        @Override
        protected void prepareParameters() {
            this.setQueryParameter("CAT", MsIntrospector.catalogPrefix(this.database));
            this.setQueryParameter("IS_TABLE_TYPE", MsIntrospector.this.myVer10 ? "is_table_type" : "0");
        }

        @Override
        protected List<LongIdName> listSchemas() {
            return this.performQuery(((MsIntrospector)MsIntrospector.this).myQueries.listSchemas);
        }
    }
}

