/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.mssql;

import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.DbmDatabase;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.StateProperty;
import com.intellij.dbm.mssql.MsAliasType;
import com.intellij.dbm.mssql.MsDatabase;
import com.intellij.dbm.mssql.MsRegularRoutine;
import com.intellij.dbm.mssql.MsTableType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MsSchema
extends DbmSchema {
    @NotNull
    final Family<MsAliasType> myAliasTypes;
    @NotNull
    final Family<MsTableType> myTableTypes;
    @StateProperty
    public long myAliasTypesCheckSum;
    @StateProperty
    public long myTableTypesCheckSum;

    public MsSchema(@NotNull DbmDatabase database, @Nullable String name) {
        if (database == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "database", "com/intellij/dbm/mssql/MsSchema", "<init>"));
        }
        super(database, name);
        this.myAliasTypes = Family.of(this, ObjectKind.ALIAS_TYPE);
        this.myTableTypes = Family.of(this, ObjectKind.TABLE_TYPE);
        this.assignFamilies(this.myAliasTypes, this.myTableTypes, this.myTables, this.myViews, this.myRoutines, this.mySynonyms);
    }

    @NotNull
    public MsDatabase database() {
        MsDatabase msDatabase = (MsDatabase)this.database;
        if (msDatabase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mssql/MsSchema", "database"));
        }
        return msDatabase;
    }

    @NotNull
    public Family<MsAliasType> aliasTypes() {
        Family<MsAliasType> family = this.myAliasTypes;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mssql/MsSchema", "aliasTypes"));
        }
        return family;
    }

    @NotNull
    public Family<MsTableType> tableTypes() {
        Family<MsTableType> family = this.myTableTypes;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mssql/MsSchema", "tableTypes"));
        }
        return family;
    }

    public long getAliasTypesCheckSum() {
        return this.myAliasTypesCheckSum;
    }

    public void setAliasTypesCheckSum(long aliasTypesCheckSum) {
        if (this.myAliasTypesCheckSum == aliasTypesCheckSum) {
            return;
        }
        this.modifying();
        this.myAliasTypesCheckSum = aliasTypesCheckSum;
    }

    public long getTableTypesCheckSum() {
        return this.myTableTypesCheckSum;
    }

    public void setTableTypesCheckSum(long tableTypesCheckSum) {
        if (this.myAliasTypesCheckSum == tableTypesCheckSum) {
            return;
        }
        this.modifying();
        this.myTableTypesCheckSum = tableTypesCheckSum;
    }

    @NotNull
    public Family<MsRegularRoutine> routines() {
        Family family = this.myRoutines;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mssql/MsSchema", "routines"));
        }
        return family;
    }

    @Override
    protected void justObjectIdChanged(DbmObject object, long oldId, long newId) {
        this.database().justObjectIdChanged(object, oldId, newId);
    }

    @Nullable
    public <T> T getObjectById(@NotNull Class<T> objectClass, long id) {
        if (objectClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectClass", "com/intellij/dbm/mssql/MsSchema", "getObjectById"));
        }
        DbmObject object = this.database().getObjectById(id);
        if (object == null) {
            return null;
        }
        if (object.schema() != this) {
            return null;
        }
        return (T)(objectClass.isAssignableFrom(object.getClass()) ? object : null);
    }
}

