/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.oracle;

import com.intellij.dbm.common.DbmIndex;
import com.intellij.dbm.common.DbmKey;
import com.intellij.dbm.oracle.OraSchema;
import com.intellij.dbm.oracle.OraTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraKey
extends DbmKey {
    public OraKey(@NotNull OraTable table, @Nullable String name) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/oracle/OraKey", "<init>"));
        }
        super(table, name);
    }

    @Override
    protected void nameIsChanged(@Nullable String oldName, @Nullable String newName) {
        super.nameIsChanged(oldName, newName);
        OraSchema schema = (OraSchema)this.table.schema();
        if (oldName != null) {
            schema.unregisterConstraint(oldName);
        }
        if (newName != null) {
            schema.registerConstraint(this);
        }
    }

    @Override
    public boolean isIndexCustomized() {
        DbmIndex index = this.getUnderlyingIndex();
        return index != null && (!index.isName(this.getName()) || this.myColumns.size() < index.myColumns.size());
    }
}

