/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.oracle;

import com.google.common.collect.ImmutableList;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Casing;
import com.intellij.dbm.common.DbmConstraint;
import com.intellij.dbm.common.DbmKey;
import com.intellij.dbm.common.DbmMajor;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmRoutine;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.DbmUserDefinedType;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.oracle.OraCollectionType;
import com.intellij.dbm.oracle.OraForeignKey;
import com.intellij.dbm.oracle.OraMatView;
import com.intellij.dbm.oracle.OraModel;
import com.intellij.dbm.oracle.OraModule;
import com.intellij.dbm.oracle.OraObjectType;
import com.intellij.dbm.oracle.OraPackage;
import com.intellij.dbm.oracle.OraSequence;
import com.intellij.dbm.oracle.OraTable;
import com.intellij.dbm.oracle.OraView;
import java.util.Collection;
import java.util.concurrent.ConcurrentSkipListMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OraSchema
extends DbmSchema {
    final Family<OraObjectType> myObjectTypes;
    final Family<OraCollectionType> myCollectionTypes;
    final Family<OraPackage> myPackages;
    private final ConcurrentSkipListMap<String, DbmConstraint> myConstraints;

    @NotNull
    public Family<OraSequence> sequences() {
        Family family = this.mySequences;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraSchema", "sequences"));
        }
        return family;
    }

    @NotNull
    public Family<OraTable> tables() {
        Family family = this.myTables;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraSchema", "tables"));
        }
        return family;
    }

    @NotNull
    public Family<OraView> views() {
        Family family = this.myViews;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraSchema", "views"));
        }
        return family;
    }

    @NotNull
    public Family<OraMatView> matViews() {
        Family family = this.myMatViews;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraSchema", "matViews"));
        }
        return family;
    }

    @NotNull
    public Family<OraObjectType> objectTypes() {
        Family<OraObjectType> family = this.myObjectTypes;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraSchema", "objectTypes"));
        }
        return family;
    }

    @NotNull
    public Family<OraCollectionType> collectionTypes() {
        Family<OraCollectionType> family = this.myCollectionTypes;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraSchema", "collectionTypes"));
        }
        return family;
    }

    @NotNull
    public Family<OraPackage> packages() {
        Family<OraPackage> family = this.myPackages;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraSchema", "packages"));
        }
        return family;
    }

    OraSchema(@NotNull DbmModel model, @Nullable String name) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dbm/oracle/OraSchema", "<init>"));
        }
        super(model, name);
        this.myObjectTypes = Family.of(this, ObjectKind.OBJECT_TYPE);
        this.myCollectionTypes = Family.of(this, ObjectKind.COLLECTION_TYPE);
        this.myPackages = Family.of(this, ObjectKind.PACKAGE);
        this.myConstraints = new ConcurrentSkipListMap(String.CASE_INSENSITIVE_ORDER);
        this.assignFamilies(this.mySequences, this.myTables, this.myViews, this.myMatViews, this.myRoutines, this.myObjectTypes, this.myCollectionTypes, this.myPackages, this.mySynonyms);
    }

    @NotNull
    public OraModel model() {
        OraModel oraModel = (OraModel)this.model;
        if (oraModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraSchema", "model"));
        }
        return oraModel;
    }

    public boolean isPublic() {
        return this.isName("PUBLIC");
    }

    @Override
    protected void justObjectIdChanged(DbmObject object, long oldId, long newId) {
        this.model().justObjectIdChanged(object, oldId, newId);
    }

    @Override
    @Nullable
    protected Family<? extends DbmMajor> getSpecificFamily(@NotNull ObjectKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/dbm/oracle/OraSchema", "getSpecificFamily"));
        }
        if (kind == ObjectKind.OBJECT_TYPE) {
            return this.myObjectTypes;
        }
        if (kind == ObjectKind.COLLECTION_TYPE) {
            return this.myCollectionTypes;
        }
        if (kind == ObjectKind.PACKAGE) {
            return this.myPackages;
        }
        return null;
    }

    public void registerConstraint(@NotNull DbmConstraint constraint) {
        if (constraint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraint", "com/intellij/dbm/oracle/OraSchema", "registerConstraint"));
        }
        this.myConstraints.put(constraint.getName(), constraint);
    }

    public void unregisterConstraint(@NotNull String constraintName) {
        if (constraintName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintName", "com/intellij/dbm/oracle/OraSchema", "unregisterConstraint"));
        }
        this.myConstraints.remove(constraintName);
    }

    @Override
    @Nullable
    public DbmKey findKeyByName(@NotNull String keyName) {
        if (keyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyName", "com/intellij/dbm/oracle/OraSchema", "findKeyByName"));
        }
        DbmConstraint constraint = this.myConstraints.get(keyName);
        return constraint instanceof DbmKey ? (DbmKey)constraint : null;
    }

    @NotNull
    Collection<OraForeignKey> getForeignKeys() {
        ImmutableList.Builder b = ImmutableList.builder();
        for (DbmConstraint constraint : this.myConstraints.values()) {
            if (!(constraint instanceof OraForeignKey)) continue;
            b.add((Object)((OraForeignKey)constraint));
        }
        ImmutableList immutableList = b.build();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraSchema", "getForeignKeys"));
        }
        return immutableList;
    }

    @Override
    @Nullable
    public DbmUserDefinedType resolveOwnCustomType(@NotNull String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/dbm/oracle/OraSchema", "resolveOwnCustomType"));
        }
        DbmUserDefinedType type = this.myObjectTypes.get(typeName);
        if (type == null) {
            type = this.myCollectionTypes.get(typeName);
        }
        return type;
    }

    @Override
    @Nullable
    public DbmUserDefinedType resolveCustomType(@NotNull DataType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/dbm/oracle/OraSchema", "resolveCustomType"));
        }
        String schemaName = type.schemaName;
        if (schemaName == null || schemaName.equals(this.getName())) {
            return this.resolveOwnCustomType(type.typeName);
        }
        DbmSchema schema = this.database.schemas().get(schemaName);
        if (schema == null) {
            return null;
        }
        return schema.resolveOwnCustomType(type.typeName);
    }

    @Nullable
    public OraModule getModule(@NotNull String moduleName) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/dbm/oracle/OraSchema", "getModule"));
        }
        OraModule m = this.objectTypes().get(moduleName);
        if (m == null) {
            m = this.packages().get(moduleName);
        }
        return m;
    }

    @Nullable
    public DbmRoutine resolveRoutine(@Nullable String moduleName, @NotNull String routineName) {
        if (routineName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routineName", "com/intellij/dbm/oracle/OraSchema", "resolveRoutine"));
        }
        if (moduleName == null) {
            return this.routines().get(routineName);
        }
        OraModule m = this.getModule(moduleName);
        if (m != null) {
            return m.routines().get(routineName);
        }
        return null;
    }

    @Override
    @NotNull
    public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/dbm/oracle/OraSchema", "getCasing"));
        }
        Casing casing = OraModel.ORACLE_CASING;
        if (casing == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraSchema", "getCasing"));
        }
        return casing;
    }
}

