/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.serialization;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.database.model.DataType;
import com.intellij.database.model.DataTypeFactory;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.DbmDatabase;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.common.DbmMultiDatabaseModel;
import com.intellij.dbm.common.DbmNamespace;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.DbmSingleDatabaseModel;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.PropertyHolder;
import com.intellij.dbm.common.SequenceIdentity;
import com.intellij.dbm.factories.RdbmsRegistry;
import com.intellij.dbm.serialization.DbmMetaModel;
import com.intellij.dbm.serialization.DbmModelMem;
import com.intellij.dbm.serialization.DbmObjectMem;
import com.intellij.dbm.serialization.DbmSerializationUtil;
import com.intellij.dbm.serialization.DbmVersions;
import com.intellij.dbm.serialization.ImportException;
import com.intellij.dbm.serialization.ModelUpdating;
import com.intellij.dbm.serialization.NameAndValue;
import com.intellij.dbm.serialization.ParseValueException;
import com.intellij.dbm.serialization.TimestampParsingException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.ErrorWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.util.Version;

public final class DbmImporter {
    private static final Logger LOG = Logger.getInstance(DbmImporter.class);
    @NotNull
    private static final ImmutableMap<Type, Method> ourObjectParseMethods;

    @NotNull
    DbmModelMem deserializeModel(@NotNull HierarchicalStreamReader reader) throws ImportException {
        Version formatVersion;
        Rdbms rdbms;
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/dbm/serialization/DbmImporter", "deserializeModel"));
        }
        String rootNodeName = reader.getNodeName();
        if (!rootNodeName.equalsIgnoreCase("database-model")) {
            throw new ImportException("The root node of the database model must be database-model, but found " + rootNodeName);
        }
        try {
            String rdbmsCode = reader.getAttribute("rdbms");
            if (rdbmsCode == null) {
                throw new ImportException("RDBMS is not specified int the model file");
            }
            if (rdbmsCode.equalsIgnoreCase("POSTGRE")) {
                rdbmsCode = "POSTGRES";
            }
            rdbms = RdbmsRegistry.instance().getDefinitionByCode((String)rdbmsCode).rdbms;
        }
        catch (IllegalArgumentException iae) {
            throw new ImportException("Error reading RDBMS: " + iae.getMessage(), iae);
        }
        try {
            String formatVersionString = reader.getAttribute("format-version");
            formatVersion = formatVersionString == null ? Version.ZERO : ("current".equals(formatVersionString) ? DbmVersions.CURRENT_VERSION : Version.of((String)formatVersionString));
        }
        catch (Exception e) {
            throw new ImportException("Error reading format version: " + e.getMessage(), e);
        }
        ImmutableBiMap.Builder props = ImmutableBiMap.builder();
        int n = reader.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String attrValue;
            String attrName = reader.getAttributeName(i);
            if (attrName.equalsIgnoreCase("rdbms") || attrName.equalsIgnoreCase("format-version") || (attrValue = reader.getAttribute(i)) == null || attrValue.isEmpty()) continue;
            props.put((Object)attrName, (Object)attrValue);
        }
        ImmutableList.Builder mems = ImmutableList.builder();
        if (formatVersion.compareTo(DbmVersions.MIN_VERSION) < 0 || formatVersion.compareTo(DbmVersions.MAX_VERSION) >= 0) {
            String message = "Unsupported format version " + formatVersion + " (" + DbmVersions.CURRENT_VERSION + " expected)";
            reader.appendErrors((ErrorWriter)new ConversionException(message));
        } else {
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                DbmObjectMem mem = DbmImporter.deserializeObject(reader);
                mems.add((Object)mem);
                reader.moveUp();
            }
        }
        DbmModelMem dbmModelMem = new DbmModelMem(rdbms, (List<DbmObjectMem>)mems.build(), (Map<String, String>)props.build(), formatVersion);
        if (dbmModelMem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/serialization/DbmImporter", "deserializeModel"));
        }
        return dbmModelMem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DbmObjectMem deserializeObject(@NotNull HierarchicalStreamReader reader) throws ImportException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/dbm/serialization/DbmImporter", "deserializeObject"));
        }
        String kind = reader.getNodeName();
        Integer id = DbmImporter.parseId(reader);
        Integer parentId = DbmImporter.parseParentId(reader);
        String name = reader.getAttribute("name");
        ImmutableList.Builder properties = ImmutableList.builder();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            try {
                String key = reader.getNodeName();
                key = DbmSerializationUtil.normalize(key);
                String value = reader.getValue();
                value = DbmSerializationUtil.normalize(value);
                if (key == null || value == null || key.equalsIgnoreCase("name")) continue;
                properties.add(NameAndValue.of(key, value));
            }
            finally {
                reader.moveUp();
            }
        }
        return new DbmObjectMem(id, kind, (List<NameAndValue<String>>)properties.build(), parentId, name);
    }

    private static Integer parseId(@NotNull HierarchicalStreamReader reader) throws ImportException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/dbm/serialization/DbmImporter", "parseId"));
        }
        String str = reader.getAttribute("id");
        if (StringUtil.isEmpty((String)str)) {
            throw new ImportException("The node " + reader.getNodeName() + " has no id");
        }
        try {
            return new Integer(str.trim());
        }
        catch (NumberFormatException nfe) {
            throw new ImportException("Failed to parse id", nfe);
        }
    }

    private static Integer parseParentId(@NotNull HierarchicalStreamReader reader) throws ImportException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/dbm/serialization/DbmImporter", "parseParentId"));
        }
        String str = reader.getAttribute("parent");
        if (StringUtil.isEmpty((String)str)) {
            return null;
        }
        try {
            return new Integer(str.trim());
        }
        catch (NumberFormatException nfe) {
            throw new ImportException("Failed to parse parent id", nfe);
        }
    }

    @NotNull
    public DbmModel buildModel(@NotNull DbmModelMem modelMem) throws ImportException {
        if (modelMem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelMem", "com/intellij/dbm/serialization/DbmImporter", "buildModel"));
        }
        DbmModel<? extends DbmNamespace> model = DbmImporter.createModel(modelMem.rdbms);
        DbmModel dbmModel = this.buildModel(modelMem, model);
        if (dbmModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/serialization/DbmImporter", "buildModel"));
        }
        return dbmModel;
    }

    @NotNull
    public DbmModel buildModel(@NotNull DbmModelMem modelMem, @NotNull DbmModel<? extends DbmNamespace> model) throws ImportException {
        if (modelMem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelMem", "com/intellij/dbm/serialization/DbmImporter", "buildModel"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dbm/serialization/DbmImporter", "buildModel"));
        }
        model.startModifications();
        try {
            DbmImporter.buildModelInTransaction(modelMem, model);
        }
        finally {
            model.finishModifications();
        }
        if (!modelMem.version.isOrGreater(new int[]{2, 6})) {
            ModelUpdating.upgradeTo26(model);
        }
        DbmModel<? extends DbmNamespace> dbmModel = model;
        if (dbmModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/serialization/DbmImporter", "buildModel"));
        }
        return dbmModel;
    }

    private static void buildModelInTransaction(@NotNull DbmModelMem modelMem, DbmModel<? extends DbmNamespace> model) {
        DbmSingleDatabaseModel m2;
        if (modelMem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelMem", "com/intellij/dbm/serialization/DbmImporter", "buildModelInTransaction"));
        }
        HashMap objects = new HashMap(modelMem.nodes.size());
        for (DbmObjectMem mem : modelMem.nodes) {
            Object object;
            ObjectKind kind = model.metaModel.findKind(mem.kind);
            if (kind == null) {
                throw new AssertionError((Object)(mem.kind + " not found among " + model.metaModel));
            }
            if (mem.parentId == null) {
                if (kind != ObjectKind.DATABASE && kind != ObjectKind.SCHEMA) {
                    throw new ImportException("Only a database can be a root of the tree. However, found root " + mem.kind);
                }
                boolean theFirstRoot = model.getRootNamespaces().isEmpty();
                DbmNamespace rootNamespace = model.getRootNamespaces().create(mem.name);
                if (theFirstRoot) {
                    model.setCurrentRootNamespace(rootNamespace);
                }
                object = rootNamespace;
            } else {
                DbmObject parent = (DbmObject)objects.get(mem.parentId);
                if (parent == null) {
                    throw new ImportException("Object " + mem.id + " references parent " + mem.parentId + " that is not found or not processed yet");
                }
                Family<?> family = parent.getFamilyByChildKind(kind);
                object = family.create(mem.name);
            }
            objects.put(mem.id, object);
        }
        for (DbmObjectMem mem : modelMem.nodes) {
            DbmObject object = (DbmObject)objects.get(mem.id);
            assert (object != null);
            DbmImporter.assignProperties(object, mem.properties);
        }
        if (model instanceof DbmMultiDatabaseModel) {
            DbmMultiDatabaseModel m1 = (DbmMultiDatabaseModel)model;
            if (m1.databases().isNotEmpty()) {
                m1.setCurrentDatabase((DbmDatabase)m1.databases().first());
                for (DbmDatabase database : m1.databases()) {
                    if (!database.schemas().isNotEmpty()) continue;
                    database.setCurrentSchema(database.schemas().first());
                }
            }
        } else if (model instanceof DbmSingleDatabaseModel && (m2 = (DbmSingleDatabaseModel)model).schemas().isNotEmpty()) {
            m2.setCurrentSchema((DbmSchema)m2.schemas().first());
        }
    }

    @NotNull
    private static DbmModel<? extends DbmNamespace> createModel(@NotNull Rdbms rdbms) throws ImportException {
        DbmModel model;
        if (rdbms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rdbms", "com/intellij/dbm/serialization/DbmImporter", "createModel"));
        }
        Class<? extends DbmModel> modelClass = RdbmsRegistry.instance().getDefinitionByRdbms((Rdbms)rdbms).modelClass;
        try {
            model = modelClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new ImportException("Could not instantiate " + modelClass.getSimpleName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ImportException("Could not instantiate " + modelClass.getSimpleName(), e);
        }
        assert (model.getRdbms().equals((Object)rdbms));
        DbmModel dbmModel = model;
        if (dbmModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/serialization/DbmImporter", "createModel"));
        }
        return dbmModel;
    }

    private static void assignProperties(DbmObject object, List<NameAndValue<String>> properties) throws ImportException {
        DbmMetaModel.ObjectMetaInfo mi = DbmMetaModel.obtainMetaInfo(object.getClass());
        for (NameAndValue<String> p : properties) {
            DbmMetaModel.PropertyMetaInfo pi = mi.getPropertiesByName().get(p.name);
            if (pi == null) {
                throw new ImportException("Unknown how to import property \"" + p.name + "\" into an object of class \"" + object.getClass().getSimpleName() + "\"");
            }
            DbmImporter.assignProperty(object, p, pi);
        }
    }

    private static void assignProperty(DbmObject object, NameAndValue<String> p, DbmMetaModel.PropertyMetaInfo pi) throws ImportException {
        try {
            if (pi.isHolder) {
                Object holderObject = pi.propertyField.get(object);
                assert (holderObject != null) : "Property holder must not be null";
                PropertyHolder holder = (PropertyHolder)holderObject;
                holder.importState((String)p.value);
            } else {
                Object value = DbmImporter.parseValue(object, p, pi.valueType);
                if (value != null) {
                    if (pi.setter != null) {
                        pi.setter.invoke((Object)object, value);
                    } else {
                        pi.propertyField.set(object, value);
                    }
                }
            }
        }
        catch (Exception e) {
            String message = "Failed to assign property " + pi.name + " to object " + object.getClass().getSimpleName() + ": " + e.getMessage();
            throw new ImportException(message, e);
        }
    }

    static Object parseValue(@NotNull DbmObject object, @NotNull NameAndValue<String> p, @NotNull Type type) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/dbm/serialization/DbmImporter", "parseValue"));
        }
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/dbm/serialization/DbmImporter", "parseValue"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/dbm/serialization/DbmImporter", "parseValue"));
        }
        String propertyName = p.name;
        String text = DbmSerializationUtil.normalize((String)p.value);
        if (text == null) {
            return null;
        }
        try {
            return DbmImporter.parseValue(text, type);
        }
        catch (ParseValueException pve) {
            Throwable cause = pve.getCause();
            String typeName = type instanceof Class ? ((Class)type).getSimpleName() : type.toString();
            String message = cause == null ? String.format("Failed to parse property %s.%s (type %s): %s\nProperty text: %s\n", object.getClass().getSimpleName(), propertyName, typeName, pve.getMessage(), text) : String.format("Failed to parse property %s.%s (type %s): %s\nException %s with message: %s\nProperty text: %s\n", object.getClass().getSimpleName(), propertyName, typeName, pve.getMessage(), cause.getClass().getSimpleName(), cause.getMessage(), text);
            LOG.warn(message);
            return null;
        }
        catch (Exception e) {
            String typeName = type instanceof Class ? ((Class)type).getSimpleName() : type.toString();
            String message = String.format("Failed to parse property %s.%s (type %s): exception %s with message: %s\nProperty text: %s\n", object.getClass().getSimpleName(), propertyName, typeName, e.getClass().getSimpleName(), e.getMessage(), text);
            LOG.warn(message, (Throwable)e);
            return null;
        }
    }

    static Object parseValue(@NotNull String text, @NotNull Type type) throws ParseValueException {
        Object value;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/dbm/serialization/DbmImporter", "parseValue"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/dbm/serialization/DbmImporter", "parseValue"));
        }
        assert (type instanceof Class);
        Class clazz = (Class)type;
        if (clazz == String.class) {
            value = text;
        } else if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            char c = Character.toUpperCase(text.isEmpty() ? (char)'0' : text.charAt(0));
            value = c >= '1' && c <= '9' || c == '+' || c == 'Y' || c == 'T';
        } else if (ourObjectParseMethods.containsKey((Object)clazz)) {
            Method method = (Method)ourObjectParseMethods.get((Object)clazz);
            try {
                value = method.invoke(null, text);
            }
            catch (Exception e) {
                String message = "Failed to convert \"" + text + "\" into an instance of " + type + ": " + e.getMessage();
                throw new ParseValueException(message, e);
            }
        } else {
            if (clazz == Date.class) {
                try {
                    return DbmSerializationUtil.parseTimestamp(text);
                }
                catch (TimestampParsingException tpe) {
                    throw new ParseValueException(tpe);
                }
            }
            if (clazz.isEnum()) {
                value = Enum.valueOf(clazz, text);
            } else if (clazz == BigInteger.class) {
                value = new BigInteger(text);
            } else {
                String message = "Unknown how to convert \"" + text + "\" into an instance of " + type;
                throw new ParseValueException(message);
            }
        }
        return value;
    }

    static {
        try {
            ourObjectParseMethods = ImmutableMap.builder().put(Byte.TYPE, (Object)Byte.class.getDeclaredMethod("parseByte", String.class)).put(Byte.class, (Object)Byte.class.getDeclaredMethod("parseByte", String.class)).put(Short.TYPE, (Object)Short.class.getDeclaredMethod("parseShort", String.class)).put(Short.class, (Object)Short.class.getDeclaredMethod("parseShort", String.class)).put(Integer.TYPE, (Object)Integer.class.getDeclaredMethod("parseInt", String.class)).put(Integer.class, (Object)Integer.class.getDeclaredMethod("parseInt", String.class)).put(Long.TYPE, (Object)Long.class.getDeclaredMethod("parseLong", String.class)).put(Long.class, (Object)Long.class.getDeclaredMethod("parseLong", String.class)).put(DataType.class, (Object)DataTypeFactory.class.getDeclaredMethod("deserialize", String.class)).put(SequenceIdentity.class, (Object)SequenceIdentity.class.getDeclaredMethod("of", String.class)).put(LengthUnit.class, (Object)LengthUnit.class.getDeclaredMethod("of", String.class)).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

