/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlImportState {
    public final SqlImportState prevState;
    public final PsiElement element;
    public final TreePattern overlay;
    public final TreePattern state;
    private static final TreePatternNode FAKE_NODE = new TreePatternNode<TreePatternNode.PositiveNaming>(new TreePatternNode.PositiveNaming("FAKEFAKEFAKEFAKEFAKEFAKE"), TreePatternNode.NO_GROUPS);

    public SqlImportState(@Nullable PsiElement element, @Nullable TreePattern overlay, @NotNull TreePattern state, @Nullable SqlImportState prevState) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/sql/dialects/SqlImportState", "<init>"));
        }
        this.element = element;
        this.overlay = overlay;
        this.state = state;
        this.prevState = prevState;
    }

    public boolean isImported(@Nullable DbDataSource dataSource, @Nullable SqlDialectImplUtil.ObjectTracer<?> tracer) {
        List kinds = ContainerUtil.newSmartList();
        List names = ContainerUtil.newSmartList();
        SqlImportState.getTrace(dataSource, tracer, kinds, names);
        return this.overlay != null && SqlImportState.isImported(this.overlay, kinds, names) || SqlImportState.isImported(this.state, kinds, names);
    }

    private static boolean isImported(@NotNull TreePattern state, @NotNull List<ObjectKind> kinds, @NotNull List<String> names) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/sql/dialects/SqlImportState", "isImported"));
        }
        if (kinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kinds", "com/intellij/sql/dialects/SqlImportState", "isImported"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/sql/dialects/SqlImportState", "isImported"));
        }
        TIntArrayList depth = new TIntArrayList();
        ArrayList nodes2 = ContainerUtil.newArrayList();
        nodes2.add(state.root);
        depth.add(kinds.size() - 1);
        while (!nodes2.isEmpty()) {
            TreePatternNode node = (TreePatternNode)nodes2.remove(nodes2.size() - 1);
            int d = depth.remove(depth.size() - 1);
            String name = names.get(d);
            boolean found = node.matchedChildren(StringUtil.nullize((String)name), true, kinds.get(d), nodes2);
            if (name != null && name.length() == 0 || name == null && kinds.get(d) == SqlImportUtil.DATA_SOURCE) {
                found = true;
                nodes2.add(FAKE_NODE);
            }
            if (d == 0) {
                nodes2.subList(depth.size(), nodes2.size()).clear();
                if (!found) continue;
                return true;
            }
            while (depth.size() < nodes2.size()) {
                depth.add(d - 1);
            }
        }
        return false;
    }

    public static void getTrace(@Nullable DbDataSource dataSource, @Nullable SqlDialectImplUtil.ObjectTracer<?> tracer, @NotNull List<ObjectKind> kinds, @NotNull List<String> names) {
        if (kinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kinds", "com/intellij/sql/dialects/SqlImportState", "getTrace"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/sql/dialects/SqlImportState", "getTrace"));
        }
        if (tracer != null) {
            SqlDialectImplUtil.ObjectTracer.ObjectTraceIt<?> it = tracer.trace();
            while (it.hasNext()) {
                it.next();
                kinds.add(it.getKind());
                names.add(it.getCorrectName());
            }
        }
        kinds.add(SqlImportUtil.DATA_SOURCE);
        names.add(dataSource == null ? null : dataSource.getName());
    }
}

