/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.derby;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.derby.DerbyDdlParsing;
import com.intellij.sql.dialects.derby.DerbyDialect;
import com.intellij.sql.dialects.derby.DerbyDmlParsing;
import com.intellij.sql.dialects.derby.DerbyExpressionParsing;
import com.intellij.sql.dialects.derby.DerbyGeneratedParser;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.psi.impl.parser.SqlParser;

public class DerbyParser
extends SqlParser {
    public DerbyParser() {
        super(DerbyDialect.INSTANCE);
    }

    @Override
    public boolean allowStringsAsIdentifiers() {
        return true;
    }

    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        return DerbyGeneratedParser.statement(builder, level);
    }

    @Override
    protected TokenSet[] getExtendsTokenSets() {
        return DerbyGeneratedParser.EXTENDS_SETS_;
    }

    @Override
    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return DerbyDmlParsing.query_expression(builder, level);
    }

    @Override
    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result = DerbyExpressionParsing.value_expression(builder, level);
        if (!result && !optional) {
            builder.error("<expression> expected");
        }
        return result;
    }

    @Override
    public boolean parseDataType(PsiBuilder builder, int level) {
        return DerbyDdlParsing.type_element(builder, level);
    }

    @Override
    public IElementType parseLiteralOther(PsiBuilder builder, int level) {
        if (DerbyGeneratedParser.special_literals(builder, level)) {
            return SQL_SPECIAL_LITERAL;
        }
        return super.parseLiteralOther(builder, level);
    }

    @Override
    public boolean parseFunctionParametersAndParens(PsiBuilder builder, int level, String functionName, SqlFunctionDefinition definition, boolean allowNoParens) {
        if (super.parseFunctionParametersAndParens(builder, level, functionName, definition, allowNoParens)) {
            if (definition != null && "true".equals(definition.getDialectAttribute("analytic"))) {
                DerbyGeneratedParser.analytic_clause(builder, level);
            }
            return true;
        }
        return false;
    }
}

