/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.generation.surroundWith;

import com.intellij.codeInsight.generation.surroundWith.SurroundWithHandler;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public abstract class SqlSurrounderBase
implements Surrounder {
    @NotNull
    protected static TextRange surroundElementsWith(@NotNull Project project, @NotNull Editor editor, @NotNull String open, @NotNull String close, boolean caretAtEnd) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/generation/surroundWith/SqlSurrounderBase", "surroundElementsWith"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/generation/surroundWith/SqlSurrounderBase", "surroundElementsWith"));
        }
        if (open == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "open", "com/intellij/sql/generation/surroundWith/SqlSurrounderBase", "surroundElementsWith"));
        }
        if (close == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "close", "com/intellij/sql/generation/surroundWith/SqlSurrounderBase", "surroundElementsWith"));
        }
        SelectionModel model = editor.getSelectionModel();
        int[] starts = model.getBlockSelectionStarts();
        int[] ends = model.getBlockSelectionEnds();
        Document document = editor.getDocument();
        int offset = 0;
        for (int i = 0; i < starts.length; ++i) {
            document.insertString(starts[i] + offset, (CharSequence)open);
            document.insertString(ends[i] + (offset += open.length()), (CharSequence)close);
            offset += close.length();
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        documentManager.commitDocument(editor.getDocument());
        PsiFile file = documentManager.getPsiFile(editor.getDocument());
        if (file == null) {
            TextRange textRange = TextRange.from((int)(caretAtEnd ? ends[ends.length - 1] + offset : starts[starts.length - 1] + offset - close.length()), (int)0);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/generation/surroundWith/SqlSurrounderBase", "surroundElementsWith"));
            }
            return textRange;
        }
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            int pos = caretAtEnd ? caret.getSelectionEnd() + close.length() : caret.getSelectionStart() - open.length();
            caret.removeSelection();
            caret.moveToOffset(pos);
        }
        TextRange textRange = SurroundWithHandler.CARET_IS_OK;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/generation/surroundWith/SqlSurrounderBase", "surroundElementsWith"));
        }
        return textRange;
    }
}

