/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.ChangeDialectAction;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlDialectsConfigurable;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlDialectsUtil;
import com.intellij.sql.psi.SqlFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.MouseInfo;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDialectInspection
extends LocalInspectionTool {
    @NotNull
    public String getShortName() {
        if ("SqlDialectInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlDialectInspection", "getShortName"));
        }
        return "SqlDialectInspection";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        LocalQuickFix[] localQuickFixArray;
        boolean addSelected;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/inspections/SqlDialectInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/sql/inspections/SqlDialectInspection", "checkFile"));
        }
        if (!isOnTheFly || !(file instanceof SqlFile) || ((SqlFile)file).getSqlLanguage() != SqlDialectsUtil.GENERIC) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)file.getProject()).getTopLevelFile((PsiElement)file);
        if (topLevelFile.getVirtualFile() instanceof LightVirtualFile) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        String fileText = file.getText();
        CharSequence fileSnippet = fileText.subSequence(0, Math.min(fileText.length(), 10240));
        PsiFileFactory fileFactory = PsiFileFactory.getInstance((Project)file.getProject());
        HashMap dialectMap = ContainerUtil.newHashMap();
        MyMetric metric = new MyMetric();
        for (SqlLanguageDialect dialect : SqlDialectsUtil.getTopLevelSqlDialects()) {
            if (dialect.getDatabaseDialect().getFamilyId() == DatabaseFamilyId.UNKNOWN) continue;
            PsiFile sqlFile = fileFactory.createFileFromText("a.sql", (Language)dialect, fileSnippet);
            sqlFile.accept((PsiElementVisitor)metric);
            dialectMap.put(dialect, metric.getMetric());
        }
        ArrayList sortedDialects = ContainerUtil.newArrayList(dialectMap.keySet());
        Collections.sort(sortedDialects, (o1, o2) -> ((Double)dialectMap.get(o2)).compareTo((Double)dialectMap.get(o1)));
        if (sortedDialects.isEmpty()) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        SqlLanguageDialect topDialect = (SqlLanguageDialect)sortedDialects.get(0);
        double topMetric = (Double)dialectMap.get(topDialect);
        if (topMetric > 0.0 && topMetric < 10.0) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ArrayList selectedNames = ContainerUtil.newArrayList();
        if (topMetric > 0.0) {
            for (SqlLanguageDialect dialect : sortedDialects) {
                if (!((Double)dialectMap.get(dialect) / topMetric > 0.9)) continue;
                selectedNames.add(dialect.getDisplayName());
            }
        }
        String message = "SQL dialect is not configured.";
        boolean bl = addSelected = selectedNames.size() < 4;
        if (selectedNames.size() > 0 && addSelected) {
            message = message + " " + StringUtil.join((Collection)selectedNames, (String)", ") + (selectedNames.size() == 1 ? " matches" : " match") + " best.";
        }
        MyQuickFix settingsFix = new MyQuickFix(null);
        if (topMetric > 0.0 && addSelected) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[2];
            localQuickFixArray2[0] = new MyQuickFix(topDialect);
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[1] = settingsFix;
        } else {
            LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray3;
            localQuickFixArray3[0] = settingsFix;
        }
        LocalQuickFix[] quickFixes = localQuickFixArray;
        return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)file, message, true, quickFixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING)};
    }

    private static class MyMetric
    extends PsiRecursiveElementWalkingVisitor {
        int errors;
        int composites;

        private MyMetric() {
        }

        public double getMetric() {
            try {
                double d = this.errors == 0 ? (double)this.composites : (double)this.composites / (double)this.errors;
                return d;
            }
            finally {
                this.errors = 0;
                this.composites = 0;
            }
        }

        public void visitElement(PsiElement element) {
            if (element instanceof PsiErrorElement) {
                ++this.errors;
            } else if (element instanceof SqlCompositeElement) {
                ++this.composites;
            }
            super.visitElement(element);
        }
    }

    public static class MyQuickFix
    extends IntentionAndQuickFixAction {
        private final SqlLanguageDialect myDialect;

        public MyQuickFix(@Nullable SqlLanguageDialect dialect) {
            this.myDialect = dialect;
        }

        @NotNull
        public String getName() {
            String string = this.myDialect == null ? "Change dialect to..." : "Use " + this.myDialect.getDisplayName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlDialectInspection$MyQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlDialectInspection$MyQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/inspections/SqlDialectInspection$MyQuickFix", "applyFix"));
            }
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file);
            if (virtualFile instanceof VirtualFileWindow) {
                virtualFile = ((VirtualFileWindow)virtualFile).getDelegate();
            }
            if (virtualFile == null) {
                return;
            }
            if (this.myDialect == null) {
                boolean inProject = ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(virtualFile);
                if (inProject) {
                    SqlDialectsConfigurable.openDialectsConfigurable(project, virtualFile);
                } else if (file instanceof SqlFile) {
                    ListPopup popup = ChangeDialectAction.buildDialectsPopup(project, (JBIterable<VirtualFile>)JBIterable.of((Object[])new VirtualFile[]{virtualFile}));
                    if (editor != null && editor.getComponent().isShowing()) {
                        popup.showInBestPositionFor(editor);
                    } else {
                        popup.show(RelativePoint.fromScreen((Point)MouseInfo.getPointerInfo().getLocation()));
                    }
                }
            } else {
                SqlDialectMappings.getInstance(project).setMapping(virtualFile, this.myDialect);
            }
        }

        public boolean startInWriteAction() {
            return false;
        }
    }
}

