/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.google.common.collect.Iterables;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlParameterDefinition;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlProcedureDefinitionImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFunctionCallExpressionImpl
extends SqlExpressionImpl
implements SqlFunctionCallExpression,
NavigationItem {
    public SqlFunctionCallExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlFunctionCallExpression((SqlFunctionCallExpression)this);
    }

    @Nullable
    public SqlReferenceExpression getNameElement() {
        return (SqlReferenceExpression)ObjectUtils.tryCast((Object)this.getCallableExpression(), SqlReferenceExpression.class);
    }

    @NotNull
    public SqlExpression getCallableExpression() {
        SqlExpression sqlExpression = (SqlExpression)this.findNotNullChildByClass(SqlExpression.class);
        if (sqlExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "getCallableExpression"));
        }
        return sqlExpression;
    }

    public SqlExpressionList getParameterList() {
        return (SqlExpressionList)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_EXPRESSION_LIST);
    }

    @Override
    @NotNull
    public SqlType getSqlType() {
        boolean ensureTable;
        SqlReferenceExpression nameElement;
        Object resolve;
        SqlFunctionDefinition.Prototype prototype = SqlFunctionsUtil.chooseTheBestPrototype(this, true);
        if (prototype != null) {
            SqlType sqlType;
            SqlFunctionDefinition.Type returnType = prototype.getReturnType();
            SqlType sqlType2 = sqlType = returnType == null ? null : returnType.getSqlType();
            if (sqlType != null) {
                SqlType sqlType3 = sqlType;
                if (sqlType3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "getSqlType"));
                }
                return sqlType3;
            }
            if (returnType instanceof SqlFunctionDefinition.ParamType) {
                int index = ((SqlFunctionDefinition.ParamType)returnType).getIndex();
                SqlExpressionList parameterList = this.getParameterList();
                List params = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)parameterList, SqlCompositeElement.class);
                if (index > 0 && index <= params.size()) {
                    SqlCompositeElement element = (SqlCompositeElement)params.get(index - 1);
                    SqlType paramType = SqlFunctionCallExpressionImpl.getParamType((SqlElement)element);
                    if ("CAST".equalsIgnoreCase(prototype.getFunction().getName()) && params.get(0) instanceof SqlExpression) {
                        SqlTableType sqlTableType = SqlTableTypeBase.createType((SqlElement)params.get(0), paramType, null, (PsiElement)this);
                        if (sqlTableType == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "getSqlType"));
                        }
                        return sqlTableType;
                    }
                    SqlType sqlType4 = paramType;
                    if (sqlType4 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "getSqlType"));
                    }
                    return sqlType4;
                }
                if (index == 0) {
                    SqlPrimitiveType curType = SqlType.UNKNOWN;
                    for (SqlCompositeElement param : params) {
                        SqlType type = SqlFunctionCallExpressionImpl.getParamType((SqlElement)param);
                        if (curType == SqlType.UNKNOWN) {
                            curType = type;
                            continue;
                        }
                        if (curType != SqlType.INTEGER || type != SqlType.REAL) continue;
                        curType = SqlType.REAL;
                    }
                    SqlPrimitiveType sqlPrimitiveType = curType;
                    if (sqlPrimitiveType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "getSqlType"));
                    }
                    return sqlPrimitiveType;
                }
            }
        }
        PsiElement psiElement = resolve = (nameElement = this.getNameElement()) == null ? null : nameElement.getReference().resolve();
        if (resolve instanceof DbElement) {
            resolve = ((DbElement)resolve).getDelegate();
        }
        boolean bl = ensureTable = this.getParent() instanceof SqlFromClause || this.getParent() instanceof SqlAsExpression && this.getParent().getParent() instanceof SqlFromClause;
        if (resolve instanceof DasRoutine) {
            DasRoutine routine = (DasRoutine)resolve;
            DasArgument retArg = routine.getReturnArgument();
            JBIterable outArgs = JBIterable.from((Iterable)routine.getArguments()).filter(DasUtil.OUTPUT_ARGUMENT).append((Iterable)ContainerUtil.createMaybeSingletonList((Object)retArg));
            SqlType sqlType = this.createType((Iterable<? extends DasArgument>)outArgs, ensureTable);
            if (sqlType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "getSqlType"));
            }
            return sqlType;
        }
        if (resolve instanceof SqlTypedDefinition) {
            SqlExpression initializer;
            SqlTypedDefinition definition = (SqlTypedDefinition)resolve;
            SqlTypeElement typeElement = definition.getTypeElement();
            if (typeElement != null) {
                SqlType type = typeElement.findSqlType();
                if (type == SqlType.UNKNOWN) {
                    SqlType sqlType = SqlImplUtil.getSqlDialectSafe((PsiElement)this).getDefinitionType(definition, nameElement.getTextOffset());
                    if (sqlType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "getSqlType"));
                    }
                    return sqlType;
                }
                SqlType sqlType = type;
                if (sqlType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "getSqlType"));
                }
                return sqlType;
            }
            if (resolve instanceof SqlVariableDefinition && (initializer = ((SqlVariableDefinition)resolve).getInitializer()) != null) {
                SqlType sqlType = initializer.getSqlType();
                if (sqlType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "getSqlType"));
                }
                return sqlType;
            }
        }
        SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
        if (sqlPrimitiveType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "getSqlType"));
        }
        return sqlPrimitiveType;
    }

    @NotNull
    private static SqlType getParamType(SqlElement element) {
        Object object = element instanceof SqlTypeElement ? ((SqlTypeElement)element).findSqlType() : (element instanceof SqlExpression ? ((SqlExpression)element).getSqlType() : SqlType.UNKNOWN);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl", "getParamType"));
        }
        return object;
    }

    private SqlType createType(Iterable<? extends DasArgument> args, boolean ensureTable) {
        int size = Iterables.size(args);
        ArrayList columns = ContainerUtil.newArrayListWithCapacity((int)size);
        for (DasArgument dasArgument : args) {
            SqlType sqlType;
            SqlTypeElement typeElement = dasArgument instanceof SqlTypedDefinition ? ((SqlTypedDefinition)dasArgument).getTypeElement() : null;
            Object object = sqlType = typeElement != null ? typeElement.findSqlType() : SqlType.findByJdbcType((int)dasArgument.getDataType().jdbcType);
            if (size == 1 && typeElement != null) {
                return ensureTable ? SqlTableTypeBase.ensureTableType(sqlType, (SqlElement)typeElement, (PsiElement)this) : sqlType;
            }
            columns.add(new SqlImplUtil.Column(dasArgument.getName(), sqlType, (PsiElement)(dasArgument instanceof PsiElement ? (PsiElement)dasArgument : new FakeParameter((PsiElement)this, dasArgument)), null));
        }
        if (!ensureTable && columns.size() == 1) {
            return ((SqlImplUtil.Column)columns.get((int)0)).type;
        }
        return SqlImplUtil.createType(columns, (PsiElement)this);
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                SqlReferenceExpression nameElement = SqlFunctionCallExpressionImpl.this.getNameElement();
                return nameElement == null ? null : nameElement.getName();
            }

            @Nullable
            public String getLocationString() {
                return null;
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return null;
            }
        };
    }

    @Nullable
    public SqlFunctionDefinition getFunctionDefinition() {
        SqlReferenceExpression nameElement = this.getNameElement();
        if (nameElement == null) {
            return null;
        }
        String functionName = nameElement.getName();
        return SqlImplUtil.getSqlDialectSafe((PsiElement)this).getSupportedFunctions().get(functionName);
    }

    @Override
    public ObjectKind getExpectedReferenceTargetType(SqlElement referenceElement) {
        return referenceElement == this.getNameElement() && this.getFirstChild() != this.getLastChild() ? ObjectKind.ROUTINE : super.getExpectedReferenceTargetType(referenceElement);
    }

    @Override
    public boolean processImplicitContextDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        if (place == null || !(place.getParent() instanceof SqlBinaryExpression)) {
            return super.processImplicitContextDeclarations(processor, state, lastParent, place);
        }
        if (!SqlFunctionCallExpressionImpl.processParameters(this.getNameElement(), processor, state)) {
            return false;
        }
        return super.processImplicitContextDeclarations(processor, state, lastParent, place);
    }

    public static boolean processParameters(@Nullable SqlReferenceExpression fooRef, PsiScopeProcessor processor, ResolveState state) {
        block4: {
            PsiElement resolve;
            block3: {
                if (fooRef == null) {
                    return true;
                }
                PsiElement origin = fooRef.resolve();
                Object object = resolve = origin instanceof DbElement ? ((DbElement)origin).getDelegate() : origin;
                if (!(resolve instanceof SqlProcedureDefinitionImpl)) break block3;
                SqlProcedureDefinitionImpl procedure = (SqlProcedureDefinitionImpl)resolve;
                Iterable<SqlParameterDefinition> parameters = procedure.getArguments();
                for (SqlParameterDefinition parameter : parameters) {
                    if (processor.execute((PsiElement)parameter, state)) continue;
                    return false;
                }
                break block4;
            }
            if (!(resolve instanceof DasRoutine)) break block4;
            DasRoutine first = (DasRoutine)resolve;
            for (DasArgument parameter : DasUtil.getParameters((DasRoutine)first)) {
                if (processor.execute((PsiElement)new FakeParameter((PsiElement)fooRef, parameter){

                    @Override
                    @NotNull
                    public PsiElement getNavigationElement() {
                        PsiElement psiElement = super.getNavigationElement();
                        if (psiElement == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl$2", "getNavigationElement"));
                        }
                        return psiElement;
                    }
                }, state)) continue;
                return false;
            }
        }
        return true;
    }

    public static class FakeParameter
    extends SqlFileImpl.FakeDefinition {
        private final PsiElement myParent;
        private final DasArgument myParameter;

        public FakeParameter(@NotNull PsiElement parent, @NotNull DasArgument parameter) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl$FakeParameter", "<init>"));
            }
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl$FakeParameter", "<init>"));
            }
            super(parent, StringUtil.notNullize((String)parameter.getName()), null);
            this.myParent = parent;
            this.myParameter = parameter;
        }

        public int getTextOffset() {
            return this.myParent.getTextOffset();
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.ARGUMENT;
            if (objectKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl$FakeParameter", "getKind"));
            }
            return objectKind;
        }

        @Override
        public String getTypeName() {
            DatabaseDialectEx dialect = SqlImplUtil.getSqlDialectSafe(this.getParent()).getDatabaseDialect();
            return new DdlBuilder().applyCodeStyle(this.getProject()).withDialect(dialect).type((DasTypedObject)this.myParameter).getStatement();
        }

        @Override
        public Icon getIcon() {
            return DatabaseIcons.Col;
        }
    }
}

