/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.PsiTable;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.util.DasUtil;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlExplicitTableExpressionImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFunctionCallTableExpressionImpl
extends SqlExplicitTableExpressionImpl
implements SqlDefinition {
    private final FakeTable myTable;

    public SqlFunctionCallTableExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl", "<init>"));
        }
        super(node);
        this.myTable = new FakeTable();
    }

    @Override
    @NotNull
    public SqlType getSqlType() {
        String alias;
        SqlFunctionCallExpression call = this.getFunctionCall();
        SqlReferenceExpression name = call.getNameElement();
        SqlType type = call.getSqlType();
        String string = alias = name == null ? null : name.getName();
        if (type instanceof SqlTableType) {
            SqlTableType sqlTableType = ((SqlTableType)type).alias(alias, (PsiElement)this.myTable, Collections.emptyList());
            if (sqlTableType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl", "getSqlType"));
            }
            return sqlTableType;
        }
        SqlTableType sqlTableType = SqlTableTypeBase.createType((SqlElement)this.myTable.myColumn, type, alias, (PsiElement)this.myTable);
        if (sqlTableType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl", "getSqlType"));
        }
        return sqlTableType;
    }

    @NotNull
    private SqlFunctionCallExpression getFunctionCall() {
        SqlFunctionCallExpression sqlFunctionCallExpression = (SqlFunctionCallExpression)ObjectUtils.assertNotNull((Object)PsiTreeUtil.getChildOfType((PsiElement)this, SqlFunctionCallExpression.class));
        if (sqlFunctionCallExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl", "getFunctionCall"));
        }
        return sqlFunctionCallExpression;
    }

    @Override
    @NotNull
    public String getName() {
        SqlNameElement nameElement = this.getNameElement();
        String string = nameElement == null ? DasUtil.NO_NAME : nameElement.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl", "getName"));
        }
        return string;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl", "setName"));
        }
        SqlNameElement nameElement = this.getNameElement();
        if (nameElement != null) {
            nameElement.setName(name);
        }
        return this;
    }

    @Nullable
    public String getComment() {
        return null;
    }

    @Nullable
    public DasObject getDbParent() {
        return null;
    }

    @NotNull
    public <C> JBIterable<C> getDbChildren(@NotNull Class<C> clazz, @NotNull ObjectKind kind) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl", "getDbChildren"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl", "getDbChildren"));
        }
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl", "getDbChildren"));
        }
        return jBIterable;
    }

    @Nullable
    public SqlNameElement getNameElement() {
        return this.getFunctionCall().getNameElement();
    }

    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = SqlDbElementType.LOCAL_ALIAS;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl", "getKind"));
        }
        return objectKind;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return null;
    }

    private class FakeTable
    extends FakeDefinition
    implements PsiTable {
        private final FakeColumn myColumn;

        public boolean isSystem() {
            return false;
        }

        public boolean isTemporary() {
            return false;
        }

        @NotNull
        public Set<DasColumn.Attribute> getColumnAttrs(@Nullable DasColumn columnInfo) {
            Set<DasColumn.Attribute> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl$FakeTable", "getColumnAttrs"));
            }
            return set;
        }

        protected FakeTable() {
            super((PsiElement)SqlFunctionCallTableExpressionImpl.this);
            this.myColumn = new FakeColumn();
        }

        @Override
        @Nullable
        public DasObject getDbParent() {
            return null;
        }

        @Override
        @NotNull
        public <C> JBIterable<C> getDbChildren(@NotNull Class<C> clazz, @NotNull ObjectKind kind) {
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl$FakeTable", "getDbChildren"));
            }
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl$FakeTable", "getDbChildren"));
            }
            JBIterable jBIterable = JBIterable.of((Object[])new FakeColumn[]{this.myColumn}).filter(DasUtil.byKind((ObjectKind)kind)).filter(clazz);
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl$FakeTable", "getDbChildren"));
            }
            return jBIterable;
        }

        @Override
        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.TABLE;
            if (objectKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl$FakeTable", "getKind"));
            }
            return objectKind;
        }

        private class FakeColumn
        extends FakeDefinition
        implements PsiColumn {
            protected FakeColumn() {
                super((PsiElement)FakeTable.this);
            }

            public short getPosition() {
                return 0;
            }

            @NotNull
            public String getDisplayOrder() {
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl$FakeTable$FakeColumn", "getDisplayOrder"));
                }
                return "";
            }

            public String getTableName() {
                return this.getTable().getName();
            }

            public DasTable getTable() {
                return FakeTable.this;
            }

            @Override
            @Nullable
            public DasObject getDbParent() {
                return this.getTable();
            }

            @Override
            @NotNull
            public ObjectKind getKind() {
                ObjectKind objectKind = ObjectKind.COLUMN;
                if (objectKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl$FakeTable$FakeColumn", "getKind"));
                }
                return objectKind;
            }

            @NotNull
            public DataType getDataType() {
                DataType dataType = DataType.UNKNOWN;
                if (dataType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl$FakeTable$FakeColumn", "getDataType"));
                }
                return dataType;
            }

            @Nullable
            public DasUserDefinedType getCustomType() {
                return null;
            }

            public boolean isNotNull() {
                return false;
            }

            @Nullable
            public String getDefault() {
                return null;
            }
        }
    }

    private abstract class FakeDefinition
    extends RenameableFakePsiElement
    implements SqlDefinition,
    SqlNameElement {
        protected FakeDefinition(PsiElement parent) {
            super(parent);
        }

        @Nullable
        public String getComment() {
            return null;
        }

        @Nullable
        public DasObject getDbParent() {
            return null;
        }

        @NotNull
        public <C> JBIterable<C> getDbChildren(@NotNull Class<C> clazz, @NotNull ObjectKind kind) {
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl$FakeDefinition", "getDbChildren"));
            }
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl$FakeDefinition", "getDbChildren"));
            }
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl$FakeDefinition", "getDbChildren"));
            }
            return jBIterable;
        }

        @Nullable
        public PsiElement getNameIdentifier() {
            return this.getNameElement();
        }

        @NotNull
        public String getName() {
            SqlNameElement nameElement = this.getNameElement();
            String string = nameElement == null ? DasUtil.NO_NAME : nameElement.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl$FakeDefinition", "getName"));
            }
            return string;
        }

        public String getTypeName() {
            return "";
        }

        @Nullable
        public Icon getIcon() {
            return DbPresentation.getIcon((DasObject)this);
        }

        @Nullable
        public SqlNameElement getNameElement() {
            return SqlFunctionCallTableExpressionImpl.this.getFunctionCall().getNameElement();
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.NONE;
            if (objectKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl$FakeDefinition", "getKind"));
            }
            return objectKind;
        }

        public boolean isPlainIdentifier() {
            SqlNameElement nameElement = this.getNameElement();
            return nameElement == null || nameElement.isPlainIdentifier();
        }

        public boolean isQuotedIdentifier() {
            SqlNameElement nameElement = this.getNameElement();
            return nameElement != null && nameElement.isQuotedIdentifier();
        }

        public void accept(SqlVisitor visitor) {
        }

        public void acceptChildren(SqlVisitor visitor) {
        }

        public FakeDefinition setName(@NonNls @NotNull String name) throws IncorrectOperationException {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl$FakeDefinition", "setName"));
            }
            SqlNameElement nameElement = this.getNameElement();
            if (nameElement != null) {
                nameElement.setName(name);
            }
            return this;
        }
    }
}

