/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDialectsUtil;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.parser.SqlParserDefinition;
import com.intellij.sql.psi.stubs.SqlNamedElementStub;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlStubElementType<S extends StubElement<T>, T extends SqlElement>
extends IStubElementType<S, T> {
    public SqlStubElementType(@NonNls @NotNull String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/sql/psi/stubs/SqlStubElementType", "<init>"));
        }
        super(debugName, (Language)SqlLanguage.INSTANCE);
    }

    public void indexStub(@NotNull S stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/sql/psi/stubs/SqlStubElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/sql/psi/stubs/SqlStubElementType", "indexStub"));
        }
    }

    @NotNull
    public String getExternalId() {
        String string = "sql." + super.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/stubs/SqlStubElementType", "getExternalId"));
        }
        return string;
    }

    public T createPsi(@NotNull S stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/sql/psi/stubs/SqlStubElementType", "createPsi"));
        }
        SqlFileImpl file = (SqlFileImpl)stub.getParentStubOfType(SqlFileImpl.class);
        assert (file != null);
        SqlLanguageDialectEx dialect = file.getSqlLanguage();
        if (dialect == SqlDialectsUtil.GENERIC) {
            VirtualFile vFile = file.getVirtualFile();
            SqlDialectImplUtil.LOG.error("Generic Dialect encountered in " + this.getExternalId() + ".createPsi(" + stub.getClass().getSimpleName() + ")" + (vFile != null ? "Dialect[" + vFile.getName() + "]: " + vFile.getUserData(SqlDialectMappings.SQL_DIALECT_KEY) : ""));
        }
        SqlParserDefinition definition = (SqlParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)dialect);
        return (T)((SqlElement)definition.createElement(stub));
    }

    @Nullable
    protected static StringRef asStringRef(PsiElement nameElement) {
        String text = nameElement == null ? null : nameElement.getText();
        return text == null ? null : StringRef.fromString((String)text);
    }

    public boolean shouldCreateStub(ASTNode node) {
        return super.shouldCreateStub(node) && node.getTreeParent().getElementType() != SqlCompositeElementTypes.SQL_TYPE_ELEMENT;
    }

    protected static <T extends SqlNamedElementStub<? extends SqlDefinition>> void indexNamedStub(T stub, StubIndexKey<String, SqlDefinition> key, IndexSink sink) {
        String shortName;
        String name = stub.getName();
        String string = shortName = name == null ? null : StringUtil.getShortName((String)name);
        if (shortName == null || shortName.length() == 0) {
            return;
        }
        char c = shortName.charAt(0);
        String nameToIndex = shortName.length() > 2 && (c == '\'' || c == '\"' || c == '`' || c == '[') ? shortName.substring(1, shortName.length() - 2) : shortName;
        sink.occurrence(key, (Object)nameToIndex);
    }
}

