/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.stubs.SqlStubElementType;
import com.intellij.sql.psi.stubs.SqlTableNameIndex;
import com.intellij.sql.psi.stubs.SqlTableStub;
import com.intellij.util.NotNullFunction;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SqlTableElementType
extends SqlStubElementType<SqlTableStub, SqlTableDefinition> {
    public static final NotNullFunction<String, SqlTableElementType> FACTORY = name -> new SqlTableElementType((String)name);

    public SqlTableElementType(@NonNls @NotNull String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/sql/psi/stubs/SqlTableElementType", "<init>"));
        }
        super(debugName);
    }

    public SqlTableStub createStub(@NotNull SqlTableDefinition psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/sql/psi/stubs/SqlTableElementType", "createStub"));
        }
        SqlExpression expression = psi.getExpression();
        return new SqlTableStub(parentStub, this, SqlTableElementType.asStringRef((PsiElement)psi.getNameElement()), expression == null ? null : StringRef.fromString((String)expression.getText()));
    }

    public void serialize(@NotNull SqlTableStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/sql/psi/stubs/SqlTableElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/sql/psi/stubs/SqlTableElementType", "serialize"));
        }
        dataStream.writeName(stub.getName());
        dataStream.writeName(stub.getExpressionText());
    }

    @NotNull
    public SqlTableStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/sql/psi/stubs/SqlTableElementType", "deserialize"));
        }
        SqlTableStub sqlTableStub = new SqlTableStub(parentStub, this, dataStream.readName(), dataStream.readName());
        if (sqlTableStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/stubs/SqlTableElementType", "deserialize"));
        }
        return sqlTableStub;
    }

    @Override
    public void indexStub(@NotNull SqlTableStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/sql/psi/stubs/SqlTableElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/sql/psi/stubs/SqlTableElementType", "indexStub"));
        }
        SqlTableElementType.indexNamedStub(stub, SqlTableNameIndex.KEY, sink);
    }
}

