/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import org.jetbrains.annotations.NotNull;

public abstract class VolatileNotNullLazyValue<T>
extends NotNullLazyValue<T> {
    private static final RecursionGuard ourGuard = RecursionManager.createGuard("VolatileNotNullLazyValue");
    private volatile T myValue;

    @Override
    @NotNull
    public final T getValue() {
        T value = this.myValue;
        if (value == null) {
            RecursionGuard.StackStamp stamp = ourGuard.markStack();
            value = this.compute();
            if (stamp.mayCacheNow()) {
                this.myValue = value;
            }
        }
        T t = value;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/VolatileNotNullLazyValue", "getValue"));
        }
        return t;
    }
}

