/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.resources.ResourceFolderType;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Context;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.ResourceXmlDetector;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.Speed;
import com.android.tools.klint.detector.api.XmlContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UQualifiedExpression;
import org.jetbrains.uast.USimpleReferenceExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class AlwaysShowActionDetector
extends ResourceXmlDetector
implements UastScanner {
    public static final Issue ISSUE = Issue.create("AlwaysShowAction", "Usage of `showAsAction=always`", "Using `showAsAction=\"always\"` in menu XML, or `MenuItem.SHOW_AS_ACTION_ALWAYS` in Java code is usually a deviation from the user interface style guide.Use `ifRoom` or the corresponding `MenuItem.SHOW_AS_ACTION_IF_ROOM` instead.\n\nIf `always` is used sparingly there are usually no problems and behavior is roughly equivalent to `ifRoom` but with preference over other `ifRoom` items. Using it more than twice in the same menu is a bad idea.\n\nThis check looks for menu XML files that contain more than two `always` actions, or some `always` actions and no `ifRoom` actions. In Java code, it looks for projects that contain references to `MenuItem.SHOW_AS_ACTION_ALWAYS` and no references to `MenuItem.SHOW_AS_ACTION_IF_ROOM`.", Category.USABILITY, 3, Severity.WARNING, new Implementation(AlwaysShowActionDetector.class, Scope.SOURCE_AND_RESOURCE_FILES, Scope.RESOURCE_FILE_SCOPE)).addMoreInfo("http://developer.android.com/design/patterns/actionbar.html");
    private List<Attr> mFileAttributes;
    private boolean mIgnoreFile;
    private List<Location> mAlwaysFields;
    private boolean mHasIfRoomRefs;

    @Override
    public boolean appliesTo(@NonNull ResourceFolderType folderType) {
        return folderType == ResourceFolderType.MENU;
    }

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("showAsAction");
    }

    @Override
    public void beforeCheckFile(@NonNull Context context) {
        this.mFileAttributes = null;
    }

    @Override
    public void afterCheckFile(@NonNull Context context) {
        if (this.mIgnoreFile) {
            this.mFileAttributes = null;
            return;
        }
        if (this.mFileAttributes != null) {
            assert (context instanceof XmlContext);
            ArrayList<Attr> always = new ArrayList<Attr>();
            ArrayList<Attr> ifRoom = new ArrayList<Attr>();
            block0: for (Attr attribute : this.mFileAttributes) {
                String[] flags;
                String value2 = attribute.getValue();
                if (value2.equals("always")) {
                    always.add(attribute);
                    continue;
                }
                if (value2.equals("ifRoom")) {
                    ifRoom.add(attribute);
                    continue;
                }
                if (value2.indexOf(124) == -1) continue;
                for (String flag : flags = value2.split("\\|")) {
                    if (flag.equals("always")) {
                        always.add(attribute);
                        continue block0;
                    }
                    if (!flag.equals("ifRoom")) continue;
                    ifRoom.add(attribute);
                    continue block0;
                }
            }
            if (!always.isEmpty() && this.mFileAttributes.size() > 1 && (always.size() > 2 || ifRoom.isEmpty())) {
                XmlContext xmlContext = (XmlContext)context;
                Location location = null;
                for (int i = always.size() - 1; i >= 0; --i) {
                    Location next = location;
                    location = xmlContext.getLocation((Node)always.get(i));
                    if (next == null) continue;
                    location.setSecondary(next);
                }
                context.report(ISSUE, location, "Prefer \"`ifRoom`\" instead of \"`always`\"");
            }
        }
    }

    @Override
    public void afterCheckProject(@NonNull Context context) {
        if (this.mAlwaysFields != null && !this.mHasIfRoomRefs) {
            for (Location location : this.mAlwaysFields) {
                context.report(ISSUE, location, "Prefer \"`SHOW_AS_ACTION_IF_ROOM`\" instead of \"`SHOW_AS_ACTION_ALWAYS`\"");
            }
        }
    }

    @Override
    public void visitAttribute(@NonNull XmlContext context, @NonNull Attr attribute) {
        if (context.getDriver().isSuppressed(context, ISSUE, attribute)) {
            this.mIgnoreFile = true;
            return;
        }
        if (this.mFileAttributes == null) {
            this.mFileAttributes = new ArrayList<Attr>();
        }
        this.mFileAttributes.add(attribute);
    }

    @Override
    public UastVisitor createUastVisitor(UastAndroidContext context) {
        return new FieldAccessChecker(context);
    }

    private class FieldAccessChecker
    extends AbstractUastVisitor {
        private final UastAndroidContext mContext;

        public FieldAccessChecker(UastAndroidContext context) {
            this.mContext = context;
        }

        @Override
        public boolean visitQualifiedExpression(@NotNull UQualifiedExpression node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/AlwaysShowActionDetector$FieldAccessChecker", "visitQualifiedExpression"));
            }
            UExpression selector2 = node.getSelector();
            if (!(selector2 instanceof USimpleReferenceExpression)) {
                return false;
            }
            String description = ((USimpleReferenceExpression)selector2).getIdentifier();
            boolean isIfRoom = description.equals("SHOW_AS_ACTION_IF_ROOM");
            boolean isAlways = description.equals("SHOW_AS_ACTION_ALWAYS");
            if ((isIfRoom || isAlways) && UastUtils.endsWithQualified(node.getReceiver(), "MenuItem")) {
                if (isAlways) {
                    JavaContext lintContext = this.mContext.getLintContext();
                    if (lintContext.getDriver().isSuppressed(lintContext, ISSUE, node)) {
                        return super.visitQualifiedExpression(node);
                    }
                    if (AlwaysShowActionDetector.this.mAlwaysFields == null) {
                        AlwaysShowActionDetector.this.mAlwaysFields = new ArrayList();
                    }
                    AlwaysShowActionDetector.this.mAlwaysFields.add(this.mContext.getLocation(node));
                } else {
                    AlwaysShowActionDetector.this.mHasIfRoomRefs = true;
                }
            }
            return super.visitQualifiedExpression(node);
        }
    }
}

