/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.descriptors;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueValidator;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.descriptor.value.CssValueValidatorImpl;
import com.intellij.psi.css.impl.util.scheme.CssElementDescriptorProviderImpl;
import com.intellij.psi.css.resolve.CssStyleReferenceStub;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.less.LESSLanguage;
import org.jetbrains.plugins.less.descriptors.LessCustomDescriptors;
import org.jetbrains.plugins.less.psi.LESSMixin;
import org.jetbrains.plugins.less.psi.LESSMixinInvocation;
import org.jetbrains.plugins.less.psi.impl.LESSVariableImpl;

public class LessElementDescriptorProvider
extends CssElementDescriptorProviderImpl {
    private final CssValueValidatorImpl LESS_VALUE_VALIDATOR = new CssValueValidatorImpl((CssElementDescriptorProvider)this){

        public boolean isValid(@Nullable PsiElement term, @NotNull CssValueDescriptor valueDescriptor) {
            if (valueDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueDescriptor", "org/jetbrains/plugins/less/descriptors/LessElementDescriptorProvider$1", "isValid"));
            }
            if (term instanceof CssTerm && ((CssTerm)term).getTermType() == CssTermTypes.TOGGLE) {
                return super.isValid(term, valueDescriptor);
            }
            if (term != null && (term instanceof LESSVariableImpl || term.getFirstChild() instanceof LESSVariableImpl)) {
                return true;
            }
            boolean result = super.isValid(term, valueDescriptor);
            if (!result && term != null) {
                PsiElement firstChild = term.getFirstChild();
                if (firstChild instanceof CssFunction) {
                    term = firstChild;
                }
                if (term instanceof CssFunction) {
                    return LessElementDescriptorProvider.super.findFunctionDescriptors(((CssFunction)term).getName(), term).isEmpty();
                }
            }
            return result;
        }
    };

    public boolean isMyContext(@Nullable PsiElement context) {
        return LESSLanguage.INSTANCE.is(CssPsiUtil.getStylesheetLanguage((PsiElement)context));
    }

    @NotNull
    public Collection<? extends CssPseudoSelectorDescriptor> getAllPseudoSelectorDescriptors(@Nullable PsiElement context) {
        HashSet result = ContainerUtil.newHashSet();
        result.add(LessCustomDescriptors.EXTEND_PSEUDO_CLASS_DESCRIPTOR);
        result.addAll(super.getAllPseudoSelectorDescriptors(context));
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/descriptors/LessElementDescriptorProvider", "getAllPseudoSelectorDescriptors"));
        }
        return hashSet;
    }

    @NotNull
    public Collection<? extends CssPseudoSelectorDescriptor> findPseudoSelectorDescriptors(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/less/descriptors/LessElementDescriptorProvider", "findPseudoSelectorDescriptors"));
        }
        Collection collection = "extend".equalsIgnoreCase(name) ? ContainerUtil.newSmartList((Object)LessCustomDescriptors.EXTEND_PSEUDO_CLASS_DESCRIPTOR) : super.findPseudoSelectorDescriptors(name);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/descriptors/LessElementDescriptorProvider", "findPseudoSelectorDescriptors"));
        }
        return collection;
    }

    @NotNull
    public PsiElement[] getDeclarationsForSimpleSelector(@NotNull CssSimpleSelector selector) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "org/jetbrains/plugins/less/descriptors/LessElementDescriptorProvider", "getDeclarationsForSimpleSelector"));
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/descriptors/LessElementDescriptorProvider", "getDeclarationsForSimpleSelector"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public boolean providesClassicCss() {
        return false;
    }

    @NotNull
    public PsiReference getStyleReference(PsiElement element, int start, int end, boolean caseSensitive) {
        CssStyleReferenceStub cssStyleReferenceStub = new CssStyleReferenceStub(element, TextRange.create((int)start, (int)end));
        if (cssStyleReferenceStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/descriptors/LessElementDescriptorProvider", "getStyleReference"));
        }
        return cssStyleReferenceStub;
    }

    public CssContextType getCssContextType(@Nullable PsiElement context) {
        CssContextType ruleType = super.getCssContextType(context);
        if (ruleType == CssContextType.NONE) {
            LESSMixin mixin = (LESSMixin)PsiTreeUtil.getParentOfType((PsiElement)context, LESSMixin.class);
            if (mixin != null) {
                return CssContextType.ANY;
            }
            LESSMixinInvocation mixinInvocation = (LESSMixinInvocation)PsiTreeUtil.getParentOfType((PsiElement)context, LESSMixinInvocation.class);
            if (mixinInvocation != null) {
                return CssContextType.ANY;
            }
        }
        return ruleType;
    }

    @NotNull
    public CssValueValidator getValueValidator() {
        CssValueValidatorImpl cssValueValidatorImpl = this.LESS_VALUE_VALIDATOR;
        if (cssValueValidatorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/descriptors/LessElementDescriptorProvider", "getValueValidator"));
        }
        return cssValueValidatorImpl;
    }
}

