/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.editor.CssFormattingModelBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlToken;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.less.LESSElementTypes;
import org.jetbrains.plugins.less.formatter.LESSMixinBlock;
import org.jetbrains.plugins.less.formatter.LESSRootBlock;
import org.jetbrains.plugins.less.formatter.LESSRulesetBlock;
import org.jetbrains.plugins.less.lexer.LESSTokenTypes;
import org.jetbrains.plugins.less.psi.LESSMixin;
import org.jetbrains.plugins.less.psi.LESSMixinInvocation;
import org.jetbrains.plugins.less.psi.LESSVariableDeclaration;
import org.jetbrains.plugins.less.psi.impl.LESSGuardImpl;
import org.jetbrains.plugins.less.psi.impl.LESSMixinName;
import org.jetbrains.plugins.less.psi.impl.LESSVariableImpl;
import org.jetbrains.plugins.less.psi.impl.LessPluginDeclaration;

public class LessFormattingModelBuilder
extends CssFormattingModelBuilder {
    protected CssFormattingModelBuilder.CssFormattingExtension createExtension() {
        return LessFormattingExtension.INSTANCE;
    }

    protected static class LessFormattingExtension
    extends CssFormattingModelBuilder.CssFormattingExtension {
        static final LessFormattingExtension INSTANCE = new LessFormattingExtension();

        protected LessFormattingExtension() {
        }

        public boolean isLineComment(IElementType elementType) {
            return LESSTokenTypes.COMMENT == elementType || super.isLineComment(elementType);
        }

        public boolean isComment(IElementType elementType) {
            return LESSElementTypes.LESS_COMMENTS.contains(elementType) || super.isComment(elementType);
        }

        public Indent getTokenIndent(XmlToken token, CssCodeStyleSettings settings, IElementType type) {
            if (token.getTokenType() == CssElementTypes.CSS_RBRACE && settings.ALIGN_CLOSING_BRACE_WITH_PROPERTIES) {
                return Indent.getNormalIndent();
            }
            return super.getTokenIndent(token, settings, type);
        }

        public boolean addSubBlocksOfExtendedLanguage(PsiElement element, CssCodeStyleSettings settings, int maxPropertyLength, List<Block> result) {
            Alignment alignment;
            IElementType parentType = element.getParent().getNode().getElementType();
            Indent indent = parentType == CssElementTypes.CSS_DECLARATION_BLOCK || parentType == CssElementTypes.CSS_KEYFRAMES_RULE ? Indent.getNormalIndent() : Indent.getNoneIndent();
            Object object = alignment = settings.VALUE_ALIGNMENT == 2 || settings.VALUE_ALIGNMENT == 1 ? Alignment.createAlignment((boolean)true) : null;
            if (element instanceof LESSGuardImpl) {
                result.add((Block)new CssFormattingModelBuilder.CssSimpleBlock(element.getNode(), settings, Indent.getNoneIndent(), element.getTextLength(), (CssFormattingModelBuilder.CssFormattingExtension)this));
                return true;
            }
            if (element instanceof LESSVariableDeclaration || element instanceof LessPluginDeclaration) {
                result.add((Block)new CssFormattingModelBuilder.CssPropertyBlock(element.getNode(), settings, indent, maxPropertyLength, (CssFormattingModelBuilder.CssFormattingExtension)this, element.getTextLength(), null, alignment));
                return true;
            }
            if (element instanceof LESSVariableImpl) {
                result.add((Block)new CssFormattingModelBuilder.CssSimpleBlock(element.getNode(), settings, Indent.getNoneIndent(), maxPropertyLength, (CssFormattingModelBuilder.CssFormattingExtension)this));
                return true;
            }
            if (element instanceof LESSMixinInvocation) {
                result.add((Block)new CssFormattingModelBuilder.CssPropertyBlock(element.getNode(), settings, indent, element.getTextLength(), (CssFormattingModelBuilder.CssFormattingExtension)this, element.getTextLength(), alignment, null));
                return true;
            }
            if (element instanceof LESSMixin) {
                result.add((Block)new LESSMixinBlock(element.getNode(), settings, indent, maxPropertyLength, this));
                return true;
            }
            if (element instanceof LESSMixinName || LESSTokenTypes.GUARD_KEYWORDS.contains(element.getNode().getElementType())) {
                result.add((Block)new CssFormattingModelBuilder.LeafBlock(element.getNode(), Indent.getNoneIndent()));
                return true;
            }
            return false;
        }

        public CssFormattingModelBuilder.CssRootBlock createRootBlock(ASTNode _node, CssCodeStyleSettings settings, int maxPropertyLength, CssFormattingModelBuilder.CssFormattingExtension extension) {
            return new LESSRootBlock(_node, settings, maxPropertyLength, extension);
        }

        public CssFormattingModelBuilder.CssRulesetBlock createRulesetBlock(ASTNode _node, CssCodeStyleSettings settings, Indent indent, int maxPropertyLength, CssFormattingModelBuilder.CssFormattingExtension extension, @Nullable Alignment alignment) {
            return new LESSRulesetBlock(_node, settings, indent, maxPropertyLength, extension, alignment);
        }
    }
}

