/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.el.extensions;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.spring.el.contextProviders.SpringElInjectionContext;
import com.intellij.spring.model.aliasFor.SpringAliasFor;
import com.intellij.spring.model.aliasFor.SpringAliasForUtils;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class SpringELAliasedAttributeInjectionContext
extends SpringElInjectionContext {
    private static Pair[] aliasedAnnotations = new Pair[]{Pair.create((Object)"org.springframework.context.event.EventListener", (Object)"condition"), Pair.create((Object)"org.springframework.cache.annotation.Cacheable", (Object)"condition"), Pair.create((Object)"org.springframework.cache.annotation.Cacheable", (Object)"unless"), Pair.create((Object)"org.springframework.cache.annotation.Cacheable", (Object)"key"), Pair.create((Object)"org.springframework.cache.annotation.CachePut", (Object)"condition"), Pair.create((Object)"org.springframework.cache.annotation.CachePut", (Object)"unless"), Pair.create((Object)"org.springframework.cache.annotation.CachePut", (Object)"key"), Pair.create((Object)"org.springframework.cache.annotation.CacheEvict", (Object)"condition"), Pair.create((Object)"org.springframework.cache.annotation.CacheEvict", (Object)"unless")};

    public static boolean isCustomAnnotation(@NotNull PsiAnnotation annotation, @NotNull String baseAnnoName) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/spring/el/extensions/SpringELAliasedAttributeInjectionContext", "isCustomAnnotation"));
        }
        if (baseAnnoName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseAnnoName", "com/intellij/spring/el/extensions/SpringELAliasedAttributeInjectionContext", "isCustomAnnotation"));
        }
        String qualifiedName = annotation.getQualifiedName();
        if (qualifiedName == null) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)annotation);
        if (module != null) {
            Collection customAnnotations = JamAnnotationTypeUtil.getInstance((Module)module).getAnnotationTypesWithChildren(baseAnnoName);
            for (PsiClass psiClass : customAnnotations) {
                if (!qualifiedName.equals(psiClass.getQualifiedName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSpringElCompatibleHost(@NotNull PsiLiteralExpression host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/spring/el/extensions/SpringELAliasedAttributeInjectionContext", "isSpringElCompatibleHost"));
        }
        PsiElement hostParent = host.getParent();
        if (hostParent instanceof PsiNameValuePair) {
            PsiElement element;
            String attrName = ((PsiNameValuePair)hostParent).getName();
            PsiElement parent = hostParent.getParent();
            if (parent instanceof PsiAnnotationParameterList && !parent.getProject().isDefault() && (element = parent.getParent()) instanceof PsiAnnotation) {
                PsiAnnotation psiAnnotation = (PsiAnnotation)element;
                if (StringUtil.isEmptyOrSpaces((String)attrName)) {
                    return false;
                }
                for (Pair annotation : aliasedAnnotations) {
                    SpringAliasFor aliasForCondition;
                    String aliasedAnnoName = (String)annotation.first;
                    String aliasedAttrName = (String)annotation.second;
                    if (!SpringELAliasedAttributeInjectionContext.isCustomAnnotation(psiAnnotation, aliasedAnnoName) || (aliasForCondition = SpringAliasForUtils.findAliasFor((PsiElement)psiAnnotation, (String)psiAnnotation.getQualifiedName(), (String)aliasedAnnoName, (String)aliasedAttrName)) == null || !attrName.equals(aliasForCondition.getPsiElement().getName())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

