/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet.validation;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.framework.detection.DetectionExcludesConfiguration;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringModelProvider;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.facet.SpringFrameworkDetector;
import com.intellij.spring.facet.validation.SpringProgrammaticConfigurationCollector;
import com.intellij.spring.facet.validation.SpringUnmappedConfigurationFilesCollector;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import icons.SpringApiIcons;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringConfigurationCheckTask
extends Task.Backgroundable {
    private static final String NOTIFICATION_ID = "Spring Configuration Check";
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Spring Configuration Check", NotificationDisplayType.STICKY_BALLOON, true);
    private static final String CREATE_DEFAULT_CONTEXT_LABEL = "Create Default Context";
    private final DumbService dumbService = DumbService.getInstance((Project)this.getProject());
    private SpringUnmappedConfigurationFilesCollector myUnmappedCollector;
    private SpringProgrammaticConfigurationCollector myProgrammaticCollector;

    SpringConfigurationCheckTask(Project project) {
        super(project, NOTIFICATION_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull ProgressIndicator indicator) {
        SensitiveProgressWrapper innerIndicator;
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/spring/facet/validation/SpringConfigurationCheckTask", "run"));
        }
        do {
            innerIndicator = SpringConfigurationCheckTask.createWrappingIndicator(indicator);
            Disposable disposable = Disposer.newDisposable();
            try {
                SwingUtilities.invokeAndWait(() -> SpringConfigurationCheckTask.lambda$run$0((ProgressIndicator)innerIndicator, disposable));
            }
            catch (Throwable e) {
                break;
            }
            try {
                ProgressManager.getInstance().runProcess(() -> this.lambda$run$2((ProgressIndicator)innerIndicator), (ProgressIndicator)innerIndicator);
            }
            finally {
                Disposer.dispose((Disposable)disposable);
            }
        } while (!indicator.isCanceled() && innerIndicator.isCanceled());
    }

    private static SensitiveProgressWrapper createWrappingIndicator(final ProgressIndicator indicator) {
        return new SensitiveProgressWrapper(indicator){

            public void setText(String text) {
                indicator.setText(text);
            }

            public void setText2(String text) {
                indicator.setText2(text);
            }

            public void setFraction(double fraction) {
                indicator.setFraction(fraction);
            }

            public void setIndeterminate(boolean indeterminate) {
                indicator.setIndeterminate(indeterminate);
            }
        };
    }

    private void runCollectors(ProgressIndicator indicator) {
        if (this.getProject().isDisposed()) {
            return;
        }
        Module[] modules = ModuleManager.getInstance((Project)this.getProject()).getModules();
        if (modules.length == 0) {
            return;
        }
        this.myUnmappedCollector = new SpringUnmappedConfigurationFilesCollector(modules);
        if (this.myUnmappedCollector.isEnabledInProject()) {
            this.myUnmappedCollector.collect(indicator);
        }
        this.myProgrammaticCollector = new SpringProgrammaticConfigurationCollector(this.getProject());
        if (!ApplicationManager.getApplication().isInternal()) {
            return;
        }
        if (this.myProgrammaticCollector.isEnabledInProject()) {
            this.myProgrammaticCollector.collect(indicator);
        }
    }

    public void onSuccess() {
        if (this.getProject().isDisposed()) {
            return;
        }
        if (this.myUnmappedCollector == null || this.myProgrammaticCollector == null) {
            return;
        }
        List<PsiElement> programmaticResults = this.myProgrammaticCollector.getResults();
        if (!this.myUnmappedCollector.hasResults() && programmaticResults.isEmpty()) {
            return;
        }
        MultiMap unmappedFilesCount = MultiMap.create();
        String notification = "";
        if (this.myUnmappedCollector.hasResults()) {
            Processor fileTypeCounterProcessor = psiFile -> {
                unmappedFilesCount.putValue((Object)psiFile.getFileType().getDefaultExtension(), psiFile);
                return true;
            };
            String unmappedFilesText = "";
            boolean atLeastOneModuleWithoutFacet = false;
            for (Pair<Module, Collection<PsiFile>> entry : this.myUnmappedCollector.getModulesWithUnmappedFiles()) {
                Module module = (Module)entry.getFirst();
                String moduleName = module.getName();
                Collection files = (Collection)entry.getSecond();
                int filesCount = files.size();
                unmappedFilesText = unmappedFilesText + "<a href=\"config#" + moduleName + "\">" + moduleName + "</a>";
                unmappedFilesText = unmappedFilesText + " (<a href=\"files#" + moduleName + "\">" + filesCount + " " + StringUtil.pluralize((String)"file", (int)filesCount) + "</a>)";
                if (SpringFacet.getInstance((Module)module) == null) {
                    unmappedFilesText = unmappedFilesText + "&nbsp;&nbsp;&nbsp;<a href=\"createDefault#" + moduleName + "\">" + CREATE_DEFAULT_CONTEXT_LABEL + "</a>";
                    atLeastOneModuleWithoutFacet = true;
                }
                unmappedFilesText = unmappedFilesText + "<br/>";
                ContainerUtil.process((Iterable)files, (Processor)fileTypeCounterProcessor);
            }
            String fixInstruction = atLeastOneModuleWithoutFacet ? "Please configure Spring facet or use 'Create Default Context'<br/>to add one including all unmapped files." : "Please configure Spring facet.";
            notification = notification + "Unmapped Spring configuration files found.<br/><br/>" + fixInstruction + "<br/><br/>" + unmappedFilesText;
        }
        if (!programmaticResults.isEmpty()) {
            notification = notification + (!notification.isEmpty() ? "<br/>" : "") + "Programmatic contexts found:<br/>";
            for (int i = 0; i < programmaticResults.size(); ++i) {
                PsiElement psiElement = programmaticResults.get(i);
                PsiFile psiFile2 = psiElement.getContainingFile();
                notification = notification + "<a href=\"psi#" + i + "\">" + psiFile2.getName() + "</a><br/>";
                unmappedFilesCount.putValue((Object)(psiFile2.getFileType().getDefaultExtension() + ".Programmatic"), (Object)psiFile2);
            }
        }
        for (Map.Entry entry : unmappedFilesCount.entrySet()) {
            String configFileTypeKey = (String)entry.getKey();
            for (int i = 0; i < ((Collection)entry.getValue()).size(); ++i) {
                UsageTrigger.trigger((String)("spring.SpringConfigurationCheck.FileCount." + configFileTypeKey));
            }
        }
        this.createNotification(notification, programmaticResults).addAction((AnAction)new NotificationAction("Show Help"){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/spring/facet/validation/SpringConfigurationCheckTask$3", "actionPerformed"));
                }
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/spring/facet/validation/SpringConfigurationCheckTask$3", "actionPerformed"));
                }
                HelpManager.getInstance().invokeHelp("spring.managing.file.sets");
            }
        }).addAction((AnAction)new NotificationAction("Disable..."){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/spring/facet/validation/SpringConfigurationCheckTask$2", "actionPerformed"));
                }
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/spring/facet/validation/SpringConfigurationCheckTask$2", "actionPerformed"));
                }
                int result = Messages.showYesNoDialog((Project)SpringConfigurationCheckTask.this.getProject(), (String)"Detection will be disabled for whole project.\nNote that most Spring related features will not work if Spring facet configuration is not performed.\n\nProject Structure | Facets | Detection\ncan be used to exclude specific files/folders only and to re-enable.", (String)"Spring Config Detection", (String)"Disable Detection", (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon());
                if (result == 0) {
                    DetectionExcludesConfiguration detectionExcludesConfiguration = DetectionExcludesConfiguration.getInstance((Project)SpringConfigurationCheckTask.this.getProject());
                    detectionExcludesConfiguration.addExcludedFramework(SpringFrameworkDetector.SPRING_FRAMEWORK_TYPE);
                    notification.hideBalloon();
                }
            }
        }).setIcon(SpringApiIcons.Spring).notify(this.getProject());
    }

    @NotNull
    private Notification createNotification(String notificationText, List<PsiElement> programmaticResults) {
        Notification notification = NOTIFICATION_GROUP.createNotification(NOTIFICATION_ID, notificationText, NotificationType.WARNING, (NotificationListener)new MyNotificationAdapter(programmaticResults));
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/validation/SpringConfigurationCheckTask", "createNotification"));
        }
        return notification;
    }

    private /* synthetic */ void lambda$run$2(ProgressIndicator innerIndicator) {
        try {
            this.dumbService.runReadActionInSmartMode(() -> this.runCollectors(innerIndicator));
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void lambda$run$0(ProgressIndicator innerIndicator, Disposable disposable) {
        ProgressIndicatorUtils.forceWriteActionPriority((ProgressIndicator)innerIndicator, (Disposable)disposable);
    }

    private class MyNotificationAdapter
    extends NotificationListener.Adapter {
        private final List<PsiElement> myProgrammaticResults;

        private MyNotificationAdapter(List<PsiElement> programmaticResults) {
            this.myProgrammaticResults = programmaticResults;
        }

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/spring/facet/validation/SpringConfigurationCheckTask$MyNotificationAdapter", "hyperlinkActivated"));
            }
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/spring/facet/validation/SpringConfigurationCheckTask$MyNotificationAdapter", "hyperlinkActivated"));
            }
            if (SpringConfigurationCheckTask.this.getProject().isDisposed()) {
                return;
            }
            String description = e.getDescription();
            String navigationTarget = StringUtil.substringAfter((String)description, (String)"#");
            assert (navigationTarget != null);
            if (description.startsWith("config")) {
                Module module = this.findModuleByName(navigationTarget);
                if (module == null) {
                    return;
                }
                SpringFacet springFacet = SpringFacet.getInstance((Module)module);
                if (springFacet != null) {
                    ModulesConfigurator.showFacetSettingsDialog((Facet)springFacet, null);
                } else {
                    ModulesConfigurator.showDialog((Project)SpringConfigurationCheckTask.this.getProject(), (String)navigationTarget, null);
                }
            } else if (description.startsWith("createDefault")) {
                Module module = this.findModuleByName(navigationTarget);
                if (module == null) {
                    return;
                }
                DumbService dumbService = DumbService.getInstance((Project)SpringConfigurationCheckTask.this.getProject());
                if (dumbService.isDumb()) {
                    dumbService.showDumbModeNotification("'Create Default Context' is not available during index update");
                    return;
                }
                if (SpringFacet.getInstance((Module)module) != null) {
                    Messages.showWarningDialog((Project)SpringConfigurationCheckTask.this.getProject(), (String)("Cannot setup Default Context, Spring Facet already exists for module " + navigationTarget), (String)"Spring Configuration");
                    return;
                }
                SpringFacet springFacet = (SpringFacet)FacetUtil.addFacet((Module)module, (FacetType)SpringFacet.getSpringFacetType());
                for (SpringModelProvider provider : (SpringModelProvider[])SpringModelProvider.EP_NAME.getExtensions()) {
                    if (provider.getFilesets(springFacet).isEmpty()) continue;
                    int result = Messages.showYesNoDialog((Project)SpringConfigurationCheckTask.this.getProject(), (String)("Autodetected context found for " + provider.getName() + ".\n" + "Please check and setup additional manual context (if required)."), (String)"Spring Configuration", (String)"Open Facet Configuration", (String)CommonBundle.getCloseButtonText(), (Icon)Messages.getInformationIcon());
                    if (result == 0) {
                        ModulesConfigurator.showFacetSettingsDialog((Facet)springFacet, null);
                    }
                    this.hideNotificationIfOnlyOneModule(notification);
                    return;
                }
                Set existingFileSets = Collections.emptySet();
                String id = SpringFileSetService.getInstance().getUniqueId(existingFileSets);
                String name = SpringFileSetService.getInstance().getUniqueName(SpringBundle.message("facet.context.default.name", new Object[0]), existingFileSets);
                SpringFileSet fileSet = springFacet.addFileSet(id, name);
                Collection<PsiFile> files = SpringConfigurationCheckTask.this.myUnmappedCollector.getUnmappedFilesFor(module);
                for (PsiFile file : files) {
                    fileSet.addFile(file.getVirtualFile());
                }
                this.hideNotificationIfOnlyOneModule(notification);
            } else if (description.startsWith("files")) {
                Module module = this.findModuleByName(navigationTarget);
                if (module == null) {
                    return;
                }
                Collection<PsiFile> files = SpringConfigurationCheckTask.this.myUnmappedCollector.getUnmappedFilesFor(module);
                JBPopup popup = NavigationUtil.getPsiElementPopup((PsiElement[])((PsiElement[])ArrayUtil.toObjectArray(files, PsiFile.class)), (String)("Unmapped Spring Configuration Files in " + navigationTarget));
                Object event = e.getSource();
                if (event instanceof Component) {
                    popup.showInCenterOf((Component)event);
                } else {
                    popup.showInFocusCenter();
                }
            } else if (description.startsWith("psi")) {
                PsiElement element = this.myProgrammaticResults.get(Integer.parseInt(navigationTarget));
                NavigationUtil.activateFileWithPsiElement((PsiElement)element);
            }
        }

        private void hideNotificationIfOnlyOneModule(@NotNull Notification notification) {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/spring/facet/validation/SpringConfigurationCheckTask$MyNotificationAdapter", "hideNotificationIfOnlyOneModule"));
            }
            if (SpringConfigurationCheckTask.this.myUnmappedCollector.getModulesWithUnmappedFiles().size() == 1) {
                notification.expire();
            }
        }

        @Nullable
        private Module findModuleByName(String navigationTarget) {
            return ModuleManager.getInstance((Project)SpringConfigurationCheckTask.this.getProject()).findModuleByName(navigationTarget);
        }
    }
}

