/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model;

import com.intellij.psi.PsiType;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SimpleSpringBeanPointer;
import com.intellij.spring.model.SpringBeanEffectiveTypeProvider;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringBeanPsiTarget;
import com.intellij.spring.model.SpringImplicitBeanWithDefinition;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.JamSpringBeanPointerImpl;
import com.intellij.spring.model.xml.CustomBean;
import com.intellij.spring.model.xml.CustomSpringBeanPointer;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.DomSpringBeanPointerImpl;
import com.intellij.spring.model.xml.SpringBeanDomPointerImpl;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class BeanServiceImpl
extends BeanService {
    private final Function<CommonSpringBean, SpringBeanPointer> myBeanToPointer = this::createSpringBeanPointer;

    @NotNull
    public PsiType[] getEffectiveBeanTypes(@NotNull CommonSpringBean bean) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/spring/model/BeanServiceImpl", "getEffectiveBeanTypes"));
        }
        THashSet effectiveTypes = new THashSet(1);
        ContainerUtil.addIfNotNull((Object)bean.getBeanType(), (Collection)effectiveTypes);
        for (SpringBeanEffectiveTypeProvider provider : (SpringBeanEffectiveTypeProvider[])SpringBeanEffectiveTypeProvider.EP_NAME.getExtensions()) {
            provider.processEffectiveTypes(bean, (Collection)effectiveTypes);
        }
        PsiType[] psiTypeArray = effectiveTypes.toArray(new PsiType[effectiveTypes.size()]);
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/BeanServiceImpl", "getEffectiveBeanTypes"));
        }
        return psiTypeArray;
    }

    @NotNull
    public SpringBeanPointer createSpringBeanPointer(@NotNull CommonSpringBean springBean) {
        if (springBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springBean", "com/intellij/spring/model/BeanServiceImpl", "createSpringBeanPointer"));
        }
        if (springBean instanceof DomSpringBean) {
            if (springBean instanceof SpringBean) {
                SpringBeanDomPointerImpl springBeanDomPointerImpl = new SpringBeanDomPointerImpl((SpringBean)springBean);
                if (springBeanDomPointerImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/BeanServiceImpl", "createSpringBeanPointer"));
                }
                return springBeanDomPointerImpl;
            }
            DomSpringBeanPointerImpl domSpringBeanPointerImpl = new DomSpringBeanPointerImpl((DomSpringBean)springBean);
            if (domSpringBeanPointerImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/BeanServiceImpl", "createSpringBeanPointer"));
            }
            return domSpringBeanPointerImpl;
        }
        if (springBean instanceof JamPsiMemberSpringBean) {
            JamSpringBeanPointerImpl jamSpringBeanPointerImpl = new JamSpringBeanPointerImpl((JamPsiMemberSpringBean)springBean);
            if (jamSpringBeanPointerImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/BeanServiceImpl", "createSpringBeanPointer"));
            }
            return jamSpringBeanPointerImpl;
        }
        if (springBean instanceof CustomBean) {
            CustomSpringBeanPointer customSpringBeanPointer = CustomSpringBeanPointer.createCustomSpringBeanPointer((CustomBean)springBean);
            if (customSpringBeanPointer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/BeanServiceImpl", "createSpringBeanPointer"));
            }
            return customSpringBeanPointer;
        }
        if (springBean instanceof SpringImplicitBeanWithDefinition) {
            SimpleSpringBeanPointer<SpringImplicitBeanWithDefinition> simpleSpringBeanPointer = new SimpleSpringBeanPointer<SpringImplicitBeanWithDefinition>((SpringImplicitBeanWithDefinition)springBean);
            if (simpleSpringBeanPointer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/BeanServiceImpl", "createSpringBeanPointer"));
            }
            return simpleSpringBeanPointer;
        }
        throw new AssertionError((Object)("Unknown bean type: " + springBean));
    }

    @NotNull
    public SpringBeanPsiTarget createSpringBeanPsiTarget(@NotNull CommonSpringBean springBean) {
        if (springBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springBean", "com/intellij/spring/model/BeanServiceImpl", "createSpringBeanPsiTarget"));
        }
        if (springBean instanceof DomSpringBean) {
            SpringBeanPsiTarget springBeanPsiTarget = DomSpringBeanPointerImpl.createSpringBeanPsiTarget((DomSpringBean)springBean);
            if (springBeanPsiTarget == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/BeanServiceImpl", "createSpringBeanPsiTarget"));
            }
            return springBeanPsiTarget;
        }
        throw new IllegalArgumentException("Unsupported bean type: " + springBean);
    }

    @NotNull
    public Set<SpringBeanPointer> mapSpringBeans(@NotNull Collection<? extends CommonSpringBean> beans) {
        if (beans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beans", "com/intellij/spring/model/BeanServiceImpl", "mapSpringBeans"));
        }
        if (beans.isEmpty()) {
            Set<SpringBeanPointer> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/BeanServiceImpl", "mapSpringBeans"));
            }
            return set;
        }
        LinkedHashSet<SpringBeanPointer> set = new LinkedHashSet<SpringBeanPointer>(beans.size());
        for (CommonSpringBean commonSpringBean : beans) {
            if (!commonSpringBean.isValid()) continue;
            set.add((SpringBeanPointer)this.myBeanToPointer.fun((Object)commonSpringBean));
        }
        LinkedHashSet<SpringBeanPointer> linkedHashSet = set;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/BeanServiceImpl", "mapSpringBeans"));
        }
        return linkedHashSet;
    }
}

