/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.cacheable.jam;

import com.intellij.jam.JamConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNamedElement;
import com.intellij.semantic.SemKey;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.cacheable.jam.SpringJamCacheableElement;
import com.intellij.spring.model.jam.converters.SpringBeanReferenceJamConverter;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class SpringJamBaseCacheableElement<T extends PsiMember & PsiNamedElement>
extends SpringJamCacheableElement<T> {
    public static final String VALUE_ATTR_NAME = "value";
    public static final String CACHE_NAMES_ATTR_NAME = "cacheNames";
    public static final String CONDITION_ATTR_NAME = "condition";
    public static final String UNLESS_ATTR_NAME = "unless";
    public static final String KEY_ATTR_NAME = "key";
    private static final JamStringAttributeMeta.Single<String> CONDITION_ATTR_META = JamAttributeMeta.singleString((String)"condition");
    public static final SemKey<SpringJamBaseCacheableElement> CACHEABLE_BASE_JAM_KEY = CACHEABLE_ROOT_JAM_KEY.subKey("SpringJamBaseCacheableElement", new SemKey[0]);
    public static final JamStringAttributeMeta.Collection<String> VALUE_ATTR_META = JamAttributeMeta.collectionString((String)"value");
    public static final JamStringAttributeMeta.Collection<String> CACHE_NAMES_ATTR_META = JamAttributeMeta.collectionString((String)"cacheNames");
    public static final JamStringAttributeMeta.Single<SpringBeanPointer> KEY_GENERATOR_ATTR_META = JamAttributeMeta.singleString((String)"keyGenerator", (JamConverter)new SpringBeanReferenceJamConverter("org.springframework.cache.interceptor.KeyGenerator"));
    public static final JamStringAttributeMeta.Single<SpringBeanPointer> CACHE_MANAGER_ATTR_META = JamAttributeMeta.singleString((String)"cacheManager", (JamConverter)new SpringBeanReferenceJamConverter("org.springframework.cache.CacheManager"));
    public static final JamStringAttributeMeta.Single<SpringBeanPointer> CACHE_RESOLVER_ATTR_META = JamAttributeMeta.singleString((String)"cacheResolver", (JamConverter)new SpringBeanReferenceJamConverter("org.springframework.cache.interceptor.CacheResolver"));

    public SpringJamBaseCacheableElement(String annoName, T t) {
        super(t, annoName);
    }

    @NotNull
    public JamStringAttributeElement<String> getConditionAttributeElement() {
        JamStringAttributeElement jamStringAttributeElement = CONDITION_ATTR_META.getJam(this.getPsiAnnotationRef());
        if (jamStringAttributeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/cacheable/jam/SpringJamBaseCacheableElement", "getConditionAttributeElement"));
        }
        return jamStringAttributeElement;
    }

    @NotNull
    public List<JamStringAttributeElement<String>> getValueElement() {
        List list = VALUE_ATTR_META.getJam(this.getPsiAnnotationRef());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/cacheable/jam/SpringJamBaseCacheableElement", "getValueElement"));
        }
        return list;
    }

    @NotNull
    public List<JamStringAttributeElement<String>> getCacheNamesElement() {
        List list = CACHE_NAMES_ATTR_META.getJam(this.getPsiAnnotationRef());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/cacheable/jam/SpringJamBaseCacheableElement", "getCacheNamesElement"));
        }
        return list;
    }

    @NotNull
    public JamStringAttributeElement<SpringBeanPointer> getCacheManagerElement() {
        JamStringAttributeElement jamStringAttributeElement = CACHE_MANAGER_ATTR_META.getJam(this.getPsiAnnotationRef());
        if (jamStringAttributeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/cacheable/jam/SpringJamBaseCacheableElement", "getCacheManagerElement"));
        }
        return jamStringAttributeElement;
    }

    @NotNull
    public JamStringAttributeElement<SpringBeanPointer> getCacheResolverElement() {
        JamStringAttributeElement jamStringAttributeElement = CACHE_RESOLVER_ATTR_META.getJam(this.getPsiAnnotationRef());
        if (jamStringAttributeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/cacheable/jam/SpringJamBaseCacheableElement", "getCacheResolverElement"));
        }
        return jamStringAttributeElement;
    }

    @NotNull
    public JamStringAttributeElement<SpringBeanPointer> getKeyGeneratorElement() {
        JamStringAttributeElement jamStringAttributeElement = KEY_GENERATOR_ATTR_META.getJam(this.getPsiAnnotationRef());
        if (jamStringAttributeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/cacheable/jam/SpringJamBaseCacheableElement", "getKeyGeneratorElement"));
        }
        return jamStringAttributeElement;
    }

    @Override
    @NotNull
    public Set<String> getCacheNames() {
        LinkedHashSet names = ContainerUtil.newLinkedHashSet();
        names.addAll(ContainerUtil.mapNotNull(this.getValueElement(), JamStringAttributeElement::getStringValue));
        names.addAll(ContainerUtil.mapNotNull(this.getCacheNamesElement(), JamStringAttributeElement::getStringValue));
        LinkedHashSet linkedHashSet = names;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/cacheable/jam/SpringJamBaseCacheableElement", "getCacheNames"));
        }
        return linkedHashSet;
    }
}

