/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.DelimitedListProcessor;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.model.converters.PsiClassListConverter;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ExtendClass;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.PsiClassConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiClassListConverterImpl
extends PsiClassListConverter {
    @NotNull
    public Collection<PsiClass> fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/PsiClassListConverterImpl", "fromString"));
            }
            return list;
        }
        if (context.getXmlElement() == null) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/PsiClassListConverterImpl", "fromString"));
            }
            return list;
        }
        PsiReference[] psiReferences = this.createReferences((GenericDomValue)context.getInvocationElement(), (PsiElement)context.getXmlElement(), context);
        LinkedHashSet<PsiClass> list = new LinkedHashSet<PsiClass>();
        for (PsiReference psiReference : psiReferences) {
            PsiElement psiElement = psiReference.resolve();
            if (!(psiElement instanceof PsiClass)) continue;
            list.add((PsiClass)psiElement);
        }
        LinkedHashSet<PsiClass> linkedHashSet = list;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/PsiClassListConverterImpl", "fromString"));
        }
        return linkedHashSet;
    }

    public String toString(@Nullable Collection<PsiClass> psiPackages, ConvertContext context) {
        return "";
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue genericDomValue, final PsiElement element, final ConvertContext context) {
        final String text = genericDomValue.getStringValue();
        if (text == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/PsiClassListConverterImpl", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        final int startInElement = ElementManipulators.getOffsetInElement((PsiElement)element);
        final ArrayList list = new ArrayList();
        final JavaClassReferenceProvider referenceProvider = PsiClassConverter.createJavaClassReferenceProvider((GenericDomValue)genericDomValue, (ExtendClass)((ExtendClass)genericDomValue.getAnnotation(ExtendClass.class)), (JavaClassReferenceProvider)new JavaClassReferenceProvider(){

            public GlobalSearchScope getScope(Project project) {
                return context.getSearchScope();
            }
        });
        new DelimitedListProcessor(",; \n\t"){

            protected void processToken(int start, int end, boolean delimitersOnly) {
                String substring = text.substring(start, end);
                PsiReference[] references = referenceProvider.getReferencesByString(substring, element, startInElement + start);
                list.addAll(Arrays.asList(references));
            }
        }.processText(text);
        PsiReference[] psiReferenceArray = list.toArray(new PsiReference[list.size()]);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/PsiClassListConverterImpl", "createReferences"));
        }
        return psiReferenceArray;
    }
}

