/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.model.highlighting.SpringAutowireUtil;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringAutowiredFieldsWarningInspection
extends BaseJavaLocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/model/highlighting/SpringAutowiredFieldsWarningInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/model/highlighting/SpringAutowiredFieldsWarningInspection", "checkClass"));
        }
        PsiFile file = aClass.getContainingFile();
        if (JamCommonUtil.isPlainJavaFile((PsiElement)file) && !ProjectRootsUtil.isInTestSource((PsiFile)file)) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass);
            if (!SpringCommonUtils.isSpringBeanCandidateClassInSpringProject((PsiClass)aClass)) {
                return ProblemDescriptor.EMPTY_ARRAY;
            }
            if (SpringCommonUtils.isConfigurationOrMeta((PsiClass)aClass) && !SpringLibraryUtil.isAtLeastVersion((Module)module, (SpringLibraryUtil.SpringVersion)SpringLibraryUtil.SpringVersion.V_4_3)) {
                return ProblemDescriptor.EMPTY_ARRAY;
            }
            ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
            Set<String> annotations = SpringAutowireUtil.getAutowiredAnnotations(module);
            Set<Pair<PsiField, PsiAnnotation>> autowiredFields = SpringAutowiredFieldsWarningInspection.getAutowiredFields(aClass, annotations);
            LocalQuickFix allFieldsFix = null;
            if (autowiredFields.size() > 1) {
                allFieldsFix = SpringAutowiredFieldsWarningInspection.getFieldsAutowiredFix(aClass, autowiredFields, annotations);
            }
            for (Pair<PsiField, PsiAnnotation> pair : autowiredFields) {
                LocalQuickFix[] localQuickFixArray;
                LocalQuickFix fieldFx = SpringAutowiredFieldsWarningInspection.getFieldsAutowiredFix(aClass, Collections.singleton(pair), annotations);
                if (allFieldsFix != null) {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[2];
                    localQuickFixArray2[0] = fieldFx;
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[1] = allFieldsFix;
                } else {
                    LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray3;
                    localQuickFixArray3[0] = fieldFx;
                }
                LocalQuickFix[] fixes = localQuickFixArray;
                holder.registerProblem((PsiElement)pair.getSecond(), SpringBundle.message("field.injection.is.not.recommended", new Object[0]), fixes);
            }
            return holder.getResultsArray();
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    private static Set<Pair<PsiField, PsiAnnotation>> getAutowiredFields(@NotNull PsiClass aClass, @NotNull Set<String> annotations) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/model/highlighting/SpringAutowiredFieldsWarningInspection", "getAutowiredFields"));
        }
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/spring/model/highlighting/SpringAutowiredFieldsWarningInspection", "getAutowiredFields"));
        }
        HashSet pairs = ContainerUtil.newHashSet();
        for (PsiField psiField : aClass.getFields()) {
            for (String autowiredAnno : annotations) {
                if (autowiredAnno.equals("javax.annotation.Resource")) continue;
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiField, (String[])new String[]{autowiredAnno});
                if (annotation == null) continue;
                pairs.add(Pair.create((Object)psiField, (Object)annotation));
            }
        }
        return pairs;
    }

    private static LocalQuickFix getFieldsAutowiredFix(PsiClass aClass, Set<Pair<PsiField, PsiAnnotation>> fields, Set<String> annotations) {
        PsiMethod constructor = SpringAutowiredFieldsWarningInspection.findAutowiredConstructor(aClass, annotations);
        return constructor != null ? new AddParameterQuickFix(constructor, fields) : new CreateAutowiredConstructorQuickFix(aClass, fields);
    }

    @Nullable
    private static PsiMethod findAutowiredConstructor(@NotNull PsiClass aClass, @NotNull Set<String> annotations) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/model/highlighting/SpringAutowiredFieldsWarningInspection", "findAutowiredConstructor"));
        }
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/spring/model/highlighting/SpringAutowiredFieldsWarningInspection", "findAutowiredConstructor"));
        }
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 1) {
            return constructors[0];
        }
        for (PsiMethod method : constructors) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)method, annotations)) continue;
            return method;
        }
        return null;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringAutowiredFieldsWarningInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringAutowiredFieldsWarningInspection", "getShortName"));
        }
        return "SpringAutowiredFieldsWarningInspection";
    }

    private static void addParameters(Set<Pair<PsiField, PsiAnnotation>> myParameterCandidates, PsiMethod constructor) {
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)constructor.getProject()).getElementFactory();
        boolean hasAutowiredAnno = AnnotationUtil.isAnnotated((PsiModifierListOwner)constructor, SpringAutowireUtil.getAutowiredAnnotations(ModuleUtilCore.findModuleForPsiElement((PsiElement)constructor)));
        for (Pair<PsiField, PsiAnnotation> pair : myParameterCandidates) {
            PsiModifierList fieldModifierList;
            PsiCodeBlock body;
            PsiField field = (PsiField)pair.first;
            PsiAnnotation annotation = (PsiAnnotation)pair.second;
            String name = field.getName();
            if (StringUtil.isEmptyOrSpaces((String)name)) {
                return;
            }
            PsiParameter parameter = elementFactory.createParameter(name, field.getType());
            PsiModifierList modifierList = parameter.getModifierList();
            if (modifierList != null) {
                for (PsiAnnotation qualifierAnno : SpringAutowiredFieldsWarningInspection.getQualifierAnnotations((PsiField)pair.first)) {
                    modifierList.add((PsiElement)elementFactory.createAnnotationFromText(qualifierAnno.getText(), (PsiElement)modifierList));
                    qualifierAnno.delete();
                }
            }
            constructor.getParameterList().add((PsiElement)parameter);
            if (!hasAutowiredAnno) {
                constructor.getModifierList().addBefore((PsiElement)elementFactory.createAnnotationFromText(annotation.getText(), (PsiElement)constructor), constructor.getModifierList().getFirstChild());
                hasAutowiredAnno = true;
            }
            if ((body = constructor.getBody()) != null) {
                body.add((PsiElement)elementFactory.createStatementFromText("this." + name + " = " + name + ";", (PsiElement)constructor));
            }
            if ((fieldModifierList = field.getModifierList()) != null && !fieldModifierList.hasModifierProperty("final")) {
                fieldModifierList.setModifierProperty("final", true);
            }
            annotation.delete();
        }
    }

    private static PsiAnnotation[] getQualifierAnnotations(@NotNull PsiField first) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/spring/model/highlighting/SpringAutowiredFieldsWarningInspection", "getQualifierAnnotations"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)first);
        if (module == null) {
            return PsiAnnotation.EMPTY_ARRAY;
        }
        List strings = ContainerUtil.mapNotNull((Collection)JamAnnotationTypeUtil.getInstance((Module)module).getQualifierAnnotationTypesWithChildren(), PsiClass::getQualifiedName);
        List vs = ContainerUtil.mapNotNull((Collection)strings, s -> {
            if (first == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/spring/model/highlighting/SpringAutowiredFieldsWarningInspection", "lambda$getQualifierAnnotations$0"));
            }
            return AnnotationUtil.findAnnotation((PsiModifierListOwner)first, (String[])new String[]{s});
        });
        return vs.toArray(new PsiAnnotation[vs.size()]);
    }

    @NotNull
    private static String getConstructorName(@Nullable PsiMethod psiMethod, @NotNull Set<Pair<PsiField, PsiAnnotation>> parameterCandidates) {
        if (parameterCandidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterCandidates", "com/intellij/spring/model/highlighting/SpringAutowiredFieldsWarningInspection", "getConstructorName"));
        }
        StringBuilder sb = new StringBuilder();
        if (psiMethod != null) {
            sb.append(psiMethod.getName());
            sb.append("(");
            for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
                sb.append(parameter.getType().getPresentableText());
                sb.append(",");
            }
            SpringAutowiredFieldsWarningInspection.addNewParameters(parameterCandidates, sb);
            sb.append(")");
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringAutowiredFieldsWarningInspection", "getConstructorName"));
        }
        return string;
    }

    @NotNull
    private static String getConstructorName(@Nullable String name, @NotNull Set<Pair<PsiField, PsiAnnotation>> parameterCandidates) {
        if (parameterCandidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterCandidates", "com/intellij/spring/model/highlighting/SpringAutowiredFieldsWarningInspection", "getConstructorName"));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append("(");
        SpringAutowiredFieldsWarningInspection.addNewParameters(parameterCandidates, sb);
        sb.append(")");
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringAutowiredFieldsWarningInspection", "getConstructorName"));
        }
        return string;
    }

    private static void addNewParameters(@NotNull Set<Pair<PsiField, PsiAnnotation>> parameterCandidates, StringBuilder sb) {
        if (parameterCandidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterCandidates", "com/intellij/spring/model/highlighting/SpringAutowiredFieldsWarningInspection", "addNewParameters"));
        }
        HashSet newParams = ContainerUtil.newHashSet();
        for (Pair<PsiField, PsiAnnotation> pair : parameterCandidates) {
            newParams.add("<b>" + ((PsiField)pair.first).getType().getPresentableText() + "</b>");
        }
        sb.append(StringUtil.join((Collection)newParams, (String)","));
    }

    private static class AddParameterQuickFix
    implements LocalQuickFix {
        private final SmartPsiElementPointer<PsiMethod> myConstructor;
        private final Set<Pair<PsiField, PsiAnnotation>> myParameterCandidates;

        public AddParameterQuickFix(@NotNull PsiMethod constructor, @NotNull Set<Pair<PsiField, PsiAnnotation>> pairs) {
            if (constructor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/spring/model/highlighting/SpringAutowiredFieldsWarningInspection$AddParameterQuickFix", "<init>"));
            }
            if (pairs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pairs", "com/intellij/spring/model/highlighting/SpringAutowiredFieldsWarningInspection$AddParameterQuickFix", "<init>"));
            }
            this.myConstructor = SmartPointerManager.getInstance((Project)constructor.getProject()).createSmartPsiElementPointer((PsiElement)constructor);
            this.myParameterCandidates = pairs;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = SpringBundle.message("field.injection.add.parameters", SpringAutowiredFieldsWarningInspection.getConstructorName((PsiMethod)this.myConstructor.getElement(), (Set<Pair<PsiField, PsiAnnotation>>)this.myParameterCandidates));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringAutowiredFieldsWarningInspection$AddParameterQuickFix", "getName"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = SpringBundle.message("field.injection.warning", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringAutowiredFieldsWarningInspection$AddParameterQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/highlighting/SpringAutowiredFieldsWarningInspection$AddParameterQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/model/highlighting/SpringAutowiredFieldsWarningInspection$AddParameterQuickFix", "applyFix"));
            }
            PsiMethod constructor = (PsiMethod)this.myConstructor.getElement();
            if (constructor == null || !FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)constructor.getContainingFile())) {
                return;
            }
            SpringAutowiredFieldsWarningInspection.addParameters(this.myParameterCandidates, constructor);
        }
    }

    private static class CreateAutowiredConstructorQuickFix
    implements LocalQuickFix {
        private final SmartPsiElementPointer<PsiClass> myClass;
        private final Set<Pair<PsiField, PsiAnnotation>> myParameterCandidates;

        public CreateAutowiredConstructorQuickFix(PsiClass containingClass, @NotNull Set<Pair<PsiField, PsiAnnotation>> pairs) {
            if (pairs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pairs", "com/intellij/spring/model/highlighting/SpringAutowiredFieldsWarningInspection$CreateAutowiredConstructorQuickFix", "<init>"));
            }
            this.myClass = SmartPointerManager.getInstance((Project)containingClass.getProject()).createSmartPsiElementPointer((PsiElement)containingClass);
            this.myParameterCandidates = pairs;
        }

        @Nls
        @NotNull
        public String getName() {
            PsiClass psiClass = (PsiClass)this.myClass.getElement();
            assert (psiClass != null);
            String string = SpringBundle.message("field.injection.create.constructor.injection", SpringAutowiredFieldsWarningInspection.getConstructorName(psiClass.getName(), (Set<Pair<PsiField, PsiAnnotation>>)this.myParameterCandidates));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringAutowiredFieldsWarningInspection$CreateAutowiredConstructorQuickFix", "getName"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = SpringBundle.message("field.injection.warning", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringAutowiredFieldsWarningInspection$CreateAutowiredConstructorQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/highlighting/SpringAutowiredFieldsWarningInspection$CreateAutowiredConstructorQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/model/highlighting/SpringAutowiredFieldsWarningInspection$CreateAutowiredConstructorQuickFix", "applyFix"));
            }
            PsiClass containingClass = (PsiClass)this.myClass.getElement();
            if (containingClass == null) {
                return;
            }
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)this.myClass.getContainingFile())) {
                return;
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiMethod constructor = elementFactory.createConstructor();
            PsiUtil.setModifierProperty((PsiModifierListOwner)constructor, (String)"public", (boolean)true);
            SpringAutowiredFieldsWarningInspection.addParameters(this.myParameterCandidates, constructor);
            containingClass.add((PsiElement)constructor);
        }
    }
}

