/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.config;

import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.facet.Facet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class SetupProgrammaticContextFix
extends LocalQuickFixOnPsiElement {
    SetupProgrammaticContextFix(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/highlighting/config/SetupProgrammaticContextFix", "<init>"));
        }
        super(element);
    }

    @NotNull
    public String getText() {
        if ("Setup Spring context..." == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/config/SetupProgrammaticContextFix", "getText"));
        }
        return "Setup Spring context...";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/config/SetupProgrammaticContextFix", "getFamilyName"));
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/highlighting/config/SetupProgrammaticContextFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/model/highlighting/config/SetupProgrammaticContextFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/spring/model/highlighting/config/SetupProgrammaticContextFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/spring/model/highlighting/config/SetupProgrammaticContextFix", "invoke"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        SpringFacet springFacet = SpringFacet.getInstance((Module)module);
        assert (springFacet != null);
        SpringFileSet fileSet = SetupProgrammaticContextFix.createFileSet(startElement, springFacet);
        int dialog = Messages.showYesNoDialog((Project)project, (String)("Context with name '" + fileSet.getName() + "' has been created.\n" + "Please use inspection suppression to disable highlighting.\n\n" + "To re-create context, delete it in Spring facet and remove inspection suppression.\n\n" + "Do you want to open Spring facet now?"), (String)"Spring", null);
        if (dialog == 0) {
            ModulesConfigurator.showFacetSettingsDialog((Facet)springFacet, null);
        }
    }

    private static SpringFileSet createFileSet(PsiElement startElement, SpringFacet springFacet) {
        SpringFileSetService fileSetService = SpringFileSetService.getInstance();
        Set existingFileSets = springFacet.getFileSets();
        String id = fileSetService.getUniqueId(existingFileSets);
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiClass.class);
        PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiMethod.class);
        String codeLocation = (psiClass != null ? psiClass.getName() : startElement.getContainingFile().getName()) + (psiMethod != null ? ":" + psiMethod.getName() : "");
        String name = fileSetService.getUniqueName("Programmatic Context " + codeLocation, existingFileSets);
        return springFacet.addFileSet(id, name);
    }
}

