/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.model.xml.converters;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SecurityExpressionRootMethodsUtil {
    @Nullable
    public static PsiMethod findExpressionRootMethod(@Nullable String methodName, @Nullable Module module) {
        if (module != null && methodName != null) {
            for (PsiMethod psiMethod : SecurityExpressionRootMethodsUtil.getExpressionRootMethods(module)) {
                if (!methodName.startsWith(psiMethod.getName())) continue;
                return psiMethod;
            }
        }
        return null;
    }

    @Nullable
    private static PsiClass getExpressionRootClass(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        PsiClass webSecurityExpressionRoot = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.security.web.access.expression.WebSecurityExpressionRoot");
        if (webSecurityExpressionRoot != null) {
            return webSecurityExpressionRoot;
        }
        return SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.security.access.expression.SecurityExpressionRoot");
    }

    @NotNull
    public static Set<PsiMethod> getExpressionRootMethods(@Nullable Module module) {
        Set<PsiMethod> set = SecurityExpressionRootMethodsUtil.getExpressionRootMethods(SecurityExpressionRootMethodsUtil.getExpressionRootClass(module));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/model/xml/converters/SecurityExpressionRootMethodsUtil", "getExpressionRootMethods"));
        }
        return set;
    }

    @NotNull
    private static Set<PsiMethod> getExpressionRootMethods(@Nullable PsiClass psiClass) {
        HashSet methods = ContainerUtil.newHashSet();
        if (psiClass != null) {
            for (PsiMethod psiMethod : psiClass.getAllMethods()) {
                PsiClass containingClass = psiMethod.getContainingClass();
                if (psiMethod.isConstructor() || containingClass == null || containingClass.isInterface() || "java.lang.Object".equals(containingClass.getQualifiedName()) || !PsiType.BOOLEAN.equals((Object)psiMethod.getReturnType())) continue;
                methods.add(psiMethod);
            }
        }
        HashSet hashSet = methods;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/model/xml/converters/SecurityExpressionRootMethodsUtil", "getExpressionRootMethods"));
        }
        return hashSet;
    }
}

